/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.utils;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\u0007\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u001e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005J\u001e\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0005J\u001e\u0010\u000e\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0005J.\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lme/mochibit/defcon/utils/MathFunctions;", "", "<init>", "()V", "TAU", "", "EPSILON", "EPSILON2", "MATH_SQRT2", "MATH_SQRT12", "clamp", "value", "min", "max", "lerp", "a", "b", "t", "", "", "remap", "inValueMin", "inValueMax", "outValueMin", "outValueMax", "Defcon"})
public final class MathFunctions {
    @NotNull
    public static final MathFunctions INSTANCE = new MathFunctions();
    public static final double TAU = Math.PI * 2;
    public static final double EPSILON = 1.0E-5;
    public static final double EPSILON2 = 1.0000000000000002E-10;
    public static final double MATH_SQRT2 = 1.4142135623730951;
    public static final double MATH_SQRT12 = 0.7071067811865476;

    private MathFunctions() {
    }

    public final double clamp(double value, double min, double max) {
        return value < min ? min : (value > max ? max : value);
    }

    public final double lerp(double a, double b, double t) {
        double clampedT = this.clamp(t, 0.0, 1.0);
        return a + clampedT * (b - a);
    }

    public final float lerp(float a, float b, double t) {
        return (float)this.lerp((double)a, (double)b, t);
    }

    public final int lerp(int a, int b, double t) {
        return (int)this.lerp((double)a, (double)b, t);
    }

    public final double remap(double value, double inValueMin, double inValueMax, double outValueMin, double outValueMax) {
        return (value - inValueMin) * (outValueMax - outValueMin) / (inValueMax - inValueMin) + outValueMin;
    }
}

