/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.vertexgeometry.morphers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.mochibit.defcon.utils.Geometry;
import me.mochibit.defcon.utils.MathFunctions;
import me.mochibit.defcon.vertexgeometry.morphers.ShapeMorpher;
import me.mochibit.defcon.vertexgeometry.vertexes.Vertex;
import org.bukkit.ChunkSnapshot;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u001e\u0010\t\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\r0\n\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J!\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u00162\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\t\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lme/mochibit/defcon/vertexgeometry/morphers/SnapToFloor;", "Lme/mochibit/defcon/vertexgeometry/morphers/ShapeMorpher;", "world", "Lorg/bukkit/World;", "maxDepth", "", "startYOffset", "easeFromPoint", "Lorg/joml/Vector3d;", "chunkSnapshotCache", "", "Lkotlin/Pair;", "", "Lorg/bukkit/ChunkSnapshot;", "<init>", "(Lorg/bukkit/World;DDLorg/joml/Vector3d;Ljava/util/Map;)V", "getWorld", "()Lorg/bukkit/World;", "morphVertex", "Lme/mochibit/defcon/vertexgeometry/vertexes/Vertex;", "basis", "morph", "", "([Lme/mochibit/defcon/vertexgeometry/vertexes/Vertex;)[Lme/mochibit/defcon/vertexgeometry/vertexes/Vertex;", "Defcon"})
@SourceDebugExtension(value={"SMAP\nSnapToFloor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnapToFloor.kt\nme/mochibit/defcon/vertexgeometry/morphers/SnapToFloor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,79:1\n11228#2:80\n11563#2,3:81\n37#3:84\n36#3,3:85\n*S KotlinDebug\n*F\n+ 1 SnapToFloor.kt\nme/mochibit/defcon/vertexgeometry/morphers/SnapToFloor\n*L\n77#1:80\n77#1:81,3\n77#1:84\n77#1:85,3\n*E\n"})
public final class SnapToFloor
implements ShapeMorpher {
    @NotNull
    private final World world;
    private final double maxDepth;
    private final double startYOffset;
    @Nullable
    private final Vector3d easeFromPoint;
    @NotNull
    private final Map<Pair<Integer, Integer>, ChunkSnapshot> chunkSnapshotCache;

    public SnapToFloor(@NotNull World world, double maxDepth, double startYOffset, @Nullable Vector3d easeFromPoint, @NotNull Map<Pair<Integer, Integer>, ChunkSnapshot> chunkSnapshotCache) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter(chunkSnapshotCache, (String)"chunkSnapshotCache");
        this.world = world;
        this.maxDepth = maxDepth;
        this.startYOffset = startYOffset;
        this.easeFromPoint = easeFromPoint;
        this.chunkSnapshotCache = chunkSnapshotCache;
    }

    public /* synthetic */ SnapToFloor(World world, double d, double d2, Vector3d vector3d, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 0.0;
        }
        if ((n & 4) != 0) {
            d2 = 0.0;
        }
        if ((n & 8) != 0) {
            vector3d = null;
        }
        this(world, d, d2, vector3d, map);
    }

    @NotNull
    public final World getWorld() {
        return this.world;
    }

    @Override
    @NotNull
    public Vertex morphVertex(@NotNull Vertex basis) {
        Intrinsics.checkNotNullParameter((Object)basis, (String)"basis");
        Vector3d point = basis.getPoint();
        Vector3d groundedLoc = Geometry.INSTANCE.getMinYUsingSnapshotFromCache(this.world, new Vector3d(basis.getGlobalPosition().x, basis.getGlobalPosition().y + this.startYOffset, basis.getGlobalPosition().z), this.maxDepth + this.startYOffset, this.chunkSnapshotCache);
        double finalY = 0.0;
        if (this.easeFromPoint != null) {
            double maxDistance;
            double distance = basis.getGlobalPosition().distance((Vector3dc)this.easeFromPoint);
            double t = MathFunctions.INSTANCE.clamp(distance / (maxDistance = 80.0), 0.0, 1.0);
            double smoothT = t < 0.5 ? (double)4 * t * t * t : 1.0 - Math.pow((double)-2 * t + (double)2, 3) / (double)2;
            Vector3d easedLoc = new Vector3d(basis.getGlobalPosition().x, basis.getGlobalPosition().y, basis.getGlobalPosition().z).lerp((Vector3dc)groundedLoc, smoothT);
            finalY = easedLoc.y;
        } else {
            finalY = groundedLoc.y;
        }
        basis.getGlobalPosition().y = finalY;
        return basis;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Vertex[] morph(@NotNull Vertex[] basis) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)basis, (String)"basis");
        Vertex[] $this$map$iv = basis;
        boolean $i$f$map = false;
        Vertex[] vertexArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.morphVertex((Vertex)it));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Vertex[0]);
    }
}

