/*
 * Decompiled with CFR 0.152.
 */
package io.github.retrooper.packetevents.injector.handlers;

import io.github.retrooper.packetevents.injector.connection.ServerConnectionInitializer;
import io.github.retrooper.packetevents.injector.handlers.PacketEventsEncoder;
import io.github.retrooper.packetevents.util.SpigotReflectionUtil;
import io.github.retrooper.packetevents.util.folia.FoliaScheduler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import me.mochibit.lib.packetevents.PacketEvents;
import me.mochibit.lib.packetevents.exception.PacketProcessException;
import me.mochibit.lib.packetevents.netty.buffer.ByteBufHelper;
import me.mochibit.lib.packetevents.protocol.ConnectionState;
import me.mochibit.lib.packetevents.protocol.player.User;
import me.mochibit.lib.packetevents.util.ExceptionUtil;
import me.mochibit.lib.packetevents.util.PacketEventsImplHelper;
import me.mochibit.lib.packetevents.wrapper.play.server.WrapperPlayServerDisconnect;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PacketEventsDecoder
extends MessageToMessageDecoder<ByteBuf> {
    public User user;
    public Player player;
    public boolean hasBeenRelocated;

    public PacketEventsDecoder(User user) {
        this.user = user;
    }

    public PacketEventsDecoder(PacketEventsDecoder decoder) {
        this.user = decoder.user;
        this.player = decoder.player;
        this.hasBeenRelocated = decoder.hasBeenRelocated;
    }

    public void read(ChannelHandlerContext ctx, ByteBuf input, List<Object> out) throws Exception {
        PacketEventsImplHelper.handleServerBoundPacket(ctx.channel(), this.user, this.player, input, true);
        out.add(ByteBufHelper.retain(input));
    }

    @Override
    public void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        if (buffer.isReadable()) {
            this.read(ctx, buffer, out);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        boolean didWeCauseThis = ExceptionUtil.isException(cause, PacketProcessException.class);
        if (didWeCauseThis && (this.user == null || this.user.getDecoderState() != ConnectionState.HANDSHAKING)) {
            if (!SpigotReflectionUtil.isMinecraftServerInstanceDebugging()) {
                if (PacketEvents.getAPI().getSettings().isFullStackTraceEnabled()) {
                    cause.printStackTrace();
                } else {
                    PacketEvents.getAPI().getLogManager().warn(cause.getMessage());
                }
            }
            if (PacketEvents.getAPI().getSettings().isKickOnPacketExceptionEnabled()) {
                try {
                    if (this.user != null) {
                        this.user.sendPacket(new WrapperPlayServerDisconnect(Component.text("Invalid packet")));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ctx.channel().close();
                if (this.player != null) {
                    FoliaScheduler.getEntityScheduler().runDelayed((Entity)this.player, (Plugin)PacketEvents.getAPI().getPlugin(), o -> this.player.kickPlayer("Invalid packet"), null, 1L);
                }
                if (this.user != null) {
                    PacketEvents.getAPI().getLogManager().warn("Disconnected " + this.user.getProfile().getName() + " due to invalid packet!");
                }
            }
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object event) throws Exception {
        if (PacketEventsEncoder.COMPRESSION_ENABLED_EVENT == null || event != PacketEventsEncoder.COMPRESSION_ENABLED_EVENT) {
            super.userEventTriggered(ctx, event);
            return;
        }
        ServerConnectionInitializer.relocateHandlers(ctx.channel(), this, this.user);
        super.userEventTriggered(ctx, event);
    }
}

