/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentDispositionKt;
import io.ktor.http.HeaderValue;
import io.ktor.http.HeaderValueParam;
import io.ktor.http.HeaderValueWithParameters;
import io.ktor.http.HttpHeaderValueParserKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\r\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001b\u0010\u0010\u001a\u00020\u00002\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0014\u001a\u00020\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0096\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0003\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001a\u00a8\u0006\u001f"}, d2={"Lio/ktor/http/ContentDisposition;", "Lio/ktor/http/HeaderValueWithParameters;", "", "disposition", "", "Lio/ktor/http/HeaderValueParam;", "parameters", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "key", "value", "", "encodeValue", "withParameter", "(Ljava/lang/String;Ljava/lang/String;Z)Lio/ktor/http/ContentDisposition;", "newParameters", "withParameters", "(Ljava/util/List;)Lio/ktor/http/ContentDisposition;", "", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "getDisposition", "()Ljava/lang/String;", "getName", "name", "Companion", "Parameters", "ktor-http"})
public final class ContentDisposition
extends HeaderValueWithParameters {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ContentDisposition File = new ContentDisposition("file", null, 2, null);
    @NotNull
    private static final ContentDisposition Mixed = new ContentDisposition("mixed", null, 2, null);
    @NotNull
    private static final ContentDisposition Attachment = new ContentDisposition("attachment", null, 2, null);
    @NotNull
    private static final ContentDisposition Inline = new ContentDisposition("inline", null, 2, null);

    public ContentDisposition(@NotNull String disposition, @NotNull List<HeaderValueParam> parameters) {
        Intrinsics.checkNotNullParameter(disposition, "disposition");
        Intrinsics.checkNotNullParameter(parameters, "parameters");
        super(disposition, parameters);
    }

    public /* synthetic */ ContentDisposition(String string, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(string, list);
    }

    @NotNull
    public final String getDisposition() {
        return this.getContent();
    }

    @Nullable
    public final String getName() {
        return this.parameter("name");
    }

    @NotNull
    public final ContentDisposition withParameter(@NotNull String key2, @NotNull String value, boolean encodeValue) {
        Intrinsics.checkNotNullParameter(key2, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        String encodedValue = encodeValue ? ContentDispositionKt.access$encodeContentDispositionAttribute(key2, value) : value;
        return new ContentDisposition(this.getDisposition(), CollectionsKt.plus((Collection)this.getParameters(), new HeaderValueParam(key2, encodedValue)));
    }

    public static /* synthetic */ ContentDisposition withParameter$default(ContentDisposition contentDisposition, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return contentDisposition.withParameter(string, string2, bl);
    }

    @NotNull
    public final ContentDisposition withParameters(@NotNull List<HeaderValueParam> newParameters) {
        Intrinsics.checkNotNullParameter(newParameters, "newParameters");
        return new ContentDisposition(this.getDisposition(), CollectionsKt.plus((Collection)this.getParameters(), (Iterable)newParameters));
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ContentDisposition && Intrinsics.areEqual(this.getDisposition(), ((ContentDisposition)other).getDisposition()) && Intrinsics.areEqual(this.getParameters(), ((ContentDisposition)other).getParameters());
    }

    public int hashCode() {
        return this.getDisposition().hashCode() * 31 + ((Object)this.getParameters()).hashCode();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\u000e\u0010\fR\u0017\u0010\u000f\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\u0010\u0010\fR\u0017\u0010\u0011\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\n\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u0013"}, d2={"Lio/ktor/http/ContentDisposition$Companion;", "", "<init>", "()V", "", "value", "Lio/ktor/http/ContentDisposition;", "parse", "(Ljava/lang/String;)Lio/ktor/http/ContentDisposition;", "File", "Lio/ktor/http/ContentDisposition;", "getFile", "()Lio/ktor/http/ContentDisposition;", "Mixed", "getMixed", "Attachment", "getAttachment", "Inline", "getInline", "ktor-http"})
    @SourceDebugExtension(value={"SMAP\nContentDisposition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentDisposition.kt\nio/ktor/http/ContentDisposition$Companion\n+ 2 HeaderValueWithParameters.kt\nio/ktor/http/HeaderValueWithParameters$Companion\n*L\n1#1,125:1\n70#2,2:126\n*S KotlinDebug\n*F\n+ 1 ContentDisposition.kt\nio/ktor/http/ContentDisposition$Companion\n*L\n96#1:126,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ContentDisposition getFile() {
            return File;
        }

        @NotNull
        public final ContentDisposition getMixed() {
            return Mixed;
        }

        @NotNull
        public final ContentDisposition getAttachment() {
            return Attachment;
        }

        @NotNull
        public final ContentDisposition getInline() {
            return Inline;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ContentDisposition parse(@NotNull String value) {
            void p;
            Intrinsics.checkNotNullParameter(value, "value");
            HeaderValueWithParameters.Companion this_$iv = HeaderValueWithParameters.Companion;
            boolean $i$f$parse = false;
            HeaderValue headerValue$iv = CollectionsKt.last(HttpHeaderValueParserKt.parseHeaderValue(value));
            List<HeaderValueParam> list = headerValue$iv.getParams();
            String v = headerValue$iv.getValue();
            boolean bl = false;
            return new ContentDisposition(v, (List<HeaderValueParam>)p);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0006R\u0014\u0010\n\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0006R\u0014\u0010\f\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lio/ktor/http/ContentDisposition$Parameters;", "", "<init>", "()V", "", "FileName", "Ljava/lang/String;", "FileNameAsterisk", "Name", "CreationDate", "ModificationDate", "ReadDate", "Size", "Handling", "ktor-http"})
    public static final class Parameters {
        @NotNull
        public static final Parameters INSTANCE = new Parameters();
        @NotNull
        public static final String FileName = "filename";
        @NotNull
        public static final String FileNameAsterisk = "filename*";
        @NotNull
        public static final String Name = "name";
        @NotNull
        public static final String CreationDate = "creation-date";
        @NotNull
        public static final String ModificationDate = "modification-date";
        @NotNull
        public static final String ReadDate = "read-date";
        @NotNull
        public static final String Size = "size";
        @NotNull
        public static final String Handling = "handling";

        private Parameters() {
        }
    }
}

