/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.http.Parameters;
import io.ktor.http.ParametersKt;
import io.ktor.server.routing.RouteSelector;
import io.ktor.server.routing.RouteSelectorEvaluation;
import io.ktor.server.routing.RoutingResolveContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0096@\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u000fJ$\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001a\u0010\u0017\u001a\u00020\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\tH\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u001c\u0010\u000fR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001b\u001a\u0004\b\u001d\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lio/ktor/server/routing/PathSegmentTailcardRouteSelector;", "Lio/ktor/server/routing/RouteSelector;", "", "name", "prefix", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "Lio/ktor/server/routing/RoutingResolveContext;", "context", "", "segmentIndex", "Lio/ktor/server/routing/RouteSelectorEvaluation;", "evaluate", "(Lio/ktor/server/routing/RoutingResolveContext;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toString", "()Ljava/lang/String;", "component1", "component2", "copy", "(Ljava/lang/String;Ljava/lang/String;)Lio/ktor/server/routing/PathSegmentTailcardRouteSelector;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "Ljava/lang/String;", "getName", "getPrefix", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nRouteSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RouteSelector.kt\nio/ktor/server/routing/PathSegmentTailcardRouteSelector\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,774:1\n1855#2,2:775\n1#3:777\n1573#4:778\n1604#4,4:779\n*S KotlinDebug\n*F\n+ 1 RouteSelector.kt\nio/ktor/server/routing/PathSegmentTailcardRouteSelector\n*L\n492#1:775,2\n508#1:778\n508#1:779,4\n*E\n"})
public final class PathSegmentTailcardRouteSelector
extends RouteSelector {
    @NotNull
    private final String name;
    @NotNull
    private final String prefix;

    public PathSegmentTailcardRouteSelector(@NotNull String name, @NotNull String prefix) {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(prefix, "prefix");
            this.name = name;
            this.prefix = prefix;
            CharSequence $this$none$iv = this.prefix;
            boolean $i$f$none = false;
            for (int i = 0; i < $this$none$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$none$iv.charAt(i);
                boolean bl2 = false;
                if (!(it == '/')) continue;
                bl = false;
                break block2;
            }
            bl = true;
        }
        if (!bl) {
            boolean bl3 = false;
            String string = "Multisegment prefix is not supported";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ PathSegmentTailcardRouteSelector(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        this(string, string2);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getPrefix() {
        return this.prefix;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object evaluate(@NotNull RoutingResolveContext context, int segmentIndex, @NotNull Continuation<? super RouteSelectorEvaluation> $completion) {
        Parameters parameters;
        String segmentText;
        List<String> segments = context.getSegments();
        if (((CharSequence)this.prefix).length() > 0 && ((segmentText = CollectionsKt.getOrNull(segments, segmentIndex)) == null || !StringsKt.startsWith$default(segmentText, this.prefix, false, 2, null))) {
            return RouteSelectorEvaluation.Companion.getFailedPath();
        }
        if (((CharSequence)this.name).length() == 0) {
            parameters = ParametersKt.parametersOf();
        } else {
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            Iterable iterable = CollectionsKt.drop((Iterable)segments, segmentIndex);
            String string = this.name;
            boolean $i$f$mapIndexed = false;
            void var8_10 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void segment;
                void index;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string2 = (String)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(index == false ? StringsKt.drop((String)segment, this.prefix.length()) : segment);
            }
            parameters = ParametersKt.parametersOf(string, (List)destination$iv$iv);
        }
        Parameters values2 = parameters;
        double quality = segmentIndex < segments.size() ? 0.1 : 0.2;
        return new RouteSelectorEvaluation.Success(quality, values2, segments.size() - segmentIndex);
    }

    @NotNull
    public String toString() {
        return "{...}";
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final String component2() {
        return this.prefix;
    }

    @NotNull
    public final PathSegmentTailcardRouteSelector copy(@NotNull String name, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        return new PathSegmentTailcardRouteSelector(name, prefix);
    }

    public static /* synthetic */ PathSegmentTailcardRouteSelector copy$default(PathSegmentTailcardRouteSelector pathSegmentTailcardRouteSelector, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = pathSegmentTailcardRouteSelector.name;
        }
        if ((n & 2) != 0) {
            string2 = pathSegmentTailcardRouteSelector.prefix;
        }
        return pathSegmentTailcardRouteSelector.copy(string, string2);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.prefix.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PathSegmentTailcardRouteSelector)) {
            return false;
        }
        PathSegmentTailcardRouteSelector pathSegmentTailcardRouteSelector = (PathSegmentTailcardRouteSelector)other;
        if (!Intrinsics.areEqual(this.name, pathSegmentTailcardRouteSelector.name)) {
            return false;
        }
        return Intrinsics.areEqual(this.prefix, pathSegmentTailcardRouteSelector.prefix);
    }

    public PathSegmentTailcardRouteSelector() {
        this(null, null, 3, null);
    }
}

