/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.server.routing.RouteSelector;
import io.ktor.server.routing.RouteSelectorEvaluation;
import io.ktor.server.routing.RoutingPath;
import io.ktor.server.routing.RoutingPathSegment;
import io.ktor.server.routing.RoutingPathSegmentKind;
import io.ktor.server.routing.RoutingResolveContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0096@\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lio/ktor/server/routing/RootRouteSelector;", "Lio/ktor/server/routing/RouteSelector;", "", "rootPath", "<init>", "(Ljava/lang/String;)V", "Lio/ktor/server/routing/RoutingResolveContext;", "context", "", "segmentIndex", "Lio/ktor/server/routing/RouteSelectorEvaluation;", "evaluate", "(Lio/ktor/server/routing/RoutingResolveContext;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toString", "()Ljava/lang/String;", "", "parts", "Ljava/util/List;", "Lio/ktor/server/routing/RouteSelectorEvaluation$Success;", "successEvaluationResult", "Lio/ktor/server/routing/RouteSelectorEvaluation$Success;", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nRouteSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RouteSelector.kt\nio/ktor/server/routing/RootRouteSelector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,774:1\n1563#2:775\n1634#2,3:776\n1#3:779\n*S KotlinDebug\n*F\n+ 1 RouteSelector.kt\nio/ktor/server/routing/RootRouteSelector\n*L\n254#1:775\n254#1:776,3\n*E\n"})
public final class RootRouteSelector
extends RouteSelector {
    @NotNull
    private final List<String> parts;
    @NotNull
    private final RouteSelectorEvaluation.Success successEvaluationResult;

    /*
     * WARNING - void declaration
     */
    public RootRouteSelector(@NotNull String rootPath) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(rootPath, "rootPath");
        Iterable iterable = RoutingPath.Companion.parse(rootPath).getParts();
        RootRouteSelector rootRouteSelector = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RoutingPathSegment routingPathSegment = (RoutingPathSegment)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (!(it.getKind() == RoutingPathSegmentKind.Constant)) {
                boolean bl2 = false;
                String string = "rootPath should be constant, no wildcards supported.";
                throw new IllegalArgumentException(string.toString());
            }
            collection.add(it.getValue());
        }
        rootRouteSelector.parts = (List)destination$iv$iv;
        this.successEvaluationResult = new RouteSelectorEvaluation.Success(1.0, null, this.parts.size(), 2, null);
    }

    public /* synthetic */ RootRouteSelector(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        this(string);
    }

    @Override
    @Nullable
    public Object evaluate(@NotNull RoutingResolveContext context, int segmentIndex, @NotNull Continuation<? super RouteSelectorEvaluation> $completion) {
        if (!(segmentIndex == 0)) {
            boolean $i$a$-check-RootRouteSelector$evaluate$32 = false;
            String $i$a$-check-RootRouteSelector$evaluate$32 = "Root selector should be evaluated first.";
            throw new IllegalStateException($i$a$-check-RootRouteSelector$evaluate$32.toString());
        }
        if (this.parts.isEmpty()) {
            return RouteSelectorEvaluation.Companion.getConstant();
        }
        List<String> parts = this.parts;
        List<String> segments = context.getSegments();
        if (segments.size() < parts.size()) {
            return RouteSelectorEvaluation.Companion.getFailedPath();
        }
        int n = segmentIndex + parts.size();
        for (int index = segmentIndex; index < n; ++index) {
            if (Intrinsics.areEqual(segments.get(index), parts.get(index))) continue;
            return RouteSelectorEvaluation.Companion.getFailedPath();
        }
        return this.successEvaluationResult;
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default(this.parts, "/", null, null, 0, null, null, 62, null);
    }

    public RootRouteSelector() {
        this(null, 1, null);
    }
}

