/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon;

import io.github.retrooper.packetevents.factory.spigot.SpigotPacketEventsBuilder;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.mochibit.defcon.biomes.CustomBiomeHandler;
import me.mochibit.defcon.classes.PluginConfiguration;
import me.mochibit.defcon.notification.NotificationManager;
import me.mochibit.defcon.radiation.RadiationManager;
import me.mochibit.defcon.registers.BlockRegister;
import me.mochibit.defcon.registers.CommandRegister;
import me.mochibit.defcon.registers.DatapackRegister;
import me.mochibit.defcon.registers.EventRegister;
import me.mochibit.defcon.registers.ItemRegister;
import me.mochibit.defcon.registers.ResourcePackRegister;
import me.mochibit.defcon.registers.StructureRegister;
import me.mochibit.defcon.server.ResourcePackServer;
import me.mochibit.lib.packetevents.PacketEvents;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \b2\u00020\u0001:\u0002\b\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lme/mochibit/defcon/Defcon;", "Lorg/bukkit/plugin/java/JavaPlugin;", "<init>", "()V", "onLoad", "", "onEnable", "onDisable", "Companion", "Logger", "Defcon"})
public final class Defcon
extends JavaPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static Defcon _instance;
    @NotNull
    private static String namespace;
    @NotNull
    private static final String minecraftVersion;

    public void onLoad() {
        _instance = this;
        PacketEvents.setAPI(SpigotPacketEventsBuilder.build((Plugin)this));
        PacketEvents.getAPI().load();
        EventRegister.INSTANCE.registerPacketListeners();
        Logger.INSTANCE.info("Defcon is starting up \u2622\ufe0f");
    }

    public void onEnable() {
        ResourcePackServer.INSTANCE.startServer();
        PacketEvents.getAPI().init();
        Logger.INSTANCE.info("Plugin is enabled! Configuring...");
        PluginConfiguration.Companion.initializeAll();
        Logger.INSTANCE.info("Registering resource pack and datapack");
        DatapackRegister.INSTANCE.register();
        ResourcePackRegister.INSTANCE.register();
        NotificationManager.startBroadcastTask-LRDsOJo$default(NotificationManager.INSTANCE, 0L, 1, null);
        EventRegister.INSTANCE.registerListeners();
        if (!new ItemRegister().registerItems()) {
            Logger.INSTANCE.info("Some items were not registered!");
        }
        new BlockRegister().registerBlocks();
        new CommandRegister().registerCommands();
        new StructureRegister().registerStructures();
        RadiationManager.INSTANCE.start();
        CustomBiomeHandler.INSTANCE.initialize();
    }

    public void onDisable() {
        PluginConfiguration.Companion.saveAll();
        NotificationManager.INSTANCE.saveNotifications();
        PacketEvents.getAPI().terminate();
        ResourcePackServer.INSTANCE.stopServer();
        CustomBiomeHandler.INSTANCE.shutdown();
        Logger.INSTANCE.info("Plugin disabled!");
    }

    static {
        namespace = "defcon";
        String string = Bukkit.getServer().getBukkitVersion();
        Intrinsics.checkNotNullExpressionValue(string, "getBukkitVersion(...)");
        String[] stringArray = new String[]{"-"};
        minecraftVersion = (String)StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null).get(0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0011"}, d2={"Lme/mochibit/defcon/Defcon$Companion;", "", "<init>", "()V", "_instance", "Lme/mochibit/defcon/Defcon;", "instance", "getInstance", "()Lme/mochibit/defcon/Defcon;", "namespace", "", "getNamespace", "()Ljava/lang/String;", "setNamespace", "(Ljava/lang/String;)V", "minecraftVersion", "getMinecraftVersion", "Defcon"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Defcon getInstance() {
            Defcon defcon = _instance;
            if (defcon == null) {
                Intrinsics.throwUninitializedPropertyAccessException("_instance");
                defcon = null;
            }
            return defcon;
        }

        @NotNull
        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            namespace = string;
        }

        @NotNull
        public final String getMinecraftVersion() {
            return minecraftVersion;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lme/mochibit/defcon/Defcon$Logger;", "", "<init>", "()V", "withPrefix", "Lme/mochibit/defcon/Defcon$Logger$PluginLogger;", "level", "Lme/mochibit/defcon/Defcon$Logger$LogLevel;", "miniMessage", "Lnet/kyori/adventure/text/minimessage/MiniMessage;", "Lorg/jetbrains/annotations/NotNull;", "pluginLogger", "info", "", "message", "", "warn", "err", "debug", "PluginLogger", "LogLevel", "Defcon"})
    public static final class Logger {
        @NotNull
        public static final Logger INSTANCE = new Logger();
        @NotNull
        private static final MiniMessage miniMessage;
        @NotNull
        private static final PluginLogger pluginLogger;

        private Logger() {
        }

        private final PluginLogger withPrefix(PluginLogger $this$withPrefix, LogLevel level) {
            return arg_0 -> Logger.withPrefix$lambda$0(level, $this$withPrefix, arg_0);
        }

        public final void info(@NotNull String message) {
            Intrinsics.checkNotNullParameter(message, "message");
            this.withPrefix(pluginLogger, LogLevel.INFO).log(message);
        }

        public final void warn(@NotNull String message) {
            Intrinsics.checkNotNullParameter(message, "message");
            this.withPrefix(pluginLogger, LogLevel.WARNING).log(message);
        }

        public final void err(@NotNull String message) {
            Intrinsics.checkNotNullParameter(message, "message");
            this.withPrefix(pluginLogger, LogLevel.ERROR).log(message);
        }

        public final void debug(@NotNull String message) {
            Intrinsics.checkNotNullParameter(message, "message");
            this.withPrefix(pluginLogger, LogLevel.DEBUG).log(message);
        }

        private static final void withPrefix$lambda$0(LogLevel $level, PluginLogger $this_withPrefix, String it) {
            Intrinsics.checkNotNullParameter(it, "it");
            String prefix = $level.getPrefix();
            $this_withPrefix.log(prefix + " " + it);
        }

        private static final void pluginLogger$lambda$1(String it) {
            Intrinsics.checkNotNullParameter(it, "it");
            Companion.getInstance().getComponentLogger().info(miniMessage.deserialize((Object)it));
        }

        static {
            MiniMessage miniMessage = MiniMessage.miniMessage();
            Intrinsics.checkNotNullExpressionValue(miniMessage, "miniMessage(...)");
            Logger.miniMessage = miniMessage;
            pluginLogger = Logger::pluginLogger$lambda$1;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tj\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\n"}, d2={"Lme/mochibit/defcon/Defcon$Logger$LogLevel;", "", "<init>", "(Ljava/lang/String;I)V", "INFO", "WARNING", "ERROR", "DEBUG", "getPrefix", "", "Defcon"})
        public static final class LogLevel
        extends Enum<LogLevel> {
            public static final /* enum */ LogLevel INFO = new LogLevel();
            public static final /* enum */ LogLevel WARNING = new LogLevel();
            public static final /* enum */ LogLevel ERROR = new LogLevel();
            public static final /* enum */ LogLevel DEBUG = new LogLevel();
            private static final /* synthetic */ LogLevel[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            @NotNull
            public final String getPrefix() {
                return switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                    case 1 -> "<blue><b>INFO</b></blue> ";
                    case 2 -> "<yellow><b>WARN</b></yellow> ";
                    case 3 -> "<red><b>ERROR</b></red> ";
                    case 4 -> "<light_purple><b>DEBUG</b></light_purple> ";
                    default -> throw new NoWhenBranchMatchedException();
                };
            }

            public static LogLevel[] values() {
                return (LogLevel[])$VALUES.clone();
            }

            public static LogLevel valueOf(String value) {
                return Enum.valueOf(LogLevel.class, value);
            }

            @NotNull
            public static EnumEntries<LogLevel> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = logLevelArray = new LogLevel[]{LogLevel.INFO, LogLevel.WARNING, LogLevel.ERROR, LogLevel.DEBUG};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }

            @Metadata(mv={2, 1, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[LogLevel.values().length];
                    try {
                        nArray[LogLevel.INFO.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[LogLevel.WARNING.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[LogLevel.ERROR.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[LogLevel.DEBUG.ordinal()] = 4;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lme/mochibit/defcon/Defcon$Logger$PluginLogger;", "", "log", "", "message", "", "Defcon"})
        public static interface PluginLogger {
            public void log(@NotNull String var1);
        }
    }
}

