/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.commands.definitions;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.mochibit.defcon.commands.CommandInfo;
import me.mochibit.defcon.commands.GenericCommand;
import me.mochibit.defcon.interfaces.PluginItem;
import me.mochibit.defcon.registers.ItemRegister;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@CommandInfo(name="give", permission="defcon.admin", requiresPlayer=false, description="This command gives a specified <bold> Defcon </bold> item to a player. If no player is specified, the item is given to the command executor.")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u0006\u0012\u0002\b\u00030\u0005H\u0016J$\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0002J\u0016\u0010\u0012\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0002J \u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001a"}, d2={"Lme/mochibit/defcon/commands/definitions/GiveCommand;", "Lme/mochibit/defcon/commands/GenericCommand;", "<init>", "()V", "getArguments", "Lcom/mojang/brigadier/builder/ArgumentBuilder;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "suggestItems", "Ljava/util/concurrent/CompletableFuture;", "Lcom/mojang/brigadier/suggestion/Suggestions;", "context", "Lcom/mojang/brigadier/context/CommandContext;", "builder", "Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;", "suggestPlayers", "handleExecutorAsTarget", "", "ctx", "handleFullCommand", "giveItemToPlayer", "sender", "Lorg/bukkit/command/CommandSender;", "targetPlayer", "Lorg/bukkit/entity/Player;", "itemId", "", "Defcon"})
@SourceDebugExtension(value={"SMAP\nGiveCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GiveCommand.kt\nme/mochibit/defcon/commands/definitions/GiveCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n774#2:173\n865#2,2:174\n1869#2,2:176\n1563#2:178\n1634#2,3:179\n774#2:182\n865#2,2:183\n1869#2,2:185\n*S KotlinDebug\n*F\n+ 1 GiveCommand.kt\nme/mochibit/defcon/commands/definitions/GiveCommand\n*L\n74#1:173\n74#1:174,2\n75#1:176,2\n89#1:178\n89#1:179,3\n90#1:182\n90#1:183,2\n91#1:185,2\n*E\n"})
public final class GiveCommand
extends GenericCommand {
    @Override
    @NotNull
    public ArgumentBuilder<CommandSourceStack, ?> getArguments() {
        ArgumentBuilder argumentBuilder = ((RequiredArgumentBuilder)Commands.argument((String)"item", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestItems).then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestPlayers).executes(this::handleFullCommand))).executes(this::handleExecutorAsTarget);
        Intrinsics.checkNotNullExpressionValue(argumentBuilder, "executes(...)");
        return argumentBuilder;
    }

    /*
     * WARNING - void declaration
     */
    private final CompletableFuture<Suggestions> suggestItems(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        String prefix = builder.getRemainingLowerCase();
        Set<String> set = ItemRegister.Companion.getRegisteredItems().keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        Iterable iterable = CollectionsKt.filterNotNull((Iterable)set);
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            String string = it.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            Intrinsics.checkNotNull(prefix);
            if (!StringsKt.startsWith$default(string, prefix, false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String p0 = (String)element$iv;
            boolean bl = false;
            builder.suggest(p0);
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
        return completableFuture;
    }

    /*
     * WARNING - void declaration
     */
    private final CompletableFuture<Suggestions> suggestPlayers(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        String it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        String prefix = builder.getRemainingLowerCase();
        Collection collection = Bukkit.getServer().getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Iterable iterable = collection;
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Player player = (Player)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getName());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            String string = it.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            Intrinsics.checkNotNull(prefix);
            if (!StringsKt.startsWith$default(string, prefix, false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String p0 = (String)element$iv;
            boolean bl = false;
            builder.suggest(p0);
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
        return completableFuture;
    }

    private final int handleExecutorAsTarget(CommandContext<CommandSourceStack> ctx) {
        String itemId = StringArgumentType.getString(ctx, (String)"item");
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        if (((CommandSourceStack)ctx.getSource()).getExecutor() instanceof Player) {
            Entity entity = ((CommandSourceStack)ctx.getSource()).getExecutor();
            Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.Player");
            Player player = (Player)entity;
            Intrinsics.checkNotNull(itemId);
            return this.giveItemToPlayer(sender, player, itemId);
        }
        this.sendMessage(sender, "You must specify a player name when executing from console", true);
        return 1;
    }

    private final int handleFullCommand(CommandContext<CommandSourceStack> ctx) {
        String itemId = StringArgumentType.getString(ctx, (String)"item");
        String playerName = StringArgumentType.getString(ctx, (String)"player");
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        Player targetPlayer = Bukkit.getServer().getPlayer(playerName);
        if (targetPlayer == null || !targetPlayer.isOnline()) {
            this.sendMessage(sender, "Player '" + playerName + "' not found or not online", true);
            return 1;
        }
        Intrinsics.checkNotNull(itemId);
        return this.giveItemToPlayer(sender, targetPlayer, itemId);
    }

    private final int giveItemToPlayer(CommandSender sender, Player targetPlayer, String itemId) {
        PluginItem item = ItemRegister.Companion.getRegisteredItems().get(itemId);
        if (item == null) {
            this.sendMessage(sender, "Item with ID '" + itemId + "' not found in the registry", true);
            return 1;
        }
        try {
            ItemStack[] itemStackArray = new ItemStack[]{item.getItemStack()};
            HashMap hashMap = targetPlayer.getInventory().addItem(itemStackArray);
            Intrinsics.checkNotNullExpressionValue(hashMap, "addItem(...)");
            HashMap result = hashMap;
            if (result.isEmpty()) {
                boolean isSelf = Intrinsics.areEqual(sender, targetPlayer);
                if (isSelf) {
                    GenericCommand.sendMessage$default(this, sender, "You have been given a " + item.getDisplayName(), false, 4, null);
                } else {
                    GenericCommand.sendMessage$default(this, sender, "Gave " + targetPlayer.getName() + " a " + item.getDisplayName(), false, 4, null);
                    GenericCommand.sendMessage$default(this, (CommandSender)targetPlayer, "You received a " + item.getDisplayName(), false, 4, null);
                }
            } else {
                this.sendMessage(sender, "Could not give item - player inventory is full", true);
            }
        }
        catch (Exception e) {
            this.sendMessage(sender, "Failed to give item: " + e.getMessage(), true);
            e.printStackTrace();
        }
        return 1;
    }
}

