/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.effects.nuclear;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import me.mochibit.defcon.effects.AnimatedEffect;
import me.mochibit.defcon.effects.EffectComponent;
import me.mochibit.defcon.effects.ParticleComponent;
import me.mochibit.defcon.explosions.ExplosionComponent;
import me.mochibit.defcon.particles.emitter.EmitterShape;
import me.mochibit.defcon.particles.emitter.ParticleEmitter;
import me.mochibit.defcon.particles.emitter.RingSurfaceShape;
import me.mochibit.defcon.particles.emitter.SphereSurfaceShape;
import me.mochibit.defcon.particles.templates.AbstractParticle;
import me.mochibit.defcon.particles.templates.definition.ExplosionDustParticle;
import org.bukkit.Color;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lme/mochibit/defcon/effects/nuclear/CondensationCloudVFX;", "Lme/mochibit/defcon/effects/AnimatedEffect;", "nuclearComponent", "Lme/mochibit/defcon/explosions/ExplosionComponent;", "position", "Lorg/bukkit/Location;", "<init>", "(Lme/mochibit/defcon/explosions/ExplosionComponent;Lorg/bukkit/Location;)V", "riseSpeed", "", "ringRiseSpeed", "expandSpeed", "condensationRing", "Lme/mochibit/defcon/effects/ParticleComponent;", "condensationRingShape", "Lme/mochibit/defcon/particles/emitter/RingSurfaceShape;", "condensationDome", "condensationDomeShape", "Lme/mochibit/defcon/particles/emitter/SphereSurfaceShape;", "animate", "", "delta", "Defcon"})
public final class CondensationCloudVFX
extends AnimatedEffect {
    @NotNull
    private final ExplosionComponent nuclearComponent;
    @NotNull
    private final Location position;
    private float riseSpeed;
    private float ringRiseSpeed;
    private float expandSpeed;
    @NotNull
    private final ParticleComponent condensationRing;
    @NotNull
    private final RingSurfaceShape condensationRingShape;
    @NotNull
    private final ParticleComponent condensationDome;
    @NotNull
    private final SphereSurfaceShape condensationDomeShape;

    public CondensationCloudVFX(@NotNull ExplosionComponent nuclearComponent, @NotNull Location position) {
        Intrinsics.checkNotNullParameter(nuclearComponent, "nuclearComponent");
        Intrinsics.checkNotNullParameter(position, "position");
        super(800, null, 2, null);
        this.nuclearComponent = nuclearComponent;
        this.position = position;
        this.riseSpeed = 6.0f;
        this.ringRiseSpeed = 3.0f;
        this.expandSpeed = 10.0f;
        ParticleComponent particleComponent = new ParticleComponent(new ParticleEmitter(this.position, 3000.0, 0, new RingSurfaceShape(110.0f, 5.0f), null, null, null, 116, null), null, 2, null);
        AbstractParticle abstractParticle = new ExplosionDustParticle().scale(new Vector3f(60.0f, 60.0f, 60.0f));
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color, "WHITE");
        this.condensationRing = ParticleComponent.addSpawnableParticle$default(particleComponent, abstractParticle.color(color), false, 2, null).applyRadialVelocityFromCenter(new Vector3f(6.0f, 0.0f, 6.0f)).translate(new Vector3f(0.0f, 110.0f, 0.0f));
        EmitterShape emitterShape = this.condensationRing.getShape();
        Intrinsics.checkNotNull(emitterShape, "null cannot be cast to non-null type me.mochibit.defcon.particles.emitter.RingSurfaceShape");
        this.condensationRingShape = (RingSurfaceShape)emitterShape;
        ParticleComponent particleComponent2 = new ParticleComponent(new ParticleEmitter(this.position, 500.0, 0, new SphereSurfaceShape(110.0f, 110.0f, 0.0, 0.0, 0.0, 0.0, true, null, null, 440, null), null, null, null, 116, null), null, 2, null);
        AbstractParticle abstractParticle2 = new ExplosionDustParticle().scale(new Vector3f(80.0f, 80.0f, 80.0f));
        Color color2 = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color2, "WHITE");
        this.condensationDome = ParticleComponent.addSpawnableParticle$default(particleComponent2, abstractParticle2.color(color2), false, 2, null).applyRadialVelocityFromCenter(new Vector3f(6.0f, 0.0f, 6.0f)).translate(new Vector3f(0.0f, 150.0f, 0.0f));
        EmitterShape emitterShape2 = this.condensationDome.getShape();
        Intrinsics.checkNotNull(emitterShape2, "null cannot be cast to non-null type me.mochibit.defcon.particles.emitter.SphereSurfaceShape");
        this.condensationDomeShape = (SphereSurfaceShape)emitterShape2;
        EffectComponent[] effectComponentArray = new EffectComponent[]{this.condensationRing, this.condensationDome};
        this.setEffectComponents(CollectionsKt.mutableListOf(effectComponentArray));
    }

    @Override
    public void animate(float delta) {
        float deltaMovement = this.riseSpeed * delta;
        float deltaRingMovement = this.ringRiseSpeed * delta;
        float deltaExpansion = this.expandSpeed * delta;
        this.condensationRing.translate(new Vector3f(0.0f, deltaRingMovement, 0.0f));
        EmitterShape emitterShape = this.condensationRingShape;
        ((RingSurfaceShape)emitterShape).setRingRadius(((RingSurfaceShape)emitterShape).getRingRadius() + deltaExpansion);
        this.condensationDome.translate(new Vector3f(0.0f, deltaMovement, 0.0f));
        EmitterShape $this$animate_u24lambda_u240 = emitterShape = this.condensationDomeShape;
        boolean bl = false;
        ((SphereSurfaceShape)$this$animate_u24lambda_u240).setXzRadius(((SphereSurfaceShape)$this$animate_u24lambda_u240).getXzRadius() + deltaExpansion);
        ((SphereSurfaceShape)$this$animate_u24lambda_u240).setYRadius(RangesKt.coerceIn(((SphereSurfaceShape)$this$animate_u24lambda_u240).getYRadius() + deltaExpansion, 0.0f, 160.0f));
    }
}

