/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.explosions;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\u0007H\u0002J\b\u0010\f\u001a\u00020\u0007H\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lme/mochibit/defcon/explosions/TransformationRule;", "", "<init>", "()V", "random", "Lkotlin/random/Random$Default;", "transformMaterial", "Lorg/bukkit/Material;", "currentMaterial", "normalizedExplosionPower", "", "getRandomDeadPlant", "getRandomBurntBlock", "transformToDeadPlantOrAir", "Companion", "Defcon"})
@SourceDebugExtension(value={"SMAP\nTransformationRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransformationRule.kt\nme/mochibit/defcon/explosions/TransformationRule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,245:1\n774#2:246\n865#2,2:247\n*S KotlinDebug\n*F\n+ 1 TransformationRule.kt\nme/mochibit/defcon/explosions/TransformationRule\n*L\n108#1:246\n108#1:247,2\n*E\n"})
public final class TransformationRule {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Random.Default random = Random.Default;
    @NotNull
    private static final Set<Material> BLOCK_TRANSFORMATION_BLACKLIST;
    @NotNull
    private static final EnumSet<Material> LIQUID_MATERIALS;
    @NotNull
    private static final EnumSet<Material> DEAD_PLANTS;
    @NotNull
    private static final EnumSet<Material> BURNT_BLOCK;
    @NotNull
    private static final EnumSet<Material> DESTROYED_BLOCK;
    @NotNull
    private static final EnumSet<Material> DIRT_TRANSFORMATIONS;
    @NotNull
    private static final EnumSet<Material> SLAB_TRANSFORMATIONS;
    @NotNull
    private static final EnumSet<Material> WALL_TRANSFORMATIONS;
    @NotNull
    private static final EnumSet<Material> STAIRS_TRANSFORMATIONS;
    @NotNull
    private static final EnumSet<Material> ATTACHED_BLOCKS;
    @NotNull
    private static final EnumSet<Material> LIGHT_WEIGHT_BLOCKS;
    @NotNull
    private static final EnumSet<Material> PLANTS;
    @NotNull
    private static final EnumSet<Material> SLABS;
    @NotNull
    private static final EnumSet<Material> WALLS;
    @NotNull
    private static final EnumSet<Material> STAIRS;
    @NotNull
    private static final EnumSet<Material> GLASS;

    @NotNull
    public final Material transformMaterial(@NotNull Material currentMaterial, double normalizedExplosionPower) {
        Material material;
        Intrinsics.checkNotNullParameter(currentMaterial, "currentMaterial");
        if (BLOCK_TRANSFORMATION_BLACKLIST.contains(currentMaterial)) {
            return currentMaterial;
        }
        if (normalizedExplosionPower > 0.8 && !LIGHT_WEIGHT_BLOCKS.contains(currentMaterial)) {
            return this.getRandomBurntBlock();
        }
        if (SLABS.contains(currentMaterial) || WALLS.contains(currentMaterial) || STAIRS.contains(currentMaterial) || GLASS.contains(currentMaterial)) {
            Material material2;
            Material material3 = currentMaterial;
            if (SLABS.contains(material3)) {
                Object t = CollectionsKt.random((Collection)SLAB_TRANSFORMATIONS, this.random);
                Intrinsics.checkNotNullExpressionValue(t, "random(...)");
                material2 = (Material)t;
            } else if (WALLS.contains(material3)) {
                Object t = CollectionsKt.random((Collection)WALL_TRANSFORMATIONS, this.random);
                Intrinsics.checkNotNullExpressionValue(t, "random(...)");
                material2 = (Material)t;
            } else if (STAIRS.contains(material3)) {
                Object t = CollectionsKt.random((Collection)STAIRS_TRANSFORMATIONS, this.random);
                Intrinsics.checkNotNullExpressionValue(t, "random(...)");
                material2 = (Material)t;
            } else {
                material2 = GLASS.contains(material3) ? Material.AIR : currentMaterial;
            }
            return material2;
        }
        Material material4 = currentMaterial;
        if (LIGHT_WEIGHT_BLOCKS.contains(material4)) {
            material = Material.AIR;
        } else if (PLANTS.contains(material4)) {
            material = this.transformToDeadPlantOrAir(normalizedExplosionPower);
        } else if (material4 == Material.DIRT || material4 == Material.GRASS_BLOCK) {
            Object t = CollectionsKt.random((Collection)DIRT_TRANSFORMATIONS, this.random);
            Intrinsics.checkNotNullExpressionValue(t, "random(...)");
            material = (Material)t;
        } else {
            Object t = CollectionsKt.random((Collection)DESTROYED_BLOCK, this.random);
            Intrinsics.checkNotNullExpressionValue(t, "random(...)");
            material = (Material)t;
        }
        return material;
    }

    private final Material getRandomDeadPlant() {
        Object t = CollectionsKt.random((Collection)DEAD_PLANTS, this.random);
        Intrinsics.checkNotNullExpressionValue(t, "random(...)");
        return (Material)t;
    }

    private final Material getRandomBurntBlock() {
        Object t = CollectionsKt.random((Collection)BURNT_BLOCK, this.random);
        Intrinsics.checkNotNullExpressionValue(t, "random(...)");
        return (Material)t;
    }

    private final Material transformToDeadPlantOrAir(double normalizedExplosionPower) {
        return normalizedExplosionPower > 0.5 ? Material.AIR : this.getRandomDeadPlant();
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Companion = new Companion(null);
        Object object = new Material[]{Material.BARRIER, Material.COMMAND_BLOCK, Material.COMMAND_BLOCK_MINECART, Material.END_PORTAL_FRAME, Material.END_PORTAL};
        EnumSet<Enum[]> enumSet = EnumSet.of((Enum)Material.BEDROCK, (Enum[])object);
        Intrinsics.checkNotNullExpressionValue(enumSet, "of(...)");
        BLOCK_TRANSFORMATION_BLACKLIST = enumSet;
        EnumSet<Enum> enumSet2 = EnumSet.of((Enum)Material.WATER, (Enum)Material.LAVA);
        Intrinsics.checkNotNullExpressionValue(enumSet2, "of(...)");
        LIQUID_MATERIALS = enumSet2;
        EnumSet<Enum> enumSet3 = EnumSet.of((Enum)Material.DEAD_BUSH, (Enum)Material.WITHER_ROSE);
        Intrinsics.checkNotNullExpressionValue(enumSet3, "of(...)");
        DEAD_PLANTS = enumSet3;
        EnumSet<Enum> enumSet4 = EnumSet.of((Enum)Material.COBBLED_DEEPSLATE, (Enum)Material.BLACK_CONCRETE_POWDER, (Enum)Material.OBSIDIAN);
        Intrinsics.checkNotNullExpressionValue(enumSet4, "of(...)");
        BURNT_BLOCK = enumSet4;
        EnumSet<Enum> enumSet5 = EnumSet.of((Enum)Material.COBBLESTONE, (Enum)Material.COBBLED_DEEPSLATE);
        Intrinsics.checkNotNullExpressionValue(enumSet5, "of(...)");
        DESTROYED_BLOCK = enumSet5;
        EnumSet<Enum> enumSet6 = EnumSet.of((Enum)Material.COARSE_DIRT, (Enum)Material.MUD, (Enum)Material.MUDDY_MANGROVE_ROOTS);
        Intrinsics.checkNotNullExpressionValue(enumSet6, "of(...)");
        DIRT_TRANSFORMATIONS = enumSet6;
        EnumSet<Enum> enumSet7 = EnumSet.of((Enum)Material.COBBLED_DEEPSLATE_SLAB, (Enum)Material.COBBLESTONE_SLAB);
        Intrinsics.checkNotNullExpressionValue(enumSet7, "of(...)");
        SLAB_TRANSFORMATIONS = enumSet7;
        EnumSet<Enum> enumSet8 = EnumSet.of((Enum)Material.COBBLED_DEEPSLATE_WALL, (Enum)Material.COBBLESTONE_WALL);
        Intrinsics.checkNotNullExpressionValue(enumSet8, "of(...)");
        WALL_TRANSFORMATIONS = enumSet8;
        EnumSet<Enum> enumSet9 = EnumSet.of((Enum)Material.COBBLED_DEEPSLATE_STAIRS, (Enum)Material.COBBLESTONE_STAIRS);
        Intrinsics.checkNotNullExpressionValue(enumSet9, "of(...)");
        STAIRS_TRANSFORMATIONS = enumSet9;
        object = new Material[]{Material.WEEPING_VINES, Material.TWISTING_VINES, Material.TORCH, Material.WALL_TORCH, Material.REDSTONE_TORCH, Material.REDSTONE_WALL_TORCH, Material.LEVER, Material.REDSTONE, Material.REDSTONE_WIRE, Material.REPEATER, Material.COMPARATOR, Material.TRIPWIRE_HOOK, Material.TRIPWIRE, Material.RAIL, Material.POWERED_RAIL, Material.DETECTOR_RAIL, Material.ACTIVATOR_RAIL};
        Object $this$ATTACHED_BLOCKS_u24lambda_u241 = object = EnumSet.of((Enum)Material.VINE, (Enum[])object);
        boolean bl = false;
        Object object2 = (Material[])EntriesMappings.entries$0;
        Object object3 = $this$ATTACHED_BLOCKS_u24lambda_u241;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Material it = (Material)element$iv$iv;
            boolean bl2 = false;
            String name = it.name();
            if (!(StringsKt.contains$default((CharSequence)name, "BUTTON", false, 2, null) || StringsKt.contains$default((CharSequence)name, "SIGN", false, 2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        ((AbstractCollection)object3).addAll((List)destination$iv$iv);
        Object object4 = object;
        Intrinsics.checkNotNullExpressionValue(object4, "apply(...)");
        ATTACHED_BLOCKS = object4;
        object = new Material[]{Material.PACKED_ICE, Material.BLUE_ICE, Material.FROSTED_ICE, Material.SNOW, Material.SNOW_BLOCK, Material.POWDER_SNOW};
        EnumSet<Enum[]> enumSet10 = EnumSet.of((Enum)Material.ICE, (Enum[])object);
        Intrinsics.checkNotNullExpressionValue(enumSet10, "of(...)");
        LIGHT_WEIGHT_BLOCKS = enumSet10;
        Object $this$PLANTS_u24lambda_u242 = object = EnumSet.noneOf(Material.class);
        boolean bl3 = false;
        object2 = new Material[]{Material.SHORT_GRASS, Material.TALL_GRASS, Material.FERN, Material.LARGE_FERN};
        ((AbstractCollection)$this$PLANTS_u24lambda_u242).addAll((Collection)CollectionsKt.listOf(object2));
        for (Material material : EntriesMappings.entries$0) {
            if (!StringsKt.contains((CharSequence)material.name(), "SAPLING", true)) continue;
            ((AbstractCollection)$this$PLANTS_u24lambda_u242).add(material);
        }
        object2 = new Material[]{Material.POPPY, Material.DANDELION, Material.BLUE_ORCHID, Material.ALLIUM, Material.AZURE_BLUET, Material.OXEYE_DAISY, Material.CORNFLOWER, Material.LILY_OF_THE_VALLEY, Material.PINK_PETALS, Material.LILAC, Material.PEONY, Material.SUNFLOWER, Material.RED_TULIP, Material.ORANGE_TULIP, Material.WHITE_TULIP, Material.PINK_TULIP};
        ((AbstractCollection)$this$PLANTS_u24lambda_u242).addAll(CollectionsKt.listOf(object2));
        Object object5 = object;
        Intrinsics.checkNotNullExpressionValue(object5, "apply(...)");
        PLANTS = object5;
        Object $this$SLABS_u24lambda_u243 = object = EnumSet.noneOf(Material.class);
        boolean bl4 = false;
        for (Material material : EntriesMappings.entries$0) {
            if (!StringsKt.endsWith$default(material.name(), "_SLAB", false, 2, null)) continue;
            ((AbstractCollection)$this$SLABS_u24lambda_u243).add(material);
        }
        Object object6 = object;
        Intrinsics.checkNotNullExpressionValue(object6, "apply(...)");
        SLABS = object6;
        Object $this$WALLS_u24lambda_u244 = object = EnumSet.noneOf(Material.class);
        boolean bl5 = false;
        for (Material material : EntriesMappings.entries$0) {
            if (!StringsKt.endsWith$default(material.name(), "_WALL", false, 2, null)) continue;
            ((AbstractCollection)$this$WALLS_u24lambda_u244).add(material);
        }
        Object object7 = object;
        Intrinsics.checkNotNullExpressionValue(object7, "apply(...)");
        WALLS = object7;
        Object $this$STAIRS_u24lambda_u245 = object = EnumSet.noneOf(Material.class);
        boolean bl6 = false;
        for (Material material : EntriesMappings.entries$0) {
            if (!StringsKt.endsWith$default(material.name(), "_STAIRS", false, 2, null)) continue;
            ((AbstractCollection)$this$STAIRS_u24lambda_u245).add(material);
        }
        Object object8 = object;
        Intrinsics.checkNotNullExpressionValue(object8, "apply(...)");
        STAIRS = object8;
        Object $this$GLASS_u24lambda_u246 = object = EnumSet.noneOf(Material.class);
        boolean bl7 = false;
        for (Material material : EntriesMappings.entries$0) {
            if (!StringsKt.contains((CharSequence)material.name(), "GLASS", true)) continue;
            ((AbstractCollection)$this$GLASS_u24lambda_u246).add(material);
        }
        Object object9 = object;
        Intrinsics.checkNotNullExpressionValue(object9, "apply(...)");
        GLASS = object9;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\fR\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\fR\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\fR\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\fR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\fR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\fR\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\fR\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\fR\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\fR\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\fR\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\f\u00a8\u0006)"}, d2={"Lme/mochibit/defcon/explosions/TransformationRule$Companion;", "", "<init>", "()V", "BLOCK_TRANSFORMATION_BLACKLIST", "", "Lorg/bukkit/Material;", "getBLOCK_TRANSFORMATION_BLACKLIST", "()Ljava/util/Set;", "LIQUID_MATERIALS", "Ljava/util/EnumSet;", "getLIQUID_MATERIALS", "()Ljava/util/EnumSet;", "DEAD_PLANTS", "getDEAD_PLANTS", "BURNT_BLOCK", "getBURNT_BLOCK", "DESTROYED_BLOCK", "getDESTROYED_BLOCK", "DIRT_TRANSFORMATIONS", "getDIRT_TRANSFORMATIONS", "SLAB_TRANSFORMATIONS", "getSLAB_TRANSFORMATIONS", "WALL_TRANSFORMATIONS", "getWALL_TRANSFORMATIONS", "STAIRS_TRANSFORMATIONS", "getSTAIRS_TRANSFORMATIONS", "ATTACHED_BLOCKS", "getATTACHED_BLOCKS", "LIGHT_WEIGHT_BLOCKS", "getLIGHT_WEIGHT_BLOCKS", "PLANTS", "getPLANTS", "SLABS", "getSLABS", "WALLS", "getWALLS", "STAIRS", "getSTAIRS", "GLASS", "getGLASS", "Defcon"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<Material> getBLOCK_TRANSFORMATION_BLACKLIST() {
            return BLOCK_TRANSFORMATION_BLACKLIST;
        }

        @NotNull
        public final EnumSet<Material> getLIQUID_MATERIALS() {
            return LIQUID_MATERIALS;
        }

        @NotNull
        public final EnumSet<Material> getDEAD_PLANTS() {
            return DEAD_PLANTS;
        }

        @NotNull
        public final EnumSet<Material> getBURNT_BLOCK() {
            return BURNT_BLOCK;
        }

        @NotNull
        public final EnumSet<Material> getDESTROYED_BLOCK() {
            return DESTROYED_BLOCK;
        }

        @NotNull
        public final EnumSet<Material> getDIRT_TRANSFORMATIONS() {
            return DIRT_TRANSFORMATIONS;
        }

        @NotNull
        public final EnumSet<Material> getSLAB_TRANSFORMATIONS() {
            return SLAB_TRANSFORMATIONS;
        }

        @NotNull
        public final EnumSet<Material> getWALL_TRANSFORMATIONS() {
            return WALL_TRANSFORMATIONS;
        }

        @NotNull
        public final EnumSet<Material> getSTAIRS_TRANSFORMATIONS() {
            return STAIRS_TRANSFORMATIONS;
        }

        @NotNull
        public final EnumSet<Material> getATTACHED_BLOCKS() {
            return ATTACHED_BLOCKS;
        }

        @NotNull
        public final EnumSet<Material> getLIGHT_WEIGHT_BLOCKS() {
            return LIGHT_WEIGHT_BLOCKS;
        }

        @NotNull
        public final EnumSet<Material> getPLANTS() {
            return PLANTS;
        }

        @NotNull
        public final EnumSet<Material> getSLABS() {
            return SLABS;
        }

        @NotNull
        public final EnumSet<Material> getWALLS() {
            return WALLS;
        }

        @NotNull
        public final EnumSet<Material> getSTAIRS() {
            return STAIRS;
        }

        @NotNull
        public final EnumSet<Material> getGLASS() {
            return GLASS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Material> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Material.values()));
        }
    }
}

