/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.explosions.effects;

import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import me.mochibit.defcon.extensions.BooleanKt;
import me.mochibit.defcon.particles.emitter.ParticleInstanceKt;
import me.mochibit.lib.packetevents.PacketEvents;
import me.mochibit.lib.packetevents.manager.player.PlayerManager;
import me.mochibit.lib.packetevents.protocol.entity.data.EntityData;
import me.mochibit.lib.packetevents.protocol.entity.data.EntityDataTypes;
import me.mochibit.lib.packetevents.util.Quaternion4f;
import me.mochibit.lib.packetevents.util.Vector3f;
import me.mochibit.lib.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import me.mochibit.lib.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import me.mochibit.lib.packetevents.wrapper.play.server.WrapperPlayServerEntityTeleport;
import me.mochibit.lib.packetevents.wrapper.play.server.WrapperPlayServerSpawnEntity;
import net.kyori.adventure.text.Component;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.entity.Display;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000fJ\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cJ\u001e\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001fJ\u000e\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u0007J\u000e\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\u0007J\u0006\u0010)\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lme/mochibit/defcon/explosions/effects/ClientSideTextDisplay;", "", "player", "Lorg/bukkit/entity/Player;", "<init>", "(Lorg/bukkit/entity/Player;)V", "id", "", "metaDataList", "", "Lme/mochibit/lib/packetevents/protocol/entity/data/EntityData;", "currentOpacity", "currentScale", "Lme/mochibit/lib/packetevents/util/Vector3f;", "currentBillboard", "Lorg/bukkit/entity/Display$Billboard;", "summon", "", "setBillboard", "billboard", "setRotation", "quaternion4f", "Lme/mochibit/lib/packetevents/util/Quaternion4f;", "teleport", "location", "Lorg/bukkit/Location;", "applyTransform", "matrix", "Lorg/joml/Matrix4f;", "setScale", "width", "", "height", "depth", "setOpacity", "opacity", "setColor", "color", "Lorg/bukkit/Color;", "setInterpolationDuration", "durationTicks", "remove", "Defcon"})
public final class ClientSideTextDisplay {
    @NotNull
    private final Player player;
    private final int id;
    @NotNull
    private final List<EntityData> metaDataList;
    private int currentOpacity;
    @NotNull
    private Vector3f currentScale;
    @NotNull
    private Display.Billboard currentBillboard;

    public ClientSideTextDisplay(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this.player = player;
        this.id = Random.Default.nextInt();
        this.currentOpacity = 255;
        this.currentScale = new Vector3f(1.0f, 1.0f, 1.0f);
        this.currentBillboard = Display.Billboard.FIXED;
        boolean hasShadow = false;
        boolean isSeeThrough = true;
        boolean useDefaultBackground = false;
        int textFlags = BooleanKt.toInt(hasShadow) | BooleanKt.toInt(isSeeThrough) << 1 | BooleanKt.toInt(useDefaultBackground) << 2 | TextDisplay.TextAlignment.CENTER.ordinal() << 3;
        this.currentOpacity = 255;
        EntityData[] entityDataArray = new EntityData[]{new EntityData(8, EntityDataTypes.INT, 0), new EntityData(9, EntityDataTypes.INT, 5), new EntityData(10, EntityDataTypes.INT, 10), new EntityData(11, EntityDataTypes.VECTOR3F, new Vector3f(0.0f, 0.0f, 0.0f)), new EntityData(12, EntityDataTypes.VECTOR3F, this.currentScale), new EntityData(13, EntityDataTypes.QUATERNION, new Quaternion4f(0.0f, 0.0f, 0.0f, 1.0f)), new EntityData(14, EntityDataTypes.QUATERNION, new Quaternion4f(0.0f, 0.0f, 0.0f, 1.0f)), new EntityData(15, EntityDataTypes.BYTE, (byte)this.currentBillboard.ordinal()), new EntityData(16, EntityDataTypes.INT, 0xF000F0), new EntityData(17, EntityDataTypes.FLOAT, Float.valueOf(10000.0f)), new EntityData(18, EntityDataTypes.FLOAT, Float.valueOf(0.0f)), new EntityData(19, EntityDataTypes.FLOAT, Float.valueOf(0.0f)), new EntityData(20, EntityDataTypes.FLOAT, Float.valueOf(0.0f)), new EntityData(21, EntityDataTypes.FLOAT, Float.valueOf(0.0f)), new EntityData(22, EntityDataTypes.INT, -1), new EntityData(23, EntityDataTypes.ADV_COMPONENT, Component.text(" ")), new EntityData(24, EntityDataTypes.INT, 0), new EntityData(25, EntityDataTypes.INT, Color.WHITE.asARGB()), new EntityData(26, EntityDataTypes.BYTE, (byte)-1), new EntityData(27, EntityDataTypes.BYTE, (byte)textFlags)};
        this.metaDataList = CollectionsKt.mutableListOf(entityDataArray);
    }

    public final void summon() {
        WrapperPlayServerSpawnEntity spawnPacket = new WrapperPlayServerSpawnEntity(this.id, UUID.randomUUID(), SpigotConversionUtil.fromBukkitEntityType(EntityType.TEXT_DISPLAY), SpigotConversionUtil.fromBukkitLocation(this.player.getLocation()), 0.0f, 0, null);
        PlayerManager packetApi = PacketEvents.getAPI().getPlayerManager();
        packetApi.sendPacket((Object)this.player, spawnPacket);
        WrapperPlayServerEntityMetadata metadataPacket = new WrapperPlayServerEntityMetadata(this.id, this.metaDataList);
        packetApi.sendPacket((Object)this.player, metadataPacket);
    }

    public final void setBillboard(@NotNull Display.Billboard billboard) {
        Intrinsics.checkNotNullParameter(billboard, "billboard");
        if (billboard == this.currentBillboard) {
            return;
        }
        this.currentBillboard = billboard;
        WrapperPlayServerEntityMetadata billboardPacket = new WrapperPlayServerEntityMetadata(this.id, CollectionsKt.listOf(new EntityData(15, EntityDataTypes.BYTE, (byte)billboard.ordinal())));
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)this.player, billboardPacket);
    }

    public final void setRotation(@NotNull Quaternion4f quaternion4f) {
        Intrinsics.checkNotNullParameter(quaternion4f, "quaternion4f");
        WrapperPlayServerEntityMetadata rotationPacket = new WrapperPlayServerEntityMetadata(this.id, CollectionsKt.listOf(new EntityData(14, EntityDataTypes.QUATERNION, quaternion4f)));
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)this.player, rotationPacket);
    }

    public final void teleport(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        WrapperPlayServerEntityTeleport teleportPacket = new WrapperPlayServerEntityTeleport(this.id, SpigotConversionUtil.fromBukkitLocation(location), false);
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)this.player, teleportPacket);
    }

    public final void applyTransform(@NotNull Matrix4f matrix) {
        Intrinsics.checkNotNullParameter(matrix, "matrix");
        org.joml.Vector3f translation = new org.joml.Vector3f();
        org.joml.Vector3f scale = new org.joml.Vector3f();
        Quaternionf rotationTotal = new Quaternionf();
        matrix.getTranslation(translation);
        matrix.getScale(scale);
        matrix.getUnnormalizedRotation(rotationTotal);
        Quaternionf left = new Quaternionf().identity();
        Quaternionf right = new Quaternionf().set((Quaternionfc)rotationTotal);
        Quaternion4f rotationLeft = new Quaternion4f(left.x(), left.y(), left.z(), left.w());
        Quaternion4f rotationRight = new Quaternion4f(right.x(), right.y(), right.z(), right.w());
        EntityData[] entityDataArray = new EntityData[]{new EntityData(11, EntityDataTypes.VECTOR3F, ParticleInstanceKt.toPacketWrapper(translation)), new EntityData(12, EntityDataTypes.VECTOR3F, ParticleInstanceKt.toPacketWrapper(scale)), new EntityData(13, EntityDataTypes.QUATERNION, rotationLeft), new EntityData(14, EntityDataTypes.QUATERNION, rotationRight)};
        List<EntityData> packets = CollectionsKt.listOf(entityDataArray);
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)this.player, new WrapperPlayServerEntityMetadata(this.id, packets));
    }

    public final void setScale(float width, float height, float depth) {
        Vector3f newScale = new Vector3f(width, height, depth);
        if (Math.abs(newScale.x - this.currentScale.x) < 0.1f && Math.abs(newScale.y - this.currentScale.y) < 0.1f && Math.abs(newScale.z - this.currentScale.z) < 0.1f) {
            return;
        }
        this.currentScale = newScale;
        WrapperPlayServerEntityMetadata scalePacket = new WrapperPlayServerEntityMetadata(this.id, CollectionsKt.listOf(new EntityData(12, EntityDataTypes.VECTOR3F, this.currentScale)));
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)this.player, scalePacket);
    }

    public final void setOpacity(int opacity) {
        if (Math.abs(opacity - this.currentOpacity) < 5) {
            return;
        }
        this.currentOpacity = opacity;
        int colorWithOpacity = Color.WHITE.setAlpha(opacity).asARGB();
        WrapperPlayServerEntityMetadata opacityPacket = new WrapperPlayServerEntityMetadata(this.id, CollectionsKt.listOf(new EntityData(25, EntityDataTypes.INT, colorWithOpacity)));
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)this.player, opacityPacket);
    }

    public final void setColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "color");
        int colorWithOpacity = color.asARGB();
        WrapperPlayServerEntityMetadata colorPacket = new WrapperPlayServerEntityMetadata(this.id, CollectionsKt.listOf(new EntityData(25, EntityDataTypes.INT, colorWithOpacity)));
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)this.player, colorPacket);
    }

    public final void setInterpolationDuration(int durationTicks) {
        WrapperPlayServerEntityMetadata interpolationPacket = new WrapperPlayServerEntityMetadata(this.id, CollectionsKt.listOf(new EntityData(9, EntityDataTypes.INT, durationTicks)));
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)this.player, interpolationPacket);
    }

    public final void remove() {
        WrapperPlayServerDestroyEntities destroyPacket = new WrapperPlayServerDestroyEntities(this.id);
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)this.player, destroyPacket);
    }
}

