/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.explosions.processor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import me.mochibit.defcon.explosions.TransformationRule;
import me.mochibit.defcon.explosions.processor.Crater;
import me.mochibit.defcon.utils.BlockChanger;
import me.mochibit.defcon.utils.ChunkCache;
import me.mochibit.defcon.utils.Geometry;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ \u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u0005H\u0002J\u000e\u0010-\u001a\u00020\u0005H\u0086@\u00a2\u0006\u0002\u0010.J\u000e\u0010/\u001a\u00020\u0005H\u0082@\u00a2\u0006\u0002\u0010.J \u00100\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000502\u0012\u0004\u0012\u00020\u000501H\u0002J.\u00103\u001a\u00020\u00052\u001e\u00104\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000502\u0012\u0004\u0012\u00020\u000501H\u0082@\u00a2\u0006\u0002\u00105J.\u00106\u001a\u00020\u00052\u001e\u00104\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000502\u0012\u0004\u0012\u00020\u000501H\u0082@\u00a2\u0006\u0002\u00105J.\u00107\u001a\u0002082\u001e\u00104\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000502\u0012\u0004\u0012\u00020\u000501H\u0082@\u00a2\u0006\u0002\u00105J \u00109\u001a\u00020!2\u0006\u0010:\u001a\u00020;2\u0006\u0010*\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u0005H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020$0#j\b\u0012\u0004\u0012\u00020$`%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lme/mochibit/defcon/explosions/processor/Crater;", "", "center", "Lorg/bukkit/Location;", "radiusX", "", "radiusY", "radiusZ", "transformationRule", "Lme/mochibit/defcon/explosions/TransformationRule;", "destructionHeight", "<init>", "(Lorg/bukkit/Location;IIILme/mochibit/defcon/explosions/TransformationRule;I)V", "getCenter", "()Lorg/bukkit/Location;", "world", "Lorg/bukkit/World;", "kotlin.jvm.PlatformType", "chunkCache", "Lme/mochibit/defcon/utils/ChunkCache;", "centerX", "centerY", "centerZ", "maxRadius", "minX", "maxX", "minZ", "maxZ", "minY", "maxY", "maxScorchRayDepth", "scorchMaterials", "", "Lorg/bukkit/Material;", "processedPositions", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "blockChanger", "Lme/mochibit/defcon/utils/BlockChanger;", "isBlockProcessed", "", "x", "y", "z", "create", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createCrater", "generateParaboloidShape", "", "Lkotlin/Pair;", "applyChanges", "craterShape", "(Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "applyRayCastScorching", "applyRimScorching", "", "selectScorchMaterial", "normalizedDistance", "", "Defcon"})
@SourceDebugExtension(value={"SMAP\nCrater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Crater.kt\nme/mochibit/defcon/explosions/processor/Crater\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,275:1\n1#2:276\n*E\n"})
public final class Crater {
    @NotNull
    private final Location center;
    private final int radiusX;
    private final int radiusY;
    private final int radiusZ;
    @NotNull
    private final TransformationRule transformationRule;
    private final int destructionHeight;
    private final World world;
    @NotNull
    private final ChunkCache chunkCache;
    private final int centerX;
    private final int centerY;
    private final int centerZ;
    private final int maxRadius;
    private final int minX;
    private final int maxX;
    private final int minZ;
    private final int maxZ;
    private final int minY;
    private final int maxY;
    private final int maxScorchRayDepth;
    @NotNull
    private final List<Material> scorchMaterials;
    @NotNull
    private final HashSet<Long> processedPositions;
    @NotNull
    private final BlockChanger blockChanger;

    public Crater(@NotNull Location center, int radiusX, int radiusY, int radiusZ, @NotNull TransformationRule transformationRule, int destructionHeight) {
        Intrinsics.checkNotNullParameter(center, "center");
        Intrinsics.checkNotNullParameter(transformationRule, "transformationRule");
        this.center = center;
        this.radiusX = radiusX;
        this.radiusY = radiusY;
        this.radiusZ = radiusZ;
        this.transformationRule = transformationRule;
        this.destructionHeight = destructionHeight;
        World world = this.world = this.center.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "world");
        this.chunkCache = ChunkCache.Companion.getInstance$default(ChunkCache.Companion, world, 0, 2, null);
        this.centerX = this.center.getBlockX();
        this.centerY = Math.min(this.center.getBlockY(), this.world.getSeaLevel());
        this.centerZ = this.center.getBlockZ();
        this.maxRadius = Math.max(this.radiusX, this.radiusZ);
        this.minX = this.centerX - this.radiusX - 2;
        this.maxX = this.centerX + this.radiusX + 2;
        this.minZ = this.centerZ - this.radiusZ - 2;
        this.maxZ = this.centerZ + this.radiusZ + 2;
        this.minY = Math.max(this.centerY - this.radiusY, this.world.getMinHeight());
        this.maxY = Math.min(this.centerY + this.destructionHeight, this.world.getMaxHeight() - 1);
        this.maxScorchRayDepth = 20;
        Material[] materialArray = new Material[]{Material.TUFF, Material.DEEPSLATE, Material.BASALT, Material.BLACKSTONE, Material.COAL_BLOCK, Material.BLACK_CONCRETE_POWDER, Material.BLACK_CONCRETE};
        this.scorchMaterials = CollectionsKt.listOf(materialArray);
        this.processedPositions = new HashSet(this.maxRadius * 2 * this.maxRadius * 2 * (this.radiusY + this.destructionHeight) / 4);
        World world2 = this.world;
        Intrinsics.checkNotNullExpressionValue(world2, "world");
        this.blockChanger = BlockChanger.Companion.getInstance(world2);
    }

    @NotNull
    public final Location getCenter() {
        return this.center;
    }

    private final boolean isBlockProcessed(int x, int y, int z) {
        return !this.processedPositions.add(Geometry.INSTANCE.packIntegerCoordinates(x, y, z));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object create(@NotNull Continuation<? super Integer> $completion) {
        if (!($completion instanceof create.1)) ** GOTO lbl-1000
        var6_2 = $completion;
        if ((var6_2.label & -2147483648) != 0) {
            var6_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ Crater this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.create(this);
                }
            };
        }
        $result = $continuation.result;
        var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $continuation.label = 1;
                v0 = this.createCrater($continuation);
                ** if (v0 != var7_4) goto lbl18
lbl17:
                // 1 sources

                return var7_4;
lbl18:
                // 1 sources

                ** GOTO lbl24
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure($result);
                    v0 = $result;
lbl24:
                    // 2 sources

                    effectiveRadius = ((Number)v0).intValue();
                    var3_6 = Boxing.boxInt(effectiveRadius);
                    this.chunkCache.cleanupCache();
                    this.processedPositions.clear();
                    return var3_6;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    var4_9 = Boxing.boxInt(Math.max(this.radiusX, this.radiusZ));
                    return var4_9;
                }
            }
            {
                finally {
                    this.chunkCache.cleanupCache();
                    this.processedPositions.clear();
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object createCrater(Continuation<? super Integer> $completion) {
        if (!($completion instanceof createCrater.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ Crater this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return Crater.access$createCrater(this.this$0, this);
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                craterShape = this.generateParaboloidShape();
                $continuation.label = 1;
                v0 = this.applyChanges(craterShape, $continuation);
                if (v0 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl21
            }
            case 1: {
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl21:
                // 2 sources

                effectiveRadius = ((Number)v0).intValue();
                return Boxing.boxInt(effectiveRadius);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Map<Pair<Integer, Integer>, Integer> generateParaboloidShape() {
        HashMap craterShape = new HashMap((this.maxX - this.minX + 1) * (this.maxZ - this.minZ + 1) / 2);
        int x = this.minX;
        int n = this.maxX;
        if (x <= n) {
            while (true) {
                int n2;
                int z;
                if ((z = this.minZ) <= (n2 = this.maxZ)) {
                    while (true) {
                        double depth;
                        int craterFloorY;
                        double zComponent;
                        double xComponent;
                        double normalizedDistSquared;
                        if ((normalizedDistSquared = (xComponent = (double)(x - this.centerX) / (double)this.radiusX) * xComponent + (zComponent = (double)(z - this.centerZ) / (double)this.radiusZ) * zComponent) <= 1.0 && (craterFloorY = MathKt.roundToInt((double)this.centerY - (depth = (double)this.radiusY * (1.0 - normalizedDistSquared)))) >= this.minY) {
                            ((Map)craterShape).put(new Pair<Integer, Integer>(x, z), craterFloorY + 1);
                        }
                        if (z == n2) break;
                        ++z;
                    }
                }
                if (x == n) break;
                ++x;
            }
        }
        return craterShape;
    }

    /*
     * Unable to fully structure code
     */
    private final Object applyChanges(Map<Pair<Integer, Integer>, Integer> var1_1, Continuation<? super Integer> $completion) {
        if (!($completion instanceof applyChanges.1)) ** GOTO lbl-1000
        var13_3 = $completion;
        if ((var13_3.label & -2147483648) != 0) {
            var13_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                int I$0;
                int I$1;
                int I$2;
                int I$3;
                /* synthetic */ Object result;
                final /* synthetic */ Crater this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return Crater.access$applyChanges(this.this$0, null, this);
                }
            };
        }
        $result = $continuation.result;
        var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                var3_6 = craterShape.entrySet().iterator();
lbl13:
                // 3 sources

                while (var3_6.hasNext()) {
                    var4_8 = var3_6.next();
                    pos = (Pair)var4_8.getKey();
                    floorY = ((Number)var4_8.getValue()).intValue();
                    x = ((Number)pos.component1()).intValue();
                    z = ((Number)pos.component2()).intValue();
                    y = floorY;
                    var10_14 = Math.min(this.centerY + this.destructionHeight, this.maxY);
                    if (y > var10_14) continue;
lbl22:
                    // 2 sources

                    while (true) {
                        if (!(this.isBlockProcessed(x, y, z) || (blockType = this.chunkCache.getBlockMaterial(x, y, z)).isAir() || TransformationRule.Companion.getBLOCK_TRANSFORMATION_BLACKLIST().contains(blockType))) {
                            $continuation.L$0 = craterShape;
                            $continuation.L$1 = var3_6;
                            $continuation.I$0 = x;
                            $continuation.I$1 = z;
                            $continuation.I$2 = y;
                            $continuation.I$3 = var10_14;
                            $continuation.label = 1;
                            v0 = BlockChanger.addBlockChange$default(this.blockChanger, x, y, z, Material.AIR, false, false, null, $continuation, 80, null);
                            if (v0 == var14_5) {
                                return var14_5;
                            }
                        }
                        ** GOTO lbl45
                        break;
                    }
                }
                break;
            }
            case 1: {
                var10_14 = $continuation.I$3;
                y = $continuation.I$2;
                z = $continuation.I$1;
                x = $continuation.I$0;
                var3_6 = (Iterator)$continuation.L$1;
                craterShape = (Map)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl45:
                // 2 sources

                if (y == var10_14) ** GOTO lbl13
                ++y;
                ** continue;
            }
        }
        $continuation.L$0 = craterShape;
        $continuation.L$1 = null;
        $continuation.label = 2;
        v1 = this.applyRayCastScorching(craterShape, $continuation);
        if (v1 == var14_5) {
            return var14_5;
        }
        ** GOTO lbl59
        {
            case 2: {
                craterShape = (Map)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v1 = $result;
lbl59:
                // 2 sources

                effectiveRadius = ((Number)v1).intValue();
                $continuation.L$0 = null;
                $continuation.I$0 = effectiveRadius;
                $continuation.label = 3;
                v2 = this.applyRimScorching(craterShape, $continuation);
                if (v2 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl71
            }
            case 3: {
                effectiveRadius = $continuation.I$0;
                ResultKt.throwOnFailure($result);
                v2 = $result;
lbl71:
                // 2 sources

                return Boxing.boxInt(effectiveRadius);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object applyRayCastScorching(Map<Pair<Integer, Integer>, Integer> var1_1, Continuation<? super Integer> $completion) {
        block9: {
            if (!($completion instanceof applyRayCastScorching.1)) ** GOTO lbl-1000
            var28_3 = $completion;
            if ((var28_3.label & -2147483648) != 0) {
                var28_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    double D$0;
                    int I$0;
                    int I$1;
                    int I$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ Crater this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return Crater.access$applyRayCastScorching(this.this$0, null, this);
                    }
                };
            }
            $result = $continuation.result;
            var29_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            block0 : switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure($result);
                    scorchProcessed = new HashSet();
                    effectiveRadiusSquared = 0.0;
                    var6_8 = craterShape.entrySet().iterator();
lbl15:
                    // 4 sources

                    while (var6_8.hasNext()) {
                        var7_9 = (Map.Entry)var6_8.next();
                        pos = (Pair)var7_9.getKey();
                        floorY = ((Number)var7_9.getValue()).intValue();
                        x = ((Number)pos.component1()).intValue();
                        z = ((Number)pos.component2()).intValue();
                        xNorm = (double)(x - this.centerX) / (double)this.radiusX;
                        zNorm = (double)(z - this.centerZ) / (double)this.radiusZ;
                        normalizedDist = Math.sqrt(xNorm * xNorm + zNorm * zNorm);
                        rayDepth = 0;
                        var19_18 = this.maxScorchRayDepth;
                        if (rayDepth > var19_18) continue;
lbl27:
                        // 2 sources

                        while (true) {
                            targetY = floorY - rayDepth;
                            if (targetY < this.minY || this.isBlockProcessed(x, targetY, z) || scorchProcessed.contains(Boxing.boxLong(Geometry.INSTANCE.packIntegerCoordinates(x, targetY, z))) || (blockType = this.chunkCache.getBlockMaterial(x, targetY, z)).isAir() || TransformationRule.Companion.getLIQUID_MATERIALS().contains(blockType) || TransformationRule.Companion.getBLOCK_TRANSFORMATION_BLACKLIST().contains(blockType)) break block0;
                            scorchMaterial = this.selectScorchMaterial(normalizedDist, x, z);
                            $continuation.L$0 = scorchProcessed;
                            $continuation.L$1 = var6_8;
                            $continuation.D$0 = effectiveRadiusSquared;
                            $continuation.I$0 = x;
                            $continuation.I$1 = z;
                            $continuation.I$2 = targetY;
                            $continuation.label = 1;
                            v0 = BlockChanger.addBlockChange$default(this.blockChanger, x, targetY, z, scorchMaterial, false, false, null, $continuation, 80, null);
                            if (v0 == var29_5) {
                                return var29_5;
                            }
                            ** GOTO lbl52
                            break;
                        }
                    }
                    break block9;
                }
                case 1: {
                    targetY = $continuation.I$2;
                    z = $continuation.I$1;
                    x = $continuation.I$0;
                    effectiveRadiusSquared = $continuation.D$0;
                    var6_8 = (Iterator)$continuation.L$1;
                    scorchProcessed = (HashSet)$continuation.L$0;
                    ResultKt.throwOnFailure($result);
                    v0 = $result;
lbl52:
                    // 2 sources

                    scorchProcessed.add(Boxing.boxLong(Geometry.INSTANCE.packIntegerCoordinates(x, targetY, z)));
                    dx = x - this.centerX;
                    dz = z - this.centerZ;
                    effectiveRadiusSquared = Math.max(effectiveRadiusSquared, dx * dx + dz * dz);
                    ** GOTO lbl15
                }
            }
            if (rayDepth == var19_18) ** GOTO lbl15
            ++rayDepth;
            ** while (true)
        }
        return Boxing.boxInt(MathKt.roundToInt(Math.sqrt(effectiveRadiusSquared)));
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object applyRimScorching(Map<Pair<Integer, Integer>, Integer> var1_1, Continuation<? super Unit> $completion) {
        if (!($completion instanceof applyRimScorching.1)) ** GOTO lbl-1000
        var23_3 = $completion;
        if ((var23_3.label & -2147483648) != 0) {
            var23_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                int I$0;
                int I$1;
                int I$2;
                /* synthetic */ Object result;
                final /* synthetic */ Crater this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return Crater.access$applyRimScorching(this.this$0, null, this);
                }
            };
        }
        $result = $continuation.result;
        var24_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                scorchProcessed = new HashSet();
                craterPositionSet = CollectionsKt.toHashSet((Iterable)craterShape.keySet());
                rimPositions = new HashSet<Pair>();
                var6_9 = craterShape.entrySet().iterator();
                while (var6_9.hasNext()) {
                    pos = (Pair)var6_9.next().getKey();
                    x = ((Number)pos.component1()).intValue();
                    z = ((Number)pos.component2()).intValue();
                    var12_17 = new Pair[]{new Pair<Integer, Integer>(Boxing.boxInt(x + 1), Boxing.boxInt(z)), new Pair<Integer, Integer>(Boxing.boxInt(x - 1), Boxing.boxInt(z)), new Pair<Integer, Integer>(Boxing.boxInt(x), Boxing.boxInt(z + 1)), new Pair<Integer, Integer>(Boxing.boxInt(x), Boxing.boxInt(z - 1)), new Pair<Integer, Integer>(Boxing.boxInt(x + 1), Boxing.boxInt(z + 1)), new Pair<Integer, Integer>(Boxing.boxInt(x + 1), Boxing.boxInt(z - 1)), new Pair<Integer, Integer>(Boxing.boxInt(x - 1), Boxing.boxInt(z + 1)), new Pair<Integer, Integer>(Boxing.boxInt(x - 1), Boxing.boxInt(z - 1))};
                    neighbors = CollectionsKt.listOf(var12_17);
                    for (Pair neighbor : neighbors) {
                        nx = ((Number)neighbor.component1()).intValue();
                        nz = ((Number)neighbor.component2()).intValue();
                        var16_26 = this.minX;
                        v0 = nx <= this.maxX ? var16_26 <= nx : false;
                        if (!v0) continue;
                        var16_26 = this.minZ;
                        v1 = nz <= this.maxZ ? var16_26 <= nz : false;
                        if (!v1 || craterPositionSet.contains(neighbor)) continue;
                        rimPositions.add(neighbor);
                    }
                }
                var7_27 = rimPositions.iterator();
                Intrinsics.checkNotNullExpressionValue(var7_27, "iterator(...)");
                var6_9 = var7_27;
lbl38:
                // 3 sources

                while (var6_9.hasNext()) {
                    var7_27 = (Pair)var6_9.next();
                    x = ((Number)var7_27.component1()).intValue();
                    z = ((Number)var7_27.component2()).intValue();
                    topY = -1;
                    var12_19 = this.minY;
                    y = this.maxY;
                    if (var12_19 <= y) {
                        while (true) {
                            if (!((blockType = this.chunkCache.getBlockMaterial(x, y, z)).isAir() || TransformationRule.Companion.getLIQUID_MATERIALS().contains(blockType) || TransformationRule.Companion.getBLOCK_TRANSFORMATION_BLACKLIST().contains(blockType))) {
                                topY = y;
                                break;
                            }
                            if (y == var12_19) break;
                            --y;
                        }
                    }
                    if (topY == -1 || this.isBlockProcessed(x, topY, z) || scorchProcessed.contains(Boxing.boxLong(Geometry.INSTANCE.packIntegerCoordinates(x, topY, z))) || !((distance = Math.sqrt((xNorm = (double)(x - this.centerX) / (double)this.radiusX) * xNorm + (zNorm = (double)(z - this.centerZ) / (double)this.radiusZ) * zNorm)) < (offsetDist = 1.4))) continue;
                    intensity = Math.max(0.0, 1.0 - distance / offsetDist);
                    material = this.selectScorchMaterial(1.0 - intensity, x, z);
                    $continuation.L$0 = scorchProcessed;
                    $continuation.L$1 = var6_9;
                    $continuation.I$0 = x;
                    $continuation.I$1 = z;
                    $continuation.I$2 = topY;
                    $continuation.label = 1;
                    v2 = BlockChanger.addBlockChange$default(this.blockChanger, x, topY, z, material, false, true, null, $continuation, 80, null);
                    if (v2 == var24_5) {
                        return var24_5;
                    }
                    ** GOTO lbl75
                }
                break;
            }
            case 1: {
                topY = $continuation.I$2;
                z = $continuation.I$1;
                x = $continuation.I$0;
                var6_9 = (Iterator<Map.Entry<K, V>>)$continuation.L$1;
                scorchProcessed = (HashSet)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v2 = $result;
lbl75:
                // 2 sources

                scorchProcessed.add(Boxing.boxLong(Geometry.INSTANCE.packIntegerCoordinates(x, topY, z)));
                ** GOTO lbl38
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Material selectScorchMaterial(double normalizedDistance, int x, int z) {
        Material material;
        double clampedDistance = RangesKt.coerceIn(normalizedDistance, 0.0, 1.0);
        double variation = 0.25;
        double distortion = (Geometry.INSTANCE.wangNoise(x, 0, z) - 0.5) * variation;
        double distortedDistance = RangesKt.coerceIn(clampedDistance + distortion, 0.0, 1.0);
        int index = MathKt.roundToInt((1.0 - distortedDistance) * (double)(this.scorchMaterials.size() - 1));
        List<Material> list = this.scorchMaterials;
        boolean bl = 0 <= index ? index < list.size() : false;
        if (bl) {
            material = list.get(index);
        } else {
            int it = index;
            boolean bl2 = false;
            material = CollectionsKt.first(this.scorchMaterials);
        }
        return material;
    }

    public static final /* synthetic */ Object access$createCrater(Crater $this, Continuation $completion) {
        return $this.createCrater($completion);
    }

    public static final /* synthetic */ Object access$applyChanges(Crater $this, Map craterShape, Continuation $completion) {
        return $this.applyChanges(craterShape, $completion);
    }

    public static final /* synthetic */ Object access$applyRayCastScorching(Crater $this, Map craterShape, Continuation $completion) {
        return $this.applyRayCastScorching(craterShape, $completion);
    }

    public static final /* synthetic */ Object access$applyRimScorching(Crater $this, Map craterShape, Continuation $completion) {
        return $this.applyRimScorching(craterShape, $completion);
    }
}

