/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.explosions.processor;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import me.mochibit.defcon.Defcon;
import me.mochibit.defcon.threading.scheduling.SchedulingUtilsKt;
import me.mochibit.lib.mccoroutine.bukkit.MCCoroutineKt;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u0000 R2\u00020\u0001:\u0003PQRB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u00106\u001a\u0002072\b\b\u0002\u00108\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b9\u0010:J\b\u0010;\u001a\u000207H\u0016J\u0014\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=H\u0094@\u00a2\u0006\u0002\u0010?J\u0010\u0010@\u001a\u0002072\u0006\u0010A\u001a\u00020>H\u0002J\u0010\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0004J\u0010\u0010F\u001a\u0002052\u0006\u0010G\u001a\u00020HH\u0004J\u0010\u0010I\u001a\u00020\n2\u0006\u0010G\u001a\u00020HH\u0002J\u0010\u0010J\u001a\u0002052\u0006\u0010A\u001a\u00020>H\u0014J\u0010\u0010K\u001a\u0002052\u0006\u0010L\u001a\u00020&H\u0002J\u0010\u0010M\u001a\u0002072\u0006\u0010A\u001a\u00020>H\u0014J\u0018\u0010N\u001a\u0002072\u0006\u0010A\u001a\u00020>2\u0006\u0010O\u001a\u00020CH$R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010R\u0014\u0010\u001a\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0010R\u0014\u0010\u001c\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0010R\u0014\u0010\u001e\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0010R\u0014\u0010 \u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0010R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010%\u001a\u00070&\u00a2\u0006\u0002\b'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010(\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+0)X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0016\u0010.\u001a\n\u0018\u00010/j\u0004\u0018\u0001`0X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u00101\u001a\u001a\u0012\u0004\u0012\u00020*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020\n020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u00104\u001a\u001a\u0012\u0004\u0012\u00020*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u000205020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lme/mochibit/defcon/explosions/processor/RaycastedEffector;", "", "center", "Lorg/bukkit/Location;", "reach", "", "raycastHeight", "duration", "Lkotlin/time/Duration;", "skyVisibilityRequired", "", "<init>", "(Lorg/bukkit/Location;IIJFLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getCenter", "()Lorg/bukkit/Location;", "getReach", "()I", "getDuration-UwyO8pc", "()J", "J", "world", "Lorg/bukkit/World;", "getWorld", "()Lorg/bukkit/World;", "reachSquared", "getReachSquared", "closeRangeThreshold", "getCloseRangeThreshold", "closeRangeThresholdSquared", "getCloseRangeThresholdSquared", "farRangeThreshold", "getFarRangeThreshold", "farRangeThresholdSquared", "getFarRangeThresholdSquared", "effectBoundingBox", "Lorg/bukkit/util/BoundingBox;", "relativeCastPos", "centerVector", "Lorg/bukkit/util/Vector;", "Lorg/jetbrains/annotations/NotNull;", "affectedEntities", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lme/mochibit/defcon/explosions/processor/RaycastedEffector$EffectorData;", "getAffectedEntities", "()Ljava/util/concurrent/ConcurrentHashMap;", "trackingTask", "Ljava/io/Closeable;", "Lio/ktor/utils/io/core/Closeable;", "skyVisibilityCache", "Lkotlin/Pair;", "", "lineOfSightCache", "", "start", "", "trackingDuration", "start-LRDsOJo", "(J)V", "stop", "getTargetEntities", "", "Lorg/bukkit/entity/Entity;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkAndApplyEffect", "entity", "determineEffectType", "Lme/mochibit/defcon/explosions/processor/RaycastedEffector$EffectType;", "distanceSquared", "", "isPlayerInOpenAir", "player", "Lorg/bukkit/entity/Player;", "calculateSkyVisibility", "hasLineOfSightToSource", "checkRaycastFromSource", "entityPos", "cleanup", "applyEffect", "effectType", "EffectorData", "EffectType", "Companion", "Defcon"})
@SourceDebugExtension(value={"SMAP\nRaycastedEffector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RaycastedEffector.kt\nme/mochibit/defcon/explosions/processor/RaycastedEffector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,377:1\n1869#2,2:378\n1#3:380\n*S KotlinDebug\n*F\n+ 1 RaycastedEffector.kt\nme/mochibit/defcon/explosions/processor/RaycastedEffector\n*L\n114#1:378,2\n*E\n"})
public abstract class RaycastedEffector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Location center;
    private final int reach;
    private final int raycastHeight;
    private final long duration;
    private final float skyVisibilityRequired;
    @NotNull
    private final World world;
    private final int reachSquared;
    private final int closeRangeThreshold;
    private final int closeRangeThresholdSquared;
    private final int farRangeThreshold;
    private final int farRangeThresholdSquared;
    @NotNull
    private final BoundingBox effectBoundingBox;
    @NotNull
    private final Location relativeCastPos;
    @NotNull
    private final Vector centerVector;
    @NotNull
    private final ConcurrentHashMap<UUID, EffectorData> affectedEntities;
    @Nullable
    private Closeable trackingTask;
    @NotNull
    private final ConcurrentHashMap<UUID, Pair<Long, Float>> skyVisibilityCache;
    @NotNull
    private final ConcurrentHashMap<UUID, Pair<Long, Boolean>> lineOfSightCache;
    public static final long SKY_VISIBILITY_CACHE_DURATION = 5000L;
    public static final long LINE_OF_SIGHT_CACHE_DURATION = 500L;

    private RaycastedEffector(Location center, int reach, int raycastHeight, long duration, float skyVisibilityRequired) {
        Intrinsics.checkNotNullParameter(center, "center");
        this.center = center;
        this.reach = reach;
        this.raycastHeight = raycastHeight;
        this.duration = duration;
        this.skyVisibilityRequired = skyVisibilityRequired;
        World world = this.center.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        this.world = world;
        this.reachSquared = this.reach * this.reach;
        this.closeRangeThreshold = this.reach / 3;
        this.closeRangeThresholdSquared = this.closeRangeThreshold * this.closeRangeThreshold;
        this.farRangeThreshold = this.reach * 2 / 3;
        this.farRangeThresholdSquared = this.farRangeThreshold * this.farRangeThreshold;
        BoundingBox boundingBox = BoundingBox.of((Location)this.center.clone().subtract((double)this.reach, (double)this.reach, (double)this.reach), (Location)this.center.clone().add((double)this.reach, (double)this.reach, (double)this.reach));
        Intrinsics.checkNotNullExpressionValue(boundingBox, "of(...)");
        this.effectBoundingBox = boundingBox;
        this.relativeCastPos = new Location(this.world, this.center.getX(), this.center.getY() + (double)this.raycastHeight, this.center.getZ());
        Vector vector = this.center.toVector();
        Intrinsics.checkNotNullExpressionValue(vector, "toVector(...)");
        this.centerVector = vector;
        this.affectedEntities = new ConcurrentHashMap();
        this.skyVisibilityCache = new ConcurrentHashMap();
        this.lineOfSightCache = new ConcurrentHashMap();
    }

    public /* synthetic */ RaycastedEffector(Location location, int n, int n2, long l, float f, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n2 = 100;
        }
        if ((n3 & 8) != 0) {
            l = DurationKt.toDuration(20, DurationUnit.SECONDS);
        }
        if ((n3 & 0x10) != 0) {
            f = 0.3f;
        }
        this(location, n, n2, l, f, null);
    }

    @NotNull
    protected final Location getCenter() {
        return this.center;
    }

    protected final int getReach() {
        return this.reach;
    }

    protected final long getDuration-UwyO8pc() {
        return this.duration;
    }

    @NotNull
    protected final World getWorld() {
        return this.world;
    }

    protected final int getReachSquared() {
        return this.reachSquared;
    }

    protected final int getCloseRangeThreshold() {
        return this.closeRangeThreshold;
    }

    protected final int getCloseRangeThresholdSquared() {
        return this.closeRangeThresholdSquared;
    }

    protected final int getFarRangeThreshold() {
        return this.farRangeThreshold;
    }

    protected final int getFarRangeThresholdSquared() {
        return this.farRangeThresholdSquared;
    }

    @NotNull
    protected final ConcurrentHashMap<UUID, EffectorData> getAffectedEntities() {
        return this.affectedEntities;
    }

    public void start-LRDsOJo(long trackingDuration) {
        this.trackingTask = SchedulingUtilsKt.intervalAsync-NqJ4yvY$default(DurationKt.toDuration(0.25, DurationUnit.SECONDS), 0L, new Function1<Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ RaycastedEffector this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        this.label = 1;
                        v0 = this.this$0.getTargetEntities(this);
                        if (v0 == var9_2) {
                            return var9_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        var2_3 = (Iterable)v0;
                        var3_4 = this.this$0;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            entity = (Entity)element$iv;
                            $i$a$-forEach-RaycastedEffector$start$1$1 = false;
                            RaycastedEffector.access$checkAndApplyEffect(var3_4, entity);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
        SchedulingUtilsKt.runLater-VtjQ1oo(this.duration, (Function1<? super Continuation<? super Unit>, ? extends Object>)new Function1<Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ RaycastedEffector this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        this.this$0.stop();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public static /* synthetic */ void start-LRDsOJo$default(RaycastedEffector raycastedEffector, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: start-LRDsOJo");
        }
        if ((n & 1) != 0) {
            l = raycastedEffector.duration;
        }
        raycastedEffector.start-LRDsOJo(l);
    }

    public void stop() {
        Closeable closeable = this.trackingTask;
        if (closeable != null) {
            closeable.close();
        }
        this.trackingTask = null;
        Collection<EffectorData> collection = this.affectedEntities.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EffectorData effectData = (EffectorData)element$iv;
            boolean bl = false;
            effectData.getTask().close();
        }
        this.affectedEntities.clear();
        this.skyVisibilityCache.clear();
        this.lineOfSightCache.clear();
    }

    @Nullable
    protected Object getTargetEntities(@NotNull Continuation<? super List<? extends Entity>> $completion) {
        return RaycastedEffector.getTargetEntities$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object getTargetEntities$suspendImpl(RaycastedEffector $this, Continuation<? super List<? extends Entity>> $completion) {
        return BuildersKt.withContext(MCCoroutineKt.getMinecraftDispatcher((Plugin)Defcon.Companion.getInstance()), (Function2)new Function2<CoroutineScope, Continuation<? super List<? extends Entity>>, Object>($this, null){
            int label;
            final /* synthetic */ RaycastedEffector this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$filterTo$iv$iv;
                        void $this$filter$iv;
                        ResultKt.throwOnFailure(object);
                        Collection collection = this.this$0.getCenter().getWorld().getNearbyEntities(RaycastedEffector.access$getEffectBoundingBox$p(this.this$0));
                        Intrinsics.checkNotNullExpressionValue(collection, "getNearbyEntities(...)");
                        Iterable iterable = collection;
                        RaycastedEffector raycastedEffector = this.this$0;
                        boolean $i$f$filter = false;
                        void var5_5 = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            Entity entity = (Entity)element$iv$iv;
                            boolean bl = false;
                            if (!(entity.getLocation().distanceSquared(raycastedEffector.getCenter()) <= (double)raycastedEffector.getReachSquared())) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        return (List)destination$iv$iv;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends Entity>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    private final void checkAndApplyEffect(Entity entity) {
        UUID uUID = entity.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID entityId = uUID;
        if (this.affectedEntities.containsKey(entityId)) {
            return;
        }
        Location location = entity.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Location location2 = location;
        if (!Intrinsics.areEqual(entity.getWorld(), this.world) || !this.effectBoundingBox.contains(location2.toVector())) {
            return;
        }
        double distanceSquared = location2.distanceSquared(this.center);
        if (distanceSquared > (double)this.reachSquared) {
            return;
        }
        EffectType effectType = this.determineEffectType(distanceSquared);
        if (effectType == EffectType.FAR_RANGE && entity instanceof Player && !this.isPlayerInOpenAir((Player)entity)) {
            return;
        }
        if (!this.hasLineOfSightToSource(entity)) {
            return;
        }
        this.applyEffect(entity, effectType);
    }

    @NotNull
    protected final EffectType determineEffectType(double distanceSquared) {
        return distanceSquared <= (double)this.closeRangeThresholdSquared ? EffectType.CLOSE_RANGE : (distanceSquared <= (double)this.farRangeThresholdSquared ? EffectType.MID_RANGE : EffectType.FAR_RANGE);
    }

    protected final boolean isPlayerInOpenAir(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        long now = System.currentTimeMillis();
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID entityId = uUID;
        Pair<Long, Float> pair = this.skyVisibilityCache.get(entityId);
        if (pair != null) {
            Pair<Long, Float> pair2 = pair;
            boolean bl = false;
            long timestamp = ((Number)pair2.component1()).longValue();
            float visibility = ((Number)pair2.component2()).floatValue();
            if (now - timestamp < 5000L) {
                return visibility >= this.skyVisibilityRequired;
            }
        }
        float skyVisibility = this.calculateSkyVisibility(player);
        ((Map)this.skyVisibilityCache).put(entityId, new Pair<Long, Float>(now, Float.valueOf(skyVisibility)));
        return skyVisibility >= this.skyVisibilityRequired;
    }

    private final float calculateSkyVisibility(Player player) {
        Location location = player.getEyeLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getEyeLocation(...)");
        Location location2 = location;
        int samples = 5;
        int visibleSky = 0;
        Vector[] vectorArray = new Vector[]{new Vector(0.0, 1.0, 0.0), new Vector(0.5, 1.0, 0.0), new Vector(-0.5, 1.0, 0.0), new Vector(0.0, 1.0, 0.5), new Vector(0.0, 1.0, -0.5)};
        List<Vector> directions = CollectionsKt.listOf(vectorArray);
        for (Vector dir : directions) {
            Vector rayVector;
            Intrinsics.checkNotNullExpressionValue(dir.normalize(), "normalize(...)");
            RayTraceResult result = this.world.rayTraceBlocks(location2, rayVector, 256.0, FluidCollisionMode.NEVER, true);
            if (result != null) continue;
            ++visibleSky;
        }
        return (float)visibleSky / (float)samples;
    }

    protected boolean hasLineOfSightToSource(@NotNull Entity entity) {
        RayTraceResult result;
        Location location;
        boolean hasLineOfSight;
        Location location2;
        Intrinsics.checkNotNullParameter(entity, "entity");
        long now = System.currentTimeMillis();
        UUID uUID = entity.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID entityId = uUID;
        Location location3 = this.lineOfSightCache.get(entityId);
        if (location3 != null) {
            location2 = location3;
            boolean bl = false;
            long timestamp = ((Number)location2.component1()).longValue();
            hasLineOfSight = (Boolean)location2.component2();
            if (now - timestamp < 500L) {
                return hasLineOfSight;
            }
        }
        if (entity instanceof Player) {
            location = ((Player)entity).getEyeLocation();
        } else {
            Location $this$hasLineOfSightToSource_u24lambda_u243 = location2 = entity.getLocation();
            boolean bl = false;
            $this$hasLineOfSightToSource_u24lambda_u243.setY($this$hasLineOfSightToSource_u24lambda_u243.getY() + entity.getHeight() / (double)2);
            location = location2;
        }
        Location location4 = location;
        Intrinsics.checkNotNull(location4);
        Location entityEyeLocation = location4;
        Vector vector = entityEyeLocation.toVector();
        Intrinsics.checkNotNullExpressionValue(vector, "toVector(...)");
        Vector entityPos = vector;
        Vector vector2 = this.relativeCastPos.toVector().subtract(entityPos).normalize();
        Intrinsics.checkNotNullExpressionValue(vector2, "normalize(...)");
        Vector directionToSource = vector2;
        double distanceSquared = entityEyeLocation.distanceSquared(this.center);
        if (entity instanceof Player) {
            double maxAngle;
            double lookingAngle = entityEyeLocation.getDirection().angle(directionToSource);
            double d = distanceSquared <= (double)this.closeRangeThresholdSquared ? Math.PI : (maxAngle = distanceSquared <= (double)this.farRangeThresholdSquared ? 2.356194490192345 : 1.5707963267948966);
            if (lookingAngle > maxAngle) {
                boolean result2 = distanceSquared <= (double)this.closeRangeThresholdSquared ? this.checkRaycastFromSource(entityPos) : false;
                ((Map)this.lineOfSightCache).put(entityId, new Pair<Long, Boolean>(now, result2));
                return result2;
            }
        }
        hasLineOfSight = (result = this.world.rayTraceBlocks(entityEyeLocation, directionToSource, (double)this.reach, FluidCollisionMode.NEVER, true)) == null || result.getHitPosition().distanceSquared(this.centerVector) < 4.0;
        ((Map)this.lineOfSightCache).put(entityId, new Pair<Long, Boolean>(now, hasLineOfSight));
        return hasLineOfSight;
    }

    private final boolean checkRaycastFromSource(Vector entityPos) {
        Vector[] vectorArray = new Vector[]{this.center.toVector().subtract(this.relativeCastPos.toVector()).normalize(), new Vector(0.0, -1.0, 0.0)};
        List<Vector> directions = CollectionsKt.listOf(vectorArray);
        for (Vector direction : directions) {
            Block hitBlock;
            RayTraceResult result;
            if (this.world.rayTraceBlocks(this.relativeCastPos, direction, (double)this.reach, FluidCollisionMode.NEVER, true) == null) {
                return true;
            }
            if (result.getHitBlock() == null) {
                return true;
            }
            double distanceToEntity = entityPos.distanceSquared(hitBlock.getLocation().toVector());
            if (!(distanceToEntity < 9.0)) continue;
            return true;
        }
        return false;
    }

    protected void cleanup(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        UUID uUID = entity.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID entityUUID = uUID;
        EffectorData effectorData = this.affectedEntities.remove(entityUUID);
        if (effectorData == null) {
            return;
        }
        EffectorData effectData = effectorData;
        effectData.getTask().close();
        this.skyVisibilityCache.remove(entityUUID);
        this.lineOfSightCache.remove(entityUUID);
    }

    protected abstract void applyEffect(@NotNull Entity var1, @NotNull EffectType var2);

    public /* synthetic */ RaycastedEffector(Location center, int reach, int raycastHeight, long duration, float skyVisibilityRequired, DefaultConstructorMarker $constructor_marker) {
        this(center, reach, raycastHeight, duration, skyVisibilityRequired);
    }

    public static final /* synthetic */ void access$checkAndApplyEffect(RaycastedEffector $this, Entity entity) {
        $this.checkAndApplyEffect(entity);
    }

    public static final /* synthetic */ BoundingBox access$getEffectBoundingBox$p(RaycastedEffector $this) {
        return $this.effectBoundingBox;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lme/mochibit/defcon/explosions/processor/RaycastedEffector$Companion;", "", "<init>", "()V", "SKY_VISIBILITY_CACHE_DURATION", "", "LINE_OF_SIGHT_CACHE_DURATION", "Defcon"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0084\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lme/mochibit/defcon/explosions/processor/RaycastedEffector$EffectType;", "", "<init>", "(Ljava/lang/String;I)V", "CLOSE_RANGE", "MID_RANGE", "FAR_RANGE", "Defcon"})
    protected static final class EffectType
    extends Enum<EffectType> {
        public static final /* enum */ EffectType CLOSE_RANGE = new EffectType();
        public static final /* enum */ EffectType MID_RANGE = new EffectType();
        public static final /* enum */ EffectType FAR_RANGE = new EffectType();
        private static final /* synthetic */ EffectType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static EffectType[] values() {
            return (EffectType[])$VALUES.clone();
        }

        public static EffectType valueOf(String value) {
            return Enum.valueOf(EffectType.class, value);
        }

        @NotNull
        public static EnumEntries<EffectType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = effectTypeArray = new EffectType[]{EffectType.CLOSE_RANGE, EffectType.MID_RANGE, EffectType.FAR_RANGE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0084\b\u0018\u00002\u00020\u0001B1\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\u0015\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\tH\u00c6\u0003J5\u0010\u0019\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lme/mochibit/defcon/explosions/processor/RaycastedEffector$EffectorData;", "", "task", "Ljava/io/Closeable;", "Lio/ktor/utils/io/core/Closeable;", "startTime", "", "effectDuration", "currentEffectType", "Lme/mochibit/defcon/explosions/processor/RaycastedEffector$EffectType;", "<init>", "(Ljava/io/Closeable;JJLme/mochibit/defcon/explosions/processor/RaycastedEffector$EffectType;)V", "getTask", "()Ljava/io/Closeable;", "getStartTime", "()J", "getEffectDuration", "getCurrentEffectType", "()Lme/mochibit/defcon/explosions/processor/RaycastedEffector$EffectType;", "setCurrentEffectType", "(Lme/mochibit/defcon/explosions/processor/RaycastedEffector$EffectType;)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Defcon"})
    protected static final class EffectorData {
        @NotNull
        private final Closeable task;
        private final long startTime;
        private final long effectDuration;
        @NotNull
        private EffectType currentEffectType;

        public EffectorData(@NotNull Closeable task, long startTime, long effectDuration, @NotNull EffectType currentEffectType) {
            Intrinsics.checkNotNullParameter(task, "task");
            Intrinsics.checkNotNullParameter((Object)currentEffectType, "currentEffectType");
            this.task = task;
            this.startTime = startTime;
            this.effectDuration = effectDuration;
            this.currentEffectType = currentEffectType;
        }

        public /* synthetic */ EffectorData(Closeable closeable, long l, long l2, EffectType effectType, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                l = System.currentTimeMillis();
            }
            if ((n & 4) != 0) {
                l2 = 0L;
            }
            if ((n & 8) != 0) {
                effectType = EffectType.MID_RANGE;
            }
            this(closeable, l, l2, effectType);
        }

        @NotNull
        public final Closeable getTask() {
            return this.task;
        }

        public final long getStartTime() {
            return this.startTime;
        }

        public final long getEffectDuration() {
            return this.effectDuration;
        }

        @NotNull
        public final EffectType getCurrentEffectType() {
            return this.currentEffectType;
        }

        public final void setCurrentEffectType(@NotNull EffectType effectType) {
            Intrinsics.checkNotNullParameter((Object)effectType, "<set-?>");
            this.currentEffectType = effectType;
        }

        @NotNull
        public final Closeable component1() {
            return this.task;
        }

        public final long component2() {
            return this.startTime;
        }

        public final long component3() {
            return this.effectDuration;
        }

        @NotNull
        public final EffectType component4() {
            return this.currentEffectType;
        }

        @NotNull
        public final EffectorData copy(@NotNull Closeable task, long startTime, long effectDuration, @NotNull EffectType currentEffectType) {
            Intrinsics.checkNotNullParameter(task, "task");
            Intrinsics.checkNotNullParameter((Object)currentEffectType, "currentEffectType");
            return new EffectorData(task, startTime, effectDuration, currentEffectType);
        }

        public static /* synthetic */ EffectorData copy$default(EffectorData effectorData, Closeable closeable, long l, long l2, EffectType effectType, int n, Object object) {
            if ((n & 1) != 0) {
                closeable = effectorData.task;
            }
            if ((n & 2) != 0) {
                l = effectorData.startTime;
            }
            if ((n & 4) != 0) {
                l2 = effectorData.effectDuration;
            }
            if ((n & 8) != 0) {
                effectType = effectorData.currentEffectType;
            }
            return effectorData.copy(closeable, l, l2, effectType);
        }

        @NotNull
        public String toString() {
            return "EffectorData(task=" + this.task + ", startTime=" + this.startTime + ", effectDuration=" + this.effectDuration + ", currentEffectType=" + this.currentEffectType + ")";
        }

        public int hashCode() {
            int result = this.task.hashCode();
            result = result * 31 + Long.hashCode(this.startTime);
            result = result * 31 + Long.hashCode(this.effectDuration);
            result = result * 31 + this.currentEffectType.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EffectorData)) {
                return false;
            }
            EffectorData effectorData = (EffectorData)other;
            if (!Intrinsics.areEqual(this.task, effectorData.task)) {
                return false;
            }
            if (this.startTime != effectorData.startTime) {
                return false;
            }
            if (this.effectDuration != effectorData.effectDuration) {
                return false;
            }
            return this.currentEffectType == effectorData.currentEffectType;
        }
    }
}

