/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.listeners.items;

import io.papermc.paper.event.entity.EntityEquipmentChangedEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import me.mochibit.defcon.enums.ItemBehaviour;
import me.mochibit.defcon.events.radiationarea.RadiationSuffocationEvent;
import me.mochibit.defcon.extensions.ItemStackKt;
import me.mochibit.defcon.extensions.RangeKt;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lme/mochibit/defcon/listeners/items/GasMaskListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "protectFromGas", "", "event", "Lme/mochibit/defcon/events/radiationarea/RadiationSuffocationEvent;", "onGasMaskEquip", "Lio/papermc/paper/event/entity/EntityEquipmentChangedEvent;", "Defcon"})
public final class GasMaskListener
implements Listener {
    @EventHandler
    public final void protectFromGas(@NotNull RadiationSuffocationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        Player player = event.getPlayer();
        ItemStack itemStack = player.getInventory().getHelmet();
        if (itemStack == null) {
            return;
        }
        ItemStack helmet = itemStack;
        ItemBehaviour itemBehaviour = ItemStackKt.getBehaviour(helmet);
        if (itemBehaviour != ItemBehaviour.GAS_MASK) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public final void onGasMaskEquip(@NotNull EntityEquipmentChangedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        EntityEquipmentChangedEvent.EquipmentChange equipmentChange = (EntityEquipmentChangedEvent.EquipmentChange)event.getEquipmentChanges().get(EquipmentSlot.HEAD);
        if (equipmentChange == null) {
            return;
        }
        EntityEquipmentChangedEvent.EquipmentChange changedSlot = equipmentChange;
        ItemStack itemStack = changedSlot.newItem();
        Intrinsics.checkNotNullExpressionValue(itemStack, "newItem(...)");
        ItemStack newItem = itemStack;
        ItemBehaviour itemBehaviour = ItemStackKt.getBehaviour(newItem);
        if (itemBehaviour != ItemBehaviour.GAS_MASK) {
            return;
        }
        LivingEntity it = event.getEntity();
        boolean bl = false;
        float randomizedPitch = RangeKt.random(RangesKt.rangeTo(0.6f, 0.9f));
        it.getWorld().playSound(it.getLocation(), Sound.ENTITY_PLAYER_BREATH, 2.0f, randomizedPitch);
    }
}

