/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.particles.emitter;

import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.mochibit.defcon.particles.emitter.TextDisplayParticleInstance;
import me.mochibit.defcon.particles.templates.AbstractParticle;
import me.mochibit.defcon.particles.templates.GenericParticleProperties;
import me.mochibit.defcon.particles.templates.TextDisplayParticleProperties;
import me.mochibit.defcon.utils.ColorUtils;
import org.bukkit.Color;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 .2\u00020\u0001:\u0001.B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0007J\u000e\u0010 \u001a\u00020\u001e2\u0006\u0010\b\u001a\u00020\u0007J\u000e\u0010!\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\u0007J\u000e\u0010\"\u001a\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010#\u001a\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020\u0018J\u0006\u0010(\u001a\u00020\u0018J\u0010\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020+H&J\u0010\u0010,\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020+H&J\u0010\u0010-\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020+H&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lme/mochibit/defcon/particles/emitter/ParticleInstance;", "", "particleProperties", "Lme/mochibit/defcon/particles/templates/GenericParticleProperties;", "position", "Lorg/joml/Vector3d;", "velocity", "Lorg/joml/Vector3f;", "damping", "acceleration", "<init>", "(Lme/mochibit/defcon/particles/templates/GenericParticleProperties;Lorg/joml/Vector3d;Lorg/joml/Vector3f;Lorg/joml/Vector3f;Lorg/joml/Vector3f;)V", "getPosition", "()Lorg/joml/Vector3d;", "life", "", "particleID", "getParticleID", "()I", "particleUUID", "Ljava/util/UUID;", "getParticleUUID", "()Ljava/util/UUID;", "summoned", "", "removed", "isMoving", "()Z", "dampingFactor", "applyForce", "", "force", "setDamping", "setAcceleration", "addVelocity", "setVelocity", "update", "delta", "", "isDead", "isRemoved", "show", "player", "Lorg/bukkit/entity/Player;", "hide", "updatePosition", "Companion", "Defcon"})
public abstract class ParticleInstance {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GenericParticleProperties particleProperties;
    @NotNull
    private final Vector3d position;
    @NotNull
    private Vector3f velocity;
    @NotNull
    private Vector3f damping;
    @NotNull
    private Vector3f acceleration;
    private int life;
    private final int particleID;
    @NotNull
    private final UUID particleUUID;
    private boolean summoned;
    private boolean removed;
    @NotNull
    private final Vector3f dampingFactor;
    public static final int UPDATE_INTERVAL = 16;
    @NotNull
    private static final AtomicInteger ENTITY_ID_COUNTER = new AtomicInteger(ThreadLocalRandom.current().nextInt(10000, 0x1FFFFFFF));

    public ParticleInstance(@NotNull GenericParticleProperties particleProperties, @NotNull Vector3d position, @NotNull Vector3f velocity, @NotNull Vector3f damping, @NotNull Vector3f acceleration) {
        Intrinsics.checkNotNullParameter(particleProperties, "particleProperties");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(velocity, "velocity");
        Intrinsics.checkNotNullParameter(damping, "damping");
        Intrinsics.checkNotNullParameter(acceleration, "acceleration");
        this.particleProperties = particleProperties;
        this.position = position;
        this.velocity = velocity;
        this.damping = damping;
        this.acceleration = acceleration;
        this.particleID = ENTITY_ID_COUNTER.getAndIncrement();
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue(uUID, "randomUUID(...)");
        this.particleUUID = uUID;
        this.dampingFactor = new Vector3f();
    }

    public /* synthetic */ ParticleInstance(GenericParticleProperties genericParticleProperties, Vector3d vector3d, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
        }
        if ((n & 8) != 0) {
            vector3f2 = new Vector3f(0.0f, 0.0f, 0.0f);
        }
        if ((n & 0x10) != 0) {
            vector3f3 = new Vector3f(0.0f, 0.0f, 0.0f);
        }
        this(genericParticleProperties, vector3d, vector3f, vector3f2, vector3f3);
    }

    @NotNull
    protected final Vector3d getPosition() {
        return this.position;
    }

    public final int getParticleID() {
        return this.particleID;
    }

    @NotNull
    protected final UUID getParticleUUID() {
        return this.particleUUID;
    }

    private final boolean isMoving() {
        return !(this.velocity.x == 0.0f) || !(this.velocity.y == 0.0f) || !(this.velocity.z == 0.0f) || !(this.acceleration.x == 0.0f) || !(this.acceleration.y == 0.0f) || !(this.acceleration.z == 0.0f);
    }

    public final void applyForce(@NotNull Vector3f force) {
        Intrinsics.checkNotNullParameter(force, "force");
        this.acceleration.add(force.x, force.y, force.z);
    }

    public final void setDamping(@NotNull Vector3f damping) {
        Intrinsics.checkNotNullParameter(damping, "damping");
        this.damping.set(damping.x, damping.y, damping.z);
    }

    public final void setAcceleration(@NotNull Vector3f acceleration) {
        Intrinsics.checkNotNullParameter(acceleration, "acceleration");
        this.acceleration.set(acceleration.x, acceleration.y, acceleration.z);
    }

    public final void addVelocity(@NotNull Vector3f velocity) {
        Intrinsics.checkNotNullParameter(velocity, "velocity");
        this.velocity.add(velocity.x, velocity.y, velocity.z);
    }

    public final void setVelocity(@NotNull Vector3f velocity) {
        Intrinsics.checkNotNullParameter(velocity, "velocity");
        this.velocity.set(velocity.x, velocity.y, velocity.z);
    }

    public final boolean update(double delta) {
        if (this.isDead() || this.removed) {
            return false;
        }
        if (!this.summoned) {
            this.summoned = true;
        }
        if (this.isMoving()) {
            if (!(this.acceleration.x == 0.0f && this.acceleration.y == 0.0f && this.acceleration.z == 0.0f)) {
                this.velocity.add((Vector3fc)this.acceleration);
            }
            if (!(this.damping.x == 0.0f && this.damping.y == 0.0f && this.damping.z == 0.0f)) {
                this.dampingFactor.set(!(this.velocity.x == 0.0f) ? Math.min(Math.abs(this.velocity.x), this.damping.x) * Math.signum(this.velocity.x) : 0.0f, !(this.velocity.y == 0.0f) ? Math.min(Math.abs(this.velocity.y), this.damping.y) * Math.signum(this.velocity.y) : 0.0f, !(this.velocity.z == 0.0f) ? Math.min(Math.abs(this.velocity.z), this.damping.z) * Math.signum(this.velocity.z) : 0.0f);
                this.velocity.sub((Vector3fc)this.dampingFactor);
            }
            this.position.add((double)this.velocity.x * delta, (double)this.velocity.y * delta, (double)this.velocity.z * delta);
        }
        boolean needsPositionUpdate = this.isMoving() && (this.life & 0xF) == 0;
        int n = this.life;
        this.life = n + 1;
        if (this.isDead()) {
            this.removed = true;
        }
        return needsPositionUpdate;
    }

    public final boolean isDead() {
        return (long)this.life >= this.particleProperties.getMaxLife();
    }

    public final boolean isRemoved() {
        return this.removed;
    }

    public abstract void show(@NotNull Player var1);

    public abstract void hide(@NotNull Player var1);

    public abstract void updatePosition(@NotNull Player var1);

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0003\u00a8\u0006\u0013"}, d2={"Lme/mochibit/defcon/particles/emitter/ParticleInstance$Companion;", "", "<init>", "()V", "UPDATE_INTERVAL", "", "ENTITY_ID_COUNTER", "Ljava/util/concurrent/atomic/AtomicInteger;", "getENTITY_ID_COUNTER$annotations", "fromTemplate", "Lme/mochibit/defcon/particles/emitter/ParticleInstance;", "particleTemplate", "Lme/mochibit/defcon/particles/templates/AbstractParticle;", "location", "Lorg/joml/Vector3f;", "adjustColor", "Lorg/bukkit/Color;", "color", "template", "Defcon"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getENTITY_ID_COUNTER$annotations() {
        }

        @NotNull
        public final ParticleInstance fromTemplate(@NotNull AbstractParticle particleTemplate, @NotNull Vector3f location) {
            Intrinsics.checkNotNullParameter(particleTemplate, "particleTemplate");
            Intrinsics.checkNotNullParameter(location, "location");
            Object object = particleTemplate.getParticleProperties().clone();
            GenericParticleProperties $this$fromTemplate_u24lambda_u240 = object;
            boolean bl = false;
            Color color = $this$fromTemplate_u24lambda_u240.getColor();
            if (color == null) {
                color = Color.RED;
            }
            Color color2 = color;
            Intrinsics.checkNotNull(color2);
            $this$fromTemplate_u24lambda_u240.setColor(Companion.adjustColor(color2, particleTemplate));
            GenericParticleProperties particleProperties = object;
            if (particleTemplate.getRandomizeScale()) {
                Vector3f scale = particleProperties.getScale();
                float scaleRandom = (float)ThreadLocalRandom.current().nextDouble(0.9, 1.3);
                Vector3f vector3f = scale.mul(scaleRandom, scale);
                Intrinsics.checkNotNullExpressionValue(vector3f, "mul(...)");
                particleProperties.setScale(vector3f);
            }
            Intrinsics.checkNotNull(particleProperties, "null cannot be cast to non-null type me.mochibit.defcon.particles.templates.TextDisplayParticleProperties");
            Object $this$fromTemplate_u24lambda_u241 = object = new TextDisplayParticleInstance((TextDisplayParticleProperties)particleProperties, new Vector3d((double)location.x, (double)location.y, (double)location.z), null, null, null, 28, null);
            boolean bl2 = false;
            ((ParticleInstance)$this$fromTemplate_u24lambda_u241).setVelocity(particleTemplate.getInitialVelocity());
            ((ParticleInstance)$this$fromTemplate_u24lambda_u241).setAcceleration(particleTemplate.getInitialAcceleration());
            ((ParticleInstance)$this$fromTemplate_u24lambda_u241).setDamping(particleTemplate.getInitialDamping());
            return (ParticleInstance)object;
        }

        private final Color adjustColor(Color color, AbstractParticle template) {
            Color color2 = template.getColorSupplier();
            if (color2 == null || (color2 = color2.invoke()) == null) {
                color2 = color;
            }
            Color baseColor = color2;
            return template.getRandomizeColorBrightness() ? ColorUtils.INSTANCE.randomizeColorBrightness(baseColor, template.getColorDarkenFactorMax(), template.getColorDarkenFactorMin(), template.getColorLightenFactorMax(), template.getColorLightenFactorMin()) : baseColor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

