/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.particles.mutators;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import me.mochibit.defcon.particles.mutators.AbstractShapeMutator;
import me.mochibit.defcon.utils.ChunkCache;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lme/mochibit/defcon/particles/mutators/FloorSnapper;", "Lme/mochibit/defcon/particles/mutators/AbstractShapeMutator;", "center", "Lorg/bukkit/Location;", "easeFromPoint", "Lorg/joml/Vector3f;", "peakHeight", "", "maxDistance", "<init>", "(Lorg/bukkit/Location;Lorg/joml/Vector3f;FF)V", "cachedMinY", "Ljava/util/concurrent/ConcurrentMap;", "Lkotlin/Pair;", "", "chunkCache", "Lme/mochibit/defcon/utils/ChunkCache;", "mutateLoc", "", "location", "Defcon"})
public final class FloorSnapper
extends AbstractShapeMutator {
    @NotNull
    private final Location center;
    @Nullable
    private final Vector3f easeFromPoint;
    private final float peakHeight;
    private final float maxDistance;
    @NotNull
    private final ConcurrentMap<Pair<Integer, Integer>, Float> cachedMinY;
    @NotNull
    private final ChunkCache chunkCache;

    public FloorSnapper(@NotNull Location center, @Nullable Vector3f easeFromPoint, float peakHeight, float maxDistance) {
        Intrinsics.checkNotNullParameter(center, "center");
        this.center = center;
        this.easeFromPoint = easeFromPoint;
        this.peakHeight = peakHeight;
        this.maxDistance = maxDistance;
        this.cachedMinY = new ConcurrentHashMap();
        World world = this.center.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        this.chunkCache = ChunkCache.Companion.getInstance$default(ChunkCache.Companion, world, 0, 2, null);
    }

    public /* synthetic */ FloorSnapper(Location location, Vector3f vector3f, float f, float f2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            vector3f = null;
        }
        if ((n & 4) != 0) {
            Vector3f vector3f2 = vector3f;
            float f3 = f = vector3f2 != null ? vector3f2.y() : 0.0f;
        }
        if ((n & 8) != 0) {
            f2 = 80.0f;
        }
        this(location, vector3f, f, f2);
    }

    @Override
    public void mutateLoc(@NotNull Vector3f location) {
        Intrinsics.checkNotNullParameter(location, "location");
        int x = (int)location.x();
        int z = (int)location.z();
        Float minY = this.cachedMinY.computeIfAbsent(TuplesKt.to(x, z), arg_0 -> FloorSnapper.mutateLoc$lambda$1(arg_0 -> FloorSnapper.mutateLoc$lambda$0(this, x, z, arg_0), arg_0));
        location.y = minY.floatValue() + (location.y - (float)this.center.getY());
    }

    private static final Float mutateLoc$lambda$0(FloorSnapper this$0, int $x, int $z, Pair it) {
        Float f;
        float baseY = this$0.chunkCache.highestBlockYAt($x, $z);
        if (this$0.easeFromPoint != null) {
            float dx = (float)$x - this$0.easeFromPoint.x();
            float dz = (float)$z - this$0.easeFromPoint.z();
            float distance = (float)Math.sqrt(dx * dx + dz * dz);
            float normalizedDistance = RangesKt.coerceIn(distance / this$0.maxDistance, 0.0f, 1.0f);
            float bellFactor = (float)Math.exp((float)-4 * (float)Math.pow(normalizedDistance, 2));
            f = Float.valueOf(baseY + bellFactor * this$0.peakHeight);
        } else {
            f = Float.valueOf(baseY);
        }
        return f;
    }

    private static final Float mutateLoc$lambda$1(Function1 $tmp0, Object p0) {
        return (Float)$tmp0.invoke(p0);
    }
}

