/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.registers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import me.mochibit.defcon.Defcon;
import me.mochibit.defcon.classes.CustomBlockDefinition;
import me.mochibit.defcon.classes.PluginConfiguration;
import me.mochibit.defcon.enums.BlockBehaviour;
import me.mochibit.defcon.enums.BlockDataKey;
import me.mochibit.defcon.enums.ConfigurationStorage;
import me.mochibit.defcon.exceptions.BlockNotRegisteredException;
import me.mochibit.defcon.extensions.ByteKt;
import me.mochibit.defcon.interfaces.PluginBlock;
import me.mochibit.defcon.utils.MetaManager;
import me.mochibit.lib.customblockdata.CustomBlockData;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3i;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lme/mochibit/defcon/registers/BlockRegister;", "", "<init>", "()V", "pluginInstance", "Lorg/bukkit/plugin/java/JavaPlugin;", "registerBlocks", "", "Companion", "Defcon"})
@SourceDebugExtension(value={"SMAP\nBlockRegister.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockRegister.kt\nme/mochibit/defcon/registers/BlockRegister\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1869#2,2:106\n*S KotlinDebug\n*F\n+ 1 BlockRegister.kt\nme/mochibit/defcon/registers/BlockRegister\n*L\n52#1:106,2\n*E\n"})
public final class BlockRegister {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JavaPlugin pluginInstance;
    @Nullable
    private static HashMap<String, PluginBlock> registeredBlocks;

    public BlockRegister() {
        JavaPlugin javaPlugin = JavaPlugin.getPlugin(Defcon.class);
        Intrinsics.checkNotNullExpressionValue(javaPlugin, "getPlugin(...)");
        this.pluginInstance = javaPlugin;
    }

    public final void registerBlocks() {
        registeredBlocks = new HashMap();
        FileConfiguration blockConfig = PluginConfiguration.Companion.get(ConfigurationStorage.Blocks).getConfig();
        List list = blockConfig.getList("enabled-blocks");
        Intrinsics.checkNotNull(list);
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            BlockBehaviour behaviourValue;
            String blockMinecraftId;
            Object element$iv;
            Object item = element$iv = iterator2.next();
            boolean bl = false;
            String blockId = String.valueOf(item);
            HashMap<String, PluginBlock> hashMap = registeredBlocks;
            Intrinsics.checkNotNull(hashMap);
            if (hashMap.get(blockId) != null) continue;
            if (blockConfig.getString(item + ".block-minecraft-id") == null) {
                throw new BlockNotRegisteredException(blockId);
            }
            int blockDataModelId = blockConfig.getInt(item + ".block-data-model-id");
            String behaviourName = blockConfig.getString(item + ".behaviour");
            if (behaviourName == null) {
                behaviourName = "generic";
            }
            if (BlockBehaviour.Companion.fromString(behaviourName) == null) {
                throw new BlockNotRegisteredException(blockId);
            }
            PluginBlock customBlock = new CustomBlockDefinition(blockId, blockDataModelId, blockMinecraftId, behaviourValue);
            HashMap<String, PluginBlock> hashMap2 = registeredBlocks;
            Intrinsics.checkNotNull(hashMap2);
            ((Map)hashMap2).put(customBlock.getId(), customBlock);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0006J.\u0010\u0011\u001a*\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u0001`\bR6\u0010\u0004\u001a*\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u0001`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lme/mochibit/defcon/registers/BlockRegister$Companion;", "", "<init>", "()V", "registeredBlocks", "Ljava/util/HashMap;", "", "Lme/mochibit/defcon/interfaces/PluginBlock;", "Lkotlin/collections/HashMap;", "getBlock", "location", "Lorg/bukkit/Location;", "loc", "Lorg/joml/Vector3i;", "world", "Lorg/bukkit/World;", "id", "getRegisteredBlocks", "Defcon"})
    @SourceDebugExtension(value={"SMAP\nBlockRegister.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockRegister.kt\nme/mochibit/defcon/registers/BlockRegister$Companion\n+ 2 MetaManager.kt\nme/mochibit/defcon/utils/MetaManager\n*L\n1#1,105:1\n38#2,13:106\n*S KotlinDebug\n*F\n+ 1 BlockRegister.kt\nme/mochibit/defcon/registers/BlockRegister$Companion\n*L\n82#1:106,13\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final PluginBlock getBlock(@NotNull Location location) {
            String string;
            void this_$iv;
            Intrinsics.checkNotNullParameter(location, "location");
            MetaManager metaManager = MetaManager.INSTANCE;
            BlockDataKey key$iv = BlockDataKey.CustomBlockId;
            boolean $i$f$getBlockData = false;
            Block block = location.getWorld().getBlockAt(location);
            Intrinsics.checkNotNullExpressionValue(block, "getBlockAt(...)");
            Block block$iv = block;
            PersistentDataContainer blockData$iv = new CustomBlockData(block$iv, (Plugin)Defcon.Companion.getInstance());
            PersistentDataType<?, ?> dataType$iv = this_$iv.getPersistentDataType(Reflection.getOrCreateKotlinClass(String.class));
            Object object = blockData$iv.get(key$iv.getKey(), dataType$iv);
            if (object == null) {
                string = null;
            } else {
                Object object2 = object;
                Intrinsics.checkNotNull(object2);
                Object value$iv = object2;
                string = String.class == Boolean.class ? (String)((Object)Boolean.valueOf(ByteKt.toBoolean((Byte)value$iv))) : (String)value$iv;
            }
            if (string == null) {
                return null;
            }
            String customBlockId = string;
            return this.getBlock(customBlockId);
        }

        @Nullable
        public final PluginBlock getBlock(@NotNull Vector3i loc, @NotNull World world) {
            Intrinsics.checkNotNullParameter(loc, "loc");
            Intrinsics.checkNotNullParameter(world, "world");
            Location location = new Location(world, (double)loc.x, (double)loc.y, (double)loc.z);
            return this.getBlock(location);
        }

        @Nullable
        public final PluginBlock getBlock(@NotNull String id) {
            Intrinsics.checkNotNullParameter(id, "id");
            HashMap hashMap = registeredBlocks;
            Intrinsics.checkNotNull(hashMap);
            return (PluginBlock)hashMap.get(id);
        }

        @Nullable
        public final HashMap<String, PluginBlock> getRegisteredBlocks() throws BlockNotRegisteredException {
            if (registeredBlocks == null) {
                throw new BlockNotRegisteredException("Block not registered for some reason. Verify the initialization");
            }
            return registeredBlocks;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

