/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.registers;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import me.mochibit.defcon.Defcon;
import me.mochibit.defcon.biomes.BiomeRegister;
import me.mochibit.defcon.biomes.CustomBiome;
import me.mochibit.defcon.biomes.data.BiomeAdditionsSound;
import me.mochibit.defcon.biomes.data.BiomeEffects;
import me.mochibit.defcon.biomes.data.BiomeMoodSound;
import me.mochibit.defcon.biomes.data.BiomeMusic;
import me.mochibit.defcon.biomes.data.BiomeParticle;
import me.mochibit.defcon.notification.NotificationManager;
import me.mochibit.defcon.notification.NotificationType;
import me.mochibit.defcon.registers.PackRegister;
import me.mochibit.defcon.registers.packformat.FormatReader;
import me.mochibit.defcon.utils.VersionCheckerKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\t\u0010\u0007R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lme/mochibit/defcon/registers/DatapackRegister;", "Lme/mochibit/defcon/registers/PackRegister;", "<init>", "()V", "tempPath", "Ljava/nio/file/Path;", "getTempPath", "()Ljava/nio/file/Path;", "tempBiomesPath", "getTempBiomesPath", "tempBiomesPath$delegate", "Lkotlin/Lazy;", "messageForServerRestart", "Lnet/kyori/adventure/text/TextComponent;", "Lorg/jetbrains/annotations/NotNull;", "defaultWorldName", "", "datapackFolder", "destinationPath", "getDestinationPath", "write", "", "onMove", "writeBiomes", "createBiomeJson", "Lorg/json/simple/JSONObject;", "biome", "Lme/mochibit/defcon/biomes/CustomBiome;", "createBiomeEffectsJson", "effects", "Lme/mochibit/defcon/biomes/data/BiomeEffects;", "Defcon"})
@SourceDebugExtension(value={"SMAP\nDatapackRegister.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatapackRegister.kt\nme/mochibit/defcon/registers/DatapackRegister\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n1#2:191\n*E\n"})
public final class DatapackRegister
extends PackRegister {
    @NotNull
    public static final DatapackRegister INSTANCE = new DatapackRegister();
    @NotNull
    private static final Path tempPath;
    @NotNull
    private static final Lazy tempBiomesPath$delegate;
    @NotNull
    private static final TextComponent messageForServerRestart;
    @NotNull
    private static final String defaultWorldName;
    @NotNull
    private static final Path datapackFolder;
    @Nullable
    private static final Path destinationPath;

    private DatapackRegister() {
        super(false, 1, null);
    }

    @Override
    @NotNull
    public Path getTempPath() {
        return tempPath;
    }

    private final Path getTempBiomesPath() {
        Lazy lazy = tempBiomesPath$delegate;
        Object t = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue(t, "getValue(...)");
        return (Path)t;
    }

    @Override
    @Nullable
    public Path getDestinationPath() {
        return destinationPath;
    }

    @Override
    protected void write() {
        Defcon.Logger.INSTANCE.info("Registering Datapack");
        if (!Files.exists(datapackFolder, new LinkOption[0])) {
            throw new Exception("Datapack folder not found at " + datapackFolder);
        }
        String mcmetaContent = this.createMcmetaJson(FormatReader.INSTANCE.getPackFormat().getDataVersion(), "Defcon datapack");
        Path path = Paths.get(this.getTempPath() + "/pack.mcmeta", new String[0]);
        String string = mcmetaContent;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        Files.write(path, byArray, new OpenOption[0]);
        this.writeBiomes();
    }

    @Override
    public void onMove() {
        NotificationManager.addNotification$default(NotificationManager.INSTANCE, messageForServerRestart, NotificationType.WARNING, false, 4, null);
    }

    private final void writeBiomes() {
        try {
            List<CustomBiome> biomes = new BiomeRegister().getBiomes();
            for (CustomBiome biome : biomes) {
                String string;
                Path biomePath = Paths.get(this.getTempBiomesPath() + "/" + biome.getKey().value() + ".json", new String[0]);
                JSONObject biomeJson = this.createBiomeJson(biome);
                Intrinsics.checkNotNullExpressionValue(biomeJson.toJSONString(), "toJSONString(...)");
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
                Files.write(biomePath, byArray, new OpenOption[0]);
            }
        }
        catch (Exception e) {
            Defcon.Logger.INSTANCE.info("Error writing biomes: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private final JSONObject createBiomeJson(CustomBiome biome) {
        JSONObject jSONObject;
        JSONObject $this$createBiomeJson_u24lambda_u241 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$createBiomeJson_u24lambda_u241.put((Object)"temperature", (Object)Float.valueOf(biome.getTemperature()));
        $this$createBiomeJson_u24lambda_u241.put((Object)"downfall", (Object)Float.valueOf(biome.getDownfall()));
        String string = biome.getPrecipitation().name();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        $this$createBiomeJson_u24lambda_u241.put((Object)"precipitation", (Object)string2);
        string = biome.getTemperatureModifier().name();
        Locale locale2 = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale2, "getDefault(...)");
        String string3 = string.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
        $this$createBiomeJson_u24lambda_u241.put((Object)"temperature_modifier", (Object)string3);
        $this$createBiomeJson_u24lambda_u241.put((Object)"has_precipitation", (Object)biome.getHasPrecipitation());
        $this$createBiomeJson_u24lambda_u241.put((Object)"effects", (Object)INSTANCE.createBiomeEffectsJson(biome.getEffects()));
        $this$createBiomeJson_u24lambda_u241.put((Object)"spawners", (Object)new JSONObject());
        $this$createBiomeJson_u24lambda_u241.put((Object)"spawn_costs", (Object)new JSONObject());
        $this$createBiomeJson_u24lambda_u241.put((Object)"carvers", VersionCheckerKt.versionGreaterOrEqualThan("1.21.2") ? new JSONArray() : new JSONObject());
        $this$createBiomeJson_u24lambda_u241.put((Object)"features", (Object)new JSONArray());
        return jSONObject;
    }

    /*
     * WARNING - void declaration
     */
    private final JSONObject createBiomeEffectsJson(BiomeEffects effects) {
        JSONObject jSONObject;
        block9: {
            void $this$createBiomeEffectsJson_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415;
            JSONObject $this$createBiomeEffectsJson_u24lambda_u2417_u24lambda_u2414_u24lambda_u2413;
            JSONObject $this$createBiomeEffectsJson_u24lambda_u2417_u24lambda_u245_u24lambda_u244;
            Unit unit;
            JSONObject $this$createBiomeEffectsJson_u24lambda_u2417_u24lambda_u243_u24lambda_u242;
            JSONObject jSONObject2;
            String string;
            JSONObject jSONObject3;
            JSONObject $this$createBiomeEffectsJson_u24lambda_u2417 = jSONObject = new JSONObject();
            boolean bl = false;
            $this$createBiomeEffectsJson_u24lambda_u2417.put((Object)"sky_color", (Object)effects.getSkyColor());
            $this$createBiomeEffectsJson_u24lambda_u2417.put((Object)"fog_color", (Object)effects.getFogColor());
            $this$createBiomeEffectsJson_u24lambda_u2417.put((Object)"water_color", (Object)effects.getWaterColor());
            $this$createBiomeEffectsJson_u24lambda_u2417.put((Object)"water_fog_color", (Object)effects.getWaterFogColor());
            BiomeMoodSound biomeMoodSound = effects.getMoodSound();
            if (biomeMoodSound != null) {
                BiomeMoodSound mood = biomeMoodSound;
                boolean bl2 = false;
                JSONObject jSONObject4 = jSONObject3 = new JSONObject();
                string = "mood_sound";
                jSONObject2 = $this$createBiomeEffectsJson_u24lambda_u2417;
                boolean bl3 = false;
                $this$createBiomeEffectsJson_u24lambda_u2417_u24lambda_u243_u24lambda_u242.put((Object)"sound", (Object)mood.getSound());
                $this$createBiomeEffectsJson_u24lambda_u2417_u24lambda_u243_u24lambda_u242.put((Object)"tick_delay", (Object)mood.getTickDelay());
                $this$createBiomeEffectsJson_u24lambda_u2417_u24lambda_u243_u24lambda_u242.put((Object)"block_search_extent", (Object)mood.getBlockSearchExtent());
                $this$createBiomeEffectsJson_u24lambda_u2417_u24lambda_u243_u24lambda_u242.put((Object)"offset", (Object)Float.valueOf(mood.getOffset()));
                unit = Unit.INSTANCE;
                jSONObject2.put((Object)string, (Object)jSONObject3);
            }
            BiomeAdditionsSound biomeAdditionsSound = effects.getAdditionsSound();
            if (biomeAdditionsSound != null) {
                BiomeAdditionsSound additionalSound = biomeAdditionsSound;
                boolean bl4 = false;
                $this$createBiomeEffectsJson_u24lambda_u2417_u24lambda_u243_u24lambda_u242 = jSONObject3 = new JSONObject();
                string = "additions_sound";
                jSONObject2 = $this$createBiomeEffectsJson_u24lambda_u2417;
                boolean bl5 = false;
                $this$createBiomeEffectsJson_u24lambda_u2417_u24lambda_u245_u24lambda_u244.put((Object)"sound", (Object)additionalSound.getSound());
                $this$createBiomeEffectsJson_u24lambda_u2417_u24lambda_u245_u24lambda_u244.put((Object)"tick_chance", (Object)additionalSound.getTickChance());
                unit = Unit.INSTANCE;
                jSONObject2.put((Object)string, (Object)jSONObject3);
            }
            String string2 = effects.getAmbientSound();
            if (string2 != null) {
                String ambientSound = string2;
                boolean bl6 = false;
                $this$createBiomeEffectsJson_u24lambda_u2417.put((Object)"ambient_sound", (Object)ambientSound);
            }
            BiomeParticle biomeParticle = effects.getParticle();
            if (biomeParticle != null) {
                void $this$createBiomeEffectsJson_u24lambda_u2417_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412;
                BiomeParticle particle = biomeParticle;
                boolean bl7 = false;
                $this$createBiomeEffectsJson_u24lambda_u2417_u24lambda_u245_u24lambda_u244 = jSONObject3 = new JSONObject();
                string = "particle";
                jSONObject2 = $this$createBiomeEffectsJson_u24lambda_u2417;
                boolean bl8 = false;
                $this$createBiomeEffectsJson_u24lambda_u2417_u24lambda_u2414_u24lambda_u2413.put((Object)"probability", (Object)Float.valueOf(particle.getProbability()));
                Unit unit2 = unit = new JSONObject();
                String string3 = "options";
                JSONObject jSONObject5 = $this$createBiomeEffectsJson_u24lambda_u2417_u24lambda_u2414_u24lambda_u2413;
                boolean bl9 = false;
                String string4 = particle.getParticle().name();
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
                String string5 = string4.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue(string5, "toLowerCase(...)");
                $this$createBiomeEffectsJson_u24lambda_u2417_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412.put((Object)"type", (Object)("minecraft:" + string5));
                Integer n = particle.getColor();
                if (n != null) {
                    int it = ((Number)n).intValue();
                    boolean bl10 = false;
                    $this$createBiomeEffectsJson_u24lambda_u2417_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412.put((Object)"color", (Object)it);
                }
                Float f = particle.getSize();
                if (f != null) {
                    float it = ((Number)f).floatValue();
                    boolean bl11 = false;
                    $this$createBiomeEffectsJson_u24lambda_u2417_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412.put((Object)"size", (Object)Float.valueOf(it));
                }
                Material material = particle.getMaterial();
                if (material != null) {
                    Material it = material;
                    boolean bl12 = false;
                    String string6 = it.name();
                    Locale locale2 = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue(locale2, "getDefault(...)");
                    String string7 = string6.toLowerCase(locale2);
                    Intrinsics.checkNotNullExpressionValue(string7, "toLowerCase(...)");
                    $this$createBiomeEffectsJson_u24lambda_u2417_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412.put((Object)"material", (Object)("minecraft:" + string7));
                }
                Integer n2 = particle.getFromColor();
                if (n2 != null) {
                    int it = ((Number)n2).intValue();
                    boolean bl13 = false;
                    $this$createBiomeEffectsJson_u24lambda_u2417_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412.put((Object)"from_color", (Object)it);
                }
                Integer n3 = particle.getToColor();
                if (n3 != null) {
                    int it = ((Number)n3).intValue();
                    boolean bl14 = false;
                    $this$createBiomeEffectsJson_u24lambda_u2417_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412.put((Object)"to_color", (Object)it);
                }
                Unit unit3 = Unit.INSTANCE;
                jSONObject5.put((Object)string3, (Object)unit);
                Unit unit4 = Unit.INSTANCE;
                jSONObject2.put((Object)string, (Object)jSONObject3);
            }
            BiomeMusic biomeMusic = effects.getMusic();
            if (biomeMusic == null) break block9;
            BiomeMusic music = biomeMusic;
            boolean bl15 = false;
            $this$createBiomeEffectsJson_u24lambda_u2417_u24lambda_u2414_u24lambda_u2413 = jSONObject3 = new JSONObject();
            string = "music";
            jSONObject2 = $this$createBiomeEffectsJson_u24lambda_u2417;
            boolean bl16 = false;
            $this$createBiomeEffectsJson_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415.put((Object)"sound", (Object)music.getSound());
            $this$createBiomeEffectsJson_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415.put((Object)"min_delay", (Object)music.getMinDelay());
            $this$createBiomeEffectsJson_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415.put((Object)"max_delay", (Object)music.getMaxDelay());
            $this$createBiomeEffectsJson_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415.put((Object)"replace_current_music", (Object)music.getReplaceCurrentMusic());
            unit = Unit.INSTANCE;
            jSONObject2.put((Object)string, (Object)jSONObject3);
        }
        return jSONObject;
    }

    private static final Path tempBiomesPath_delegate$lambda$0() {
        Path path = Paths.get(INSTANCE.getTempPath() + "/data/defcon/worldgen/biome", new String[0]);
        Files.createDirectories(path, new FileAttribute[0]);
        return path;
    }

    static {
        Path path = Paths.get("./defcon_temp_datapack", new String[0]);
        Intrinsics.checkNotNullExpressionValue(path, "get(...)");
        tempPath = path;
        tempBiomesPath$delegate = LazyKt.lazy(DatapackRegister::tempBiomesPath_delegate$lambda$0);
        Component component = ((TextComponent)((TextComponent)Component.text("The server must be restarted to use Defcon's datapack.").color(TextColor.color(16475913))).decoration(TextDecoration.BOLD, true)).decoration(TextDecoration.ITALIC, false);
        Intrinsics.checkNotNullExpressionValue(component, "decoration(...)");
        messageForServerRestart = (TextComponent)component;
        String string = ((World)Bukkit.getWorlds().get(0)).getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        defaultWorldName = string;
        String[] stringArray = new String[]{"datapacks"};
        Path path2 = Paths.get(defaultWorldName, stringArray);
        Intrinsics.checkNotNullExpressionValue(path2, "get(...)");
        datapackFolder = path2;
        String[] stringArray2 = new String[]{"defcon"};
        destinationPath = Paths.get(((Object)datapackFolder).toString(), stringArray2);
    }
}

