/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.server;

import io.ktor.http.ContentDisposition;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpStatusCode;
import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.engine.EmbeddedServer;
import io.ktor.server.engine.EmbeddedServerKt;
import io.ktor.server.netty.Netty;
import io.ktor.server.netty.NettyApplicationEngine;
import io.ktor.server.response.ApplicationResponse;
import io.ktor.server.response.ApplicationResponseFunctionsJvmKt;
import io.ktor.server.response.ApplicationResponsePropertiesKt;
import io.ktor.server.routing.Routing;
import io.ktor.server.routing.RoutingBuilderKt;
import io.ktor.server.routing.RoutingContext;
import io.ktor.server.routing.RoutingRootKt;
import io.ktor.util.reflect.TypeInfo;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import me.mochibit.defcon.Defcon;
import me.mochibit.defcon.classes.PluginConfiguration;
import me.mochibit.defcon.enums.ConfigurationStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005J\u0006\u0010\u0011\u001a\u00020\u000fJ\u0006\u0010\u0012\u001a\u00020\u000fR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lme/mochibit/defcon/server/ResourcePackServer;", "", "<init>", "()V", "resourcePackPath", "Ljava/nio/file/Path;", "server", "Lio/ktor/server/engine/EmbeddedServer;", "Lio/ktor/server/netty/NettyApplicationEngine;", "Lio/ktor/server/netty/NettyApplicationEngine$Configuration;", "port", "", "getPort", "()I", "updatePackPath", "", "path", "startServer", "stopServer", "Defcon"})
public final class ResourcePackServer {
    @NotNull
    public static final ResourcePackServer INSTANCE = new ResourcePackServer();
    @Nullable
    private static Path resourcePackPath;
    @Nullable
    private static EmbeddedServer<NettyApplicationEngine, NettyApplicationEngine.Configuration> server;

    private ResourcePackServer() {
    }

    public final int getPort() {
        int n;
        try {
            n = PluginConfiguration.Companion.get(ConfigurationStorage.Config).getConfig().getInt("resource_pack_server_port");
        }
        catch (Exception e) {
            Defcon.Logger.INSTANCE.err("Failed to get resource pack server port from config, using default port 8080");
            n = 8080;
        }
        return n;
    }

    public final void updatePackPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "path");
        resourcePackPath = path;
    }

    public final void startServer() {
        if (server != null) {
            Defcon.Logger.INSTANCE.warn("Server is already running");
            return;
        }
        EmbeddedServer embeddedServer2 = EmbeddedServerKt.embeddedServer$default(Netty.INSTANCE, this.getPort(), null, null, ResourcePackServer::startServer$lambda$1, 12, null);
        server = embeddedServer2.start(false);
        Runtime.getRuntime().addShutdownHook(new Thread(ResourcePackServer::startServer$lambda$2));
        Defcon.Logger.INSTANCE.info("Resource pack server started on port " + this.getPort());
    }

    public final void stopServer() {
        EmbeddedServer<NettyApplicationEngine, NettyApplicationEngine.Configuration> embeddedServer2 = server;
        if (embeddedServer2 != null) {
            embeddedServer2.stop(1000L, 2000L);
        }
        server = null;
    }

    private static final Unit startServer$lambda$1$lambda$0(Routing $this$routing) {
        Intrinsics.checkNotNullParameter($this$routing, "$this$routing");
        RoutingBuilderKt.get($this$routing, "/resourcepack.zip", (Function2<? super RoutingContext, ? super Continuation<? super Unit>, ? extends Object>)new Function2<RoutingContext, Continuation<? super Unit>, Object>(null){
            int label;
            private /* synthetic */ Object L$0;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                void $result;
                Path path;
                RoutingContext $this$get;
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        KType kType;
                        void status$iv;
                        void $this$respond$iv;
                        ResultKt.throwOnFailure(object);
                        $this$get = (RoutingContext)this.L$0;
                        path = ResourcePackServer.access$getResourcePackPath$p();
                        if (path != null && Files.exists(path, new LinkOption[0])) break;
                        ApplicationCall applicationCall = $this$get.getCall();
                        HttpStatusCode httpStatusCode = HttpStatusCode.Companion.getNotFound();
                        String message$iv = "No resource pack set";
                        boolean $i$f$respondWithType = false;
                        $this$respond$iv.getResponse().status((HttpStatusCode)status$iv);
                        void $this$respond$iv$iv = $this$respond$iv;
                        boolean $i$f$respond = false;
                        String string = message$iv;
                        void var11_15 = $this$respond$iv$iv;
                        boolean $i$f$typeInfo = false;
                        KClass kClass = Reflection.getOrCreateKotlinClass(String.class);
                        boolean $i$f$typeOfOrNull = false;
                        try {
                            kType = Reflection.typeOf(String.class);
                        }
                        catch (Throwable throwable) {
                            kType = null;
                        }
                        KType kType2 = kType;
                        KClass kClass2 = kClass;
                        TypeInfo typeInfo = new TypeInfo(kClass2, kType2);
                        this.label = 1;
                        Object object3 = var11_15.respond(string, typeInfo, this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        boolean $i$f$respondWithType = false;
                        boolean $i$f$respond = false;
                        ResultKt.throwOnFailure($result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                ApplicationResponsePropertiesKt.header((ApplicationResponse)$this$get.getCall().getResponse(), HttpHeaders.INSTANCE.getContentDisposition(), ContentDisposition.withParameter$default(ContentDisposition.Companion.getAttachment(), "filename", "resourcepack.zip", false, 4, null).toString());
                ApplicationCall applicationCall = $this$get.getCall();
                File file = path.toFile();
                Intrinsics.checkNotNullExpressionValue(file, "toFile(...)");
                this.label = 2;
                Object object4 = ApplicationResponseFunctionsJvmKt.respondFile$default(applicationCall, file, null, this, 2, null);
                if (object4 != object2) return Unit.INSTANCE;
                return object2;
                {
                    case 2: {
                        ResultKt.throwOnFailure($result);
                        object4 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return var3_3;
            }

            public final Object invoke(RoutingContext p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit startServer$lambda$1(Application $this$embeddedServer) {
        Intrinsics.checkNotNullParameter($this$embeddedServer, "$this$embeddedServer");
        RoutingRootKt.routing($this$embeddedServer, ResourcePackServer::startServer$lambda$1$lambda$0);
        return Unit.INSTANCE;
    }

    private static final void startServer$lambda$2() {
        INSTANCE.stopServer();
    }

    public static final /* synthetic */ Path access$getResourcePackPath$p() {
        return resourcePackPath;
    }
}

