/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.defcon.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import me.mochibit.defcon.registers.BlockRegister;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3i;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001#B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJf\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00072\b\b\u0002\u0010\u0014\u001a\u00020\u00072\b\b\u0002\u0010\u0015\u001a\u00020\u00072\u0016\b\u0002\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0017J0\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00072\b\b\u0002\u0010\u0014\u001a\u00020\u0007J8\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00072\b\b\u0002\u0010\u0014\u001a\u00020\u0007H\u0086@\u00a2\u0006\u0002\u0010\u001dJN\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0017H\u0002J\u0018\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lme/mochibit/defcon/utils/FloodFill3D;", "", "<init>", "()V", "customBlockCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/joml/Vector3i;", "", "clearCustomBlockCache", "", "getFloodFillAdvanced", "Ljava/util/EnumMap;", "Lorg/bukkit/Material;", "", "startPos", "world", "Lorg/bukkit/World;", "maxRange", "", "nonSolidOnly", "customBlockOnly", "ignoreEmpty", "blockFilter", "Lkotlin/Function1;", "getFloodFill", "", "Lorg/bukkit/Location;", "startLoc", "getFloodFillAsync", "(Lorg/bukkit/Location;IZZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isValidBlock", "blockType", "blockLocation", "isCustomBlock", "pos", "Direction", "Defcon"})
@SourceDebugExtension(value={"SMAP\nFloodFill3D.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FloodFill3D.kt\nme/mochibit/defcon/utils/FloodFill3D\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,173:1\n384#2,7:174\n1563#3:181\n1634#3,3:182\n*S KotlinDebug\n*F\n+ 1 FloodFill3D.kt\nme/mochibit/defcon/utils/FloodFill3D\n*L\n72#1:174,7\n131#1:181\n131#1:182,3\n*E\n"})
public final class FloodFill3D {
    @NotNull
    public static final FloodFill3D INSTANCE = new FloodFill3D();
    @NotNull
    private static final ConcurrentHashMap<Vector3i, Boolean> customBlockCache = new ConcurrentHashMap();

    private FloodFill3D() {
    }

    public final void clearCustomBlockCache() {
        customBlockCache.clear();
    }

    @NotNull
    public final EnumMap<Material, Set<Vector3i>> getFloodFillAdvanced(@NotNull Vector3i startPos, @NotNull World world, int maxRange, boolean nonSolidOnly, boolean customBlockOnly, boolean ignoreEmpty, @Nullable Function1<? super Vector3i, Boolean> blockFilter) {
        Intrinsics.checkNotNullParameter(startPos, "startPos");
        Intrinsics.checkNotNullParameter(world, "world");
        EnumMap<Material, Set<Vector3i>> result = new EnumMap<Material, Set<Vector3i>>(Material.class);
        LinkedList<Vector3i> queue = new LinkedList<Vector3i>();
        HashSet<Vector3i> visited = new HashSet<Vector3i>();
        queue.add(startPos);
        while (!((Collection)queue).isEmpty() && visited.size() < maxRange) {
            Object object;
            Material type;
            Vector3i currentPos = (Vector3i)queue.poll();
            if (visited.contains(currentPos)) continue;
            visited.add(currentPos);
            Intrinsics.checkNotNullExpressionValue(world.getType(currentPos.x, currentPos.y, currentPos.z), "getType(...)");
            Intrinsics.checkNotNull(currentPos);
            if (!this.isValidBlock(type, currentPos, world, nonSolidOnly, customBlockOnly, ignoreEmpty, blockFilter)) continue;
            Map $this$getOrPut$iv = result;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(type);
            if (value$iv == null) {
                boolean bl = false;
                Set answer$iv = new HashSet();
                $this$getOrPut$iv.put(type, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Set)object).add(currentPos);
            for (Direction direction : Direction.getEntries()) {
                int nz;
                int ny;
                Triple<Integer, Integer, Integer> triple = direction.getRelative(currentPos.x, currentPos.y, currentPos.z);
                int nx = ((Number)triple.component1()).intValue();
                Vector3i nextPos = new Vector3i(nx, ny = ((Number)triple.component2()).intValue(), nz = ((Number)triple.component3()).intValue());
                if (visited.contains(nextPos)) continue;
                queue.add(nextPos);
            }
        }
        return result;
    }

    public static /* synthetic */ EnumMap getFloodFillAdvanced$default(FloodFill3D floodFill3D, Vector3i vector3i, World world, int n, boolean bl, boolean bl2, boolean bl3, Function1 function1, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        if ((n2 & 0x10) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x20) != 0) {
            bl3 = false;
        }
        if ((n2 & 0x40) != 0) {
            function1 = null;
        }
        return floodFill3D.getFloodFillAdvanced(vector3i, world, n, bl, bl2, bl3, function1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Location> getFloodFill(@NotNull Location startLoc, int maxRange, boolean nonSolidOnly, boolean customBlockOnly) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(startLoc, "startLoc");
        World world = startLoc.getWorld();
        if (world == null) {
            return CollectionsKt.emptyList();
        }
        World world2 = world;
        Vector3i startPos = new Vector3i((int)startLoc.getX(), (int)startLoc.getY(), (int)startLoc.getZ());
        HashSet<Vector3i> positions = new HashSet<Vector3i>();
        LinkedList<Vector3i> queue = new LinkedList<Vector3i>();
        queue.add(startPos);
        while (!((Collection)queue).isEmpty() && positions.size() < maxRange) {
            Material type;
            Vector3i currentPos = (Vector3i)queue.poll();
            if (positions.contains(currentPos)) continue;
            Intrinsics.checkNotNullExpressionValue(world2.getType(currentPos.x, currentPos.y, currentPos.z), "getType(...)");
            if (nonSolidOnly && type.isSolid()) continue;
            if (customBlockOnly) {
                Intrinsics.checkNotNull(currentPos);
                if (!this.isCustomBlock(currentPos, world2)) continue;
            }
            positions.add(currentPos);
            for (Direction direction : Direction.getEntries()) {
                int nz;
                int ny;
                Triple<Integer, Integer, Integer> triple = direction.getRelative(currentPos.x, currentPos.y, currentPos.z);
                int nx = ((Number)triple.component1()).intValue();
                Vector3i nextPos = new Vector3i(nx, ny = ((Number)triple.component2()).intValue(), nz = ((Number)triple.component3()).intValue());
                if (positions.contains(nextPos)) continue;
                queue.add(nextPos);
            }
        }
        Iterable $this$map$iv = positions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Vector3i nz = (Vector3i)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Location(world2, (double)it.x, (double)it.y, (double)it.z));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getFloodFill$default(FloodFill3D floodFill3D, Location location, int n, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        return floodFill3D.getFloodFill(location, n, bl, bl2);
    }

    @Nullable
    public final Object getFloodFillAsync(@NotNull Location startLoc, int maxRange, boolean nonSolidOnly, boolean customBlockOnly, @NotNull Continuation<? super List<? extends Location>> $completion) {
        return BuildersKt.withContext(Dispatchers.getIO(), (Function2)new Function2<CoroutineScope, Continuation<? super List<? extends Location>>, Object>(startLoc, maxRange, nonSolidOnly, customBlockOnly, null){
            int label;
            final /* synthetic */ Location $startLoc;
            final /* synthetic */ int $maxRange;
            final /* synthetic */ boolean $nonSolidOnly;
            final /* synthetic */ boolean $customBlockOnly;
            {
                this.$startLoc = $startLoc;
                this.$maxRange = $maxRange;
                this.$nonSolidOnly = $nonSolidOnly;
                this.$customBlockOnly = $customBlockOnly;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        return FloodFill3D.INSTANCE.getFloodFill(this.$startLoc, this.$maxRange, this.$nonSolidOnly, this.$customBlockOnly);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends Location>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    public static /* synthetic */ Object getFloodFillAsync$default(FloodFill3D floodFill3D, Location location, int n, boolean bl, boolean bl2, Continuation continuation2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        return floodFill3D.getFloodFillAsync(location, n, bl, bl2, continuation2);
    }

    private final boolean isValidBlock(Material blockType, Vector3i blockLocation, World world, boolean nonSolidOnly, boolean customBlockOnly, boolean ignoreEmpty, Function1<? super Vector3i, Boolean> blockFilter) {
        return !(nonSolidOnly && blockType.isSolid() || customBlockOnly && !this.isCustomBlock(blockLocation, world) || ignoreEmpty && blockType.isAir() || blockFilter != null && blockFilter.invoke((Vector3i)blockLocation) == false);
    }

    private final boolean isCustomBlock(Vector3i pos, World world) {
        Boolean bl = customBlockCache.computeIfAbsent(pos, arg_0 -> FloodFill3D.isCustomBlock$lambda$3(arg_0 -> FloodFill3D.isCustomBlock$lambda$2(pos, world, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue(bl, "computeIfAbsent(...)");
        return bl;
    }

    private static final Boolean isCustomBlock$lambda$2(Vector3i $pos, World $world, Vector3i it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return BlockRegister.Companion.getBlock($pos, $world) != null;
    }

    private static final Boolean isCustomBlock$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J0\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0014"}, d2={"Lme/mochibit/defcon/utils/FloodFill3D$Direction;", "", "x", "", "y", "z", "<init>", "(Ljava/lang/String;IIII)V", "getX", "()I", "getY", "getZ", "UP", "DOWN", "NORTH", "SOUTH", "EAST", "WEST", "getRelative", "Lkotlin/Triple;", "Defcon"})
    private static final class Direction
    extends Enum<Direction> {
        private final int x;
        private final int y;
        private final int z;
        public static final /* enum */ Direction UP = new Direction(0, 1, 0);
        public static final /* enum */ Direction DOWN = new Direction(0, -1, 0);
        public static final /* enum */ Direction NORTH = new Direction(0, 0, -1);
        public static final /* enum */ Direction SOUTH = new Direction(0, 0, 1);
        public static final /* enum */ Direction EAST = new Direction(1, 0, 0);
        public static final /* enum */ Direction WEST = new Direction(-1, 0, 0);
        private static final /* synthetic */ Direction[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Direction(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public final int getX() {
            return this.x;
        }

        public final int getY() {
            return this.y;
        }

        public final int getZ() {
            return this.z;
        }

        @NotNull
        public final Triple<Integer, Integer, Integer> getRelative(int x, int y, int z) {
            return new Triple<Integer, Integer, Integer>(x + this.x, y + this.y, z + this.z);
        }

        public static Direction[] values() {
            return (Direction[])$VALUES.clone();
        }

        public static Direction valueOf(String value) {
            return Enum.valueOf(Direction.class, value);
        }

        @NotNull
        public static EnumEntries<Direction> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = directionArray = new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

