/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.lib.packetevents.event;

import java.util.ArrayList;
import java.util.List;
import me.mochibit.lib.packetevents.event.PacketListenerCommon;
import me.mochibit.lib.packetevents.event.ProtocolPacketEvent;
import me.mochibit.lib.packetevents.exception.PacketProcessException;
import me.mochibit.lib.packetevents.manager.server.ServerVersion;
import me.mochibit.lib.packetevents.netty.buffer.ByteBufHelper;
import me.mochibit.lib.packetevents.protocol.PacketSide;
import me.mochibit.lib.packetevents.protocol.packettype.PacketTypeCommon;
import me.mochibit.lib.packetevents.protocol.player.User;

public class PacketSendEvent
extends ProtocolPacketEvent {
    private List<Runnable> tasksAfterSend = null;

    protected PacketSendEvent(Object channel, User user, Object player, Object rawByteBuf, boolean autoProtocolTranslation) throws PacketProcessException {
        super(PacketSide.SERVER, channel, user, player, rawByteBuf, autoProtocolTranslation);
    }

    protected PacketSendEvent(int packetID, PacketTypeCommon packetType, ServerVersion serverVersion, Object channel, User user, Object player, Object byteBuf) throws PacketProcessException {
        super(packetID, packetType, serverVersion, channel, user, player, byteBuf);
    }

    @Override
    public void call(PacketListenerCommon listener) {
        listener.onPacketSend(this);
    }

    public List<Runnable> getTasksAfterSend() {
        if (this.tasksAfterSend == null) {
            this.tasksAfterSend = new ArrayList<Runnable>();
        }
        return this.tasksAfterSend;
    }

    public boolean hasTasksAfterSend() {
        return this.tasksAfterSend != null && !this.tasksAfterSend.isEmpty();
    }

    @Override
    public PacketSendEvent clone() {
        try {
            Object clonedBuffer = ByteBufHelper.retainedDuplicate(this.getByteBuf());
            return new PacketSendEvent(this.getPacketId(), this.getPacketType(), this.getServerVersion(), this.getChannel(), this.getUser(), this.getPlayer(), clonedBuffer);
        }
        catch (PacketProcessException e) {
            e.printStackTrace();
            return null;
        }
    }
}

