/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.lib.packetevents.protocol.attribute;

import me.mochibit.lib.packetevents.PacketEvents;
import me.mochibit.lib.packetevents.protocol.mapper.MappedEntity;
import me.mochibit.lib.packetevents.protocol.player.ClientVersion;
import me.mochibit.lib.packetevents.resources.ResourceLocation;
import me.mochibit.lib.packetevents.util.MathUtil;

public interface Attribute
extends MappedEntity {
    @Override
    default public ResourceLocation getName() {
        return this.getName(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion());
    }

    public ResourceLocation getName(ClientVersion var1);

    default public double sanitizeValue(double value) {
        return this.sanitizeValue(value, PacketEvents.getAPI().getServerManager().getVersion().toClientVersion());
    }

    default public double sanitizeValue(double value, ClientVersion version) {
        if (!Double.isNaN(value)) {
            return MathUtil.clamp(value, this.getMinValue(), this.getMaxValue());
        }
        return this.getMinValue();
    }

    public double getDefaultValue();

    public double getMinValue();

    public double getMaxValue();
}

