/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.lib.packetevents.protocol.component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import me.mochibit.lib.packetevents.protocol.component.ComponentType;
import me.mochibit.lib.packetevents.protocol.component.ComponentValue;
import me.mochibit.lib.packetevents.protocol.component.IComponentMap;
import me.mochibit.lib.packetevents.protocol.component.PatchableComponentMap;
import me.mochibit.lib.packetevents.protocol.component.StaticComponentMap;
import me.mochibit.lib.packetevents.wrapper.PacketWrapper;

public class ComponentPredicate
implements Predicate<IComponentMap> {
    private List<ComponentValue<?>> requiredComponents;

    public ComponentPredicate(List<ComponentValue<?>> requiredComponents) {
        this.requiredComponents = requiredComponents;
    }

    public static ComponentPredicate read(PacketWrapper<?> wrapper) {
        List<ComponentValue<?>> components = wrapper.readList(ComponentValue::read);
        return new ComponentPredicate(components);
    }

    public static void write(PacketWrapper<?> wrapper, ComponentPredicate predicate) {
        wrapper.writeList(predicate.requiredComponents, ComponentValue::write);
    }

    public static ComponentPredicate emptyPredicate() {
        return new ComponentPredicate(new ArrayList());
    }

    public static ComponentPredicate fromPatches(PatchableComponentMap components) {
        Map<ComponentType<?>, Optional<?>> patches = components.getPatches();
        ArrayList values2 = new ArrayList(patches.size());
        for (Map.Entry<ComponentType<?>, Optional<?>> patch2 : patches.entrySet()) {
            if (!patch2.getValue().isPresent()) continue;
            values2.add(new ComponentValue(patch2.getKey(), patch2.getValue().get()));
        }
        return new ComponentPredicate(values2);
    }

    public PatchableComponentMap asPatches(StaticComponentMap base) {
        PatchableComponentMap patched = new PatchableComponentMap(base);
        for (ComponentValue<?> component : this.requiredComponents) {
            patched.set(component);
        }
        return patched;
    }

    @Override
    public boolean test(IComponentMap components) {
        for (ComponentValue<?> component : this.requiredComponents) {
            Optional<?> value = components.getOptional(component.getType());
            if (value.isPresent() && component.getValue().equals(value.get())) continue;
            return false;
        }
        return true;
    }

    public List<ComponentValue<?>> getRequiredComponents() {
        return this.requiredComponents;
    }

    public void setRequiredComponents(List<ComponentValue<?>> requiredComponents) {
        this.requiredComponents = requiredComponents;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ComponentPredicate)) {
            return false;
        }
        ComponentPredicate that = (ComponentPredicate)obj;
        return this.requiredComponents.equals(that.requiredComponents);
    }

    public int hashCode() {
        return Objects.hashCode(this.requiredComponents);
    }

    public String toString() {
        return "ComponentPredicate{requiredComponents=" + this.requiredComponents + '}';
    }
}

