/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.lib.packetevents.protocol.component;

import java.util.function.Function;
import me.mochibit.lib.packetevents.protocol.component.ComponentType;
import me.mochibit.lib.packetevents.protocol.mapper.AbstractMappedEntity;
import me.mochibit.lib.packetevents.protocol.nbt.NBT;
import me.mochibit.lib.packetevents.protocol.player.ClientVersion;
import me.mochibit.lib.packetevents.util.mappings.TypesBuilderData;
import me.mochibit.lib.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public class StaticComponentType<T>
extends AbstractMappedEntity
implements ComponentType<T> {
    @Nullable
    private final PacketWrapper.Reader<T> reader;
    @Nullable
    private final PacketWrapper.Writer<T> writer;
    @Nullable
    private final ComponentType.Decoder<T> decoder;
    @Nullable
    private final ComponentType.Encoder<T> encoder;

    public StaticComponentType(@Nullable TypesBuilderData data, @Nullable PacketWrapper.Reader<T> reader2, @Nullable PacketWrapper.Writer<T> writer2) {
        this(data, reader2, writer2, null, null);
    }

    public StaticComponentType(@Nullable TypesBuilderData data, @Nullable ComponentType.Decoder<T> decoder, @Nullable ComponentType.Encoder<T> encoder) {
        this(data, null, null, decoder, encoder);
    }

    public StaticComponentType(@Nullable TypesBuilderData data, @Nullable PacketWrapper.Reader<T> reader2, @Nullable PacketWrapper.Writer<T> writer2, @Nullable ComponentType.Decoder<T> decoder, @Nullable ComponentType.Encoder<T> encoder) {
        super(data);
        this.reader = reader2;
        this.writer = writer2;
        this.decoder = decoder;
        this.encoder = encoder;
    }

    @Override
    public T read(PacketWrapper<?> wrapper) {
        return this.reader != null ? (T)this.reader.apply(wrapper) : null;
    }

    @Override
    public void write(PacketWrapper<?> wrapper, T content2) {
        if (this.writer != null) {
            this.writer.accept(wrapper, content2);
        }
    }

    @Override
    public T decode(NBT nbt, ClientVersion version) {
        if (this.decoder != null) {
            return this.decoder.decode(nbt, version);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public NBT encode(T value, ClientVersion version) {
        if (this.encoder != null) {
            return this.encoder.encode(value, version);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <Z> ComponentType<Z> legacyMap(Function<T, Z> mapper, Function<Z, T> unmapper) {
        PacketWrapper.Reader reader2 = this.reader != null ? wrapper -> mapper.apply(this.reader.apply((PacketWrapper)wrapper)) : null;
        PacketWrapper.Writer writer2 = this.writer != null ? (wrapper, value) -> this.writer.accept((PacketWrapper)wrapper, unmapper.apply(value)) : null;
        ComponentType.Decoder<Object> decoder = this.decoder != null ? (nbt, version) -> mapper.apply(this.decoder.decode(nbt, version)) : null;
        ComponentType.Encoder<Object> encoder = this.encoder != null ? (value, version) -> this.encoder.encode(unmapper.apply(value), version) : null;
        return new StaticComponentType<Object>(this.data, reader2, writer2, decoder, encoder);
    }
}

