/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.lib.packetevents.protocol.component.builtin.item;

import java.util.Objects;
import me.mochibit.lib.packetevents.protocol.item.trimmaterial.TrimMaterial;
import me.mochibit.lib.packetevents.protocol.item.trimpattern.TrimPattern;
import me.mochibit.lib.packetevents.wrapper.PacketWrapper;

public class ArmorTrim {
    private TrimMaterial material;
    private TrimPattern pattern;
    private boolean showInTooltip;

    public ArmorTrim(TrimMaterial material, TrimPattern pattern, boolean showInTooltip) {
        this.material = material;
        this.pattern = pattern;
        this.showInTooltip = showInTooltip;
    }

    public static ArmorTrim read(PacketWrapper<?> wrapper) {
        TrimMaterial material = TrimMaterial.read(wrapper);
        TrimPattern pattern = TrimPattern.read(wrapper);
        boolean showInTooltip = wrapper.readBoolean();
        return new ArmorTrim(material, pattern, showInTooltip);
    }

    public static void write(PacketWrapper<?> wrapper, ArmorTrim trim) {
        TrimMaterial.write(wrapper, trim.material);
        TrimPattern.write(wrapper, trim.pattern);
        wrapper.writeBoolean(trim.showInTooltip);
    }

    public TrimMaterial getMaterial() {
        return this.material;
    }

    public void setMaterial(TrimMaterial material) {
        this.material = material;
    }

    public TrimPattern getPattern() {
        return this.pattern;
    }

    public void setPattern(TrimPattern pattern) {
        this.pattern = pattern;
    }

    public boolean isShowInTooltip() {
        return this.showInTooltip;
    }

    public void setShowInTooltip(boolean showInTooltip) {
        this.showInTooltip = showInTooltip;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ArmorTrim)) {
            return false;
        }
        ArmorTrim armorTrim = (ArmorTrim)obj;
        if (this.showInTooltip != armorTrim.showInTooltip) {
            return false;
        }
        if (!this.material.equals(armorTrim.material)) {
            return false;
        }
        return this.pattern.equals(armorTrim.pattern);
    }

    public int hashCode() {
        return Objects.hash(this.material, this.pattern, this.showInTooltip);
    }

    public String toString() {
        return "ArmorTrim{material=" + this.material + ", pattern=" + this.pattern + ", showInTooltip=" + this.showInTooltip + '}';
    }
}

