/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.lib.packetevents.protocol.component.builtin.item;

import java.util.Objects;
import me.mochibit.lib.packetevents.protocol.nbt.NBTCompound;
import me.mochibit.lib.packetevents.protocol.nbt.NBTLong;
import me.mochibit.lib.packetevents.protocol.nbt.NBTNumber;
import me.mochibit.lib.packetevents.protocol.nbt.NBTString;
import me.mochibit.lib.packetevents.resources.ResourceLocation;
import me.mochibit.lib.packetevents.wrapper.PacketWrapper;

public class ItemContainerLoot {
    private ResourceLocation lootTable;
    private long seed;

    public ItemContainerLoot(ResourceLocation lootTable, long seed) {
        this.lootTable = lootTable;
        this.seed = seed;
    }

    public static ItemContainerLoot read(PacketWrapper<?> wrapper) {
        NBTCompound compound = wrapper.readNBT();
        ResourceLocation lootTable = new ResourceLocation(compound.getStringTagValueOrThrow("loot_table"));
        NBTNumber seedTag = compound.getNumberTagOrNull("seed");
        long seed = seedTag == null ? 0L : seedTag.getAsLong();
        return new ItemContainerLoot(lootTable, seed);
    }

    public static void write(PacketWrapper<?> wrapper, ItemContainerLoot loot) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("loot_table", new NBTString(loot.lootTable.toString()));
        if (loot.seed != 0L) {
            compound.setTag("seed", new NBTLong(loot.seed));
        }
        wrapper.writeNBT(compound);
    }

    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    public void setLootTable(ResourceLocation lootTable) {
        this.lootTable = lootTable;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ItemContainerLoot)) {
            return false;
        }
        ItemContainerLoot that = (ItemContainerLoot)obj;
        if (this.seed != that.seed) {
            return false;
        }
        return this.lootTable.equals(that.lootTable);
    }

    public int hashCode() {
        return Objects.hash(this.lootTable, this.seed);
    }
}

