/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.lib.packetevents.protocol.item.enchantment.type;

import java.util.Optional;
import me.mochibit.lib.packetevents.protocol.component.EnchantEffectComponentTypes;
import me.mochibit.lib.packetevents.protocol.component.IComponentMap;
import me.mochibit.lib.packetevents.protocol.component.StaticComponentMap;
import me.mochibit.lib.packetevents.protocol.item.enchantment.EnchantmentDefinition;
import me.mochibit.lib.packetevents.protocol.item.enchantment.type.EnchantmentTypes;
import me.mochibit.lib.packetevents.protocol.item.enchantment.type.StaticEnchantmentType;
import me.mochibit.lib.packetevents.protocol.mapper.CopyableEntity;
import me.mochibit.lib.packetevents.protocol.mapper.DeepComparableEntity;
import me.mochibit.lib.packetevents.protocol.mapper.MappedEntity;
import me.mochibit.lib.packetevents.protocol.mapper.MappedEntitySet;
import me.mochibit.lib.packetevents.protocol.nbt.NBT;
import me.mochibit.lib.packetevents.protocol.nbt.NBTCompound;
import me.mochibit.lib.packetevents.protocol.player.ClientVersion;
import me.mochibit.lib.packetevents.util.adventure.AdventureSerializer;
import me.mochibit.lib.packetevents.util.mappings.TypesBuilderData;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public interface EnchantmentType
extends MappedEntity,
CopyableEntity<EnchantmentType>,
DeepComparableEntity {
    public Component getDescription();

    public EnchantmentDefinition getDefinition();

    public MappedEntitySet<EnchantmentType> getExclusiveSet();

    public StaticComponentMap getEffects();

    public static EnchantmentType decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        Component description = AdventureSerializer.fromNbt(compound.getTagOrThrow("description"));
        EnchantmentDefinition definition = EnchantmentDefinition.decode(compound, version);
        MappedEntitySet exclusiveSet = Optional.ofNullable(compound.getTagOrNull("exclusive_set")).map(tag -> MappedEntitySet.decode(tag, version, EnchantmentTypes.getRegistry())).orElseGet(MappedEntitySet::createEmpty);
        StaticComponentMap effects = Optional.ofNullable(compound.getTagOrNull("effects")).map(tag -> IComponentMap.decode(tag, version, EnchantEffectComponentTypes.getRegistry())).orElse(StaticComponentMap.EMPTY);
        return new StaticEnchantmentType(data, description, definition, exclusiveSet, effects);
    }

    public static NBT encode(EnchantmentType type, ClientVersion version) {
        NBTCompound compound = (NBTCompound)EnchantmentDefinition.encode(type.getDefinition(), version);
        compound.setTag("description", AdventureSerializer.toNbt(type.getDescription()));
        if (!type.getExclusiveSet().isEmpty()) {
            compound.setTag("exclusive_set", MappedEntitySet.encode(type.getExclusiveSet(), version));
        }
        if (!type.getEffects().isEmpty()) {
            compound.setTag("effects", IComponentMap.encode(type.getEffects(), version));
        }
        return compound;
    }
}

