/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.lib.packetevents.protocol.item.enchantment.type;

import java.util.Objects;
import me.mochibit.lib.packetevents.protocol.component.StaticComponentMap;
import me.mochibit.lib.packetevents.protocol.item.enchantment.EnchantmentDefinition;
import me.mochibit.lib.packetevents.protocol.item.enchantment.type.EnchantmentType;
import me.mochibit.lib.packetevents.protocol.mapper.AbstractMappedEntity;
import me.mochibit.lib.packetevents.protocol.mapper.MappedEntitySet;
import me.mochibit.lib.packetevents.util.mappings.TypesBuilderData;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public class StaticEnchantmentType
extends AbstractMappedEntity
implements EnchantmentType {
    private final Component description;
    private final EnchantmentDefinition definition;
    private final MappedEntitySet<EnchantmentType> exclusiveSet;
    private final StaticComponentMap effects;

    public StaticEnchantmentType(Component description, EnchantmentDefinition definition, MappedEntitySet<EnchantmentType> exclusiveSet, StaticComponentMap effects) {
        this(null, description, definition, exclusiveSet, effects);
    }

    public StaticEnchantmentType(@Nullable TypesBuilderData data, Component description, EnchantmentDefinition definition, MappedEntitySet<EnchantmentType> exclusiveSet, StaticComponentMap effects) {
        super(data);
        this.description = description;
        this.definition = definition;
        this.exclusiveSet = exclusiveSet;
        this.effects = effects;
    }

    @Override
    public EnchantmentType copy(@Nullable TypesBuilderData newData) {
        return new StaticEnchantmentType(newData, this.description, this.definition, this.exclusiveSet, this.effects);
    }

    @Override
    public Component getDescription() {
        return this.description;
    }

    @Override
    public EnchantmentDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public MappedEntitySet<EnchantmentType> getExclusiveSet() {
        return this.exclusiveSet;
    }

    @Override
    public StaticComponentMap getEffects() {
        return this.effects;
    }

    @Override
    public boolean deepEquals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StaticEnchantmentType)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        StaticEnchantmentType that = (StaticEnchantmentType)obj;
        if (!this.description.equals(that.description)) {
            return false;
        }
        if (!this.definition.equals(that.definition)) {
            return false;
        }
        if (!this.exclusiveSet.equals(that.exclusiveSet)) {
            return false;
        }
        return this.effects.equals(that.effects);
    }

    @Override
    public int deepHashCode() {
        return Objects.hash(super.hashCode(), this.description, this.definition, this.exclusiveSet, this.effects);
    }

    @Override
    public String toString() {
        return "StaticEnchantmentType{description=" + this.description + ", definition=" + this.definition + ", exclusiveSet=" + this.exclusiveSet + ", effects=" + this.effects + "}";
    }
}

