/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.lib.packetevents.protocol.item.instrument;

import me.mochibit.lib.packetevents.manager.server.ServerVersion;
import me.mochibit.lib.packetevents.protocol.item.instrument.Instruments;
import me.mochibit.lib.packetevents.protocol.item.instrument.StaticInstrument;
import me.mochibit.lib.packetevents.protocol.mapper.CopyableEntity;
import me.mochibit.lib.packetevents.protocol.mapper.DeepComparableEntity;
import me.mochibit.lib.packetevents.protocol.mapper.MappedEntity;
import me.mochibit.lib.packetevents.protocol.nbt.NBT;
import me.mochibit.lib.packetevents.protocol.nbt.NBTCompound;
import me.mochibit.lib.packetevents.protocol.nbt.NBTFloat;
import me.mochibit.lib.packetevents.protocol.player.ClientVersion;
import me.mochibit.lib.packetevents.protocol.sound.Sound;
import me.mochibit.lib.packetevents.util.MathUtil;
import me.mochibit.lib.packetevents.util.adventure.AdventureSerializer;
import me.mochibit.lib.packetevents.util.mappings.TypesBuilderData;
import me.mochibit.lib.packetevents.wrapper.PacketWrapper;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public interface Instrument
extends MappedEntity,
CopyableEntity<Instrument>,
DeepComparableEntity {
    public Sound getSound();

    public float getUseSeconds();

    default public int getUseDuration() {
        return MathUtil.floor(this.getUseSeconds() * 20.0f);
    }

    public float getRange();

    public Component getDescription();

    public static Instrument read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntityOrDirect(Instruments.getRegistry(), Instrument::readDirect);
    }

    public static Instrument readDirect(PacketWrapper<?> wrapper) {
        Sound sound = Sound.read(wrapper);
        float useSeconds = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_2) ? wrapper.readFloat() : (float)wrapper.readVarInt() * 20.0f;
        float range = wrapper.readFloat();
        Component description = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_2) ? wrapper.readComponent() : Component.empty();
        return new StaticInstrument(sound, useSeconds, range, description);
    }

    public static void write(PacketWrapper<?> wrapper, Instrument instrument) {
        wrapper.writeMappedEntityOrDirect(instrument, Instrument::writeDirect);
    }

    public static void writeDirect(PacketWrapper<?> wrapper, Instrument instrument) {
        Sound.write(wrapper, instrument.getSound());
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_2)) {
            wrapper.writeFloat(instrument.getUseSeconds());
        } else {
            wrapper.writeVarInt(instrument.getUseDuration());
        }
        wrapper.writeFloat(instrument.getRange());
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_2)) {
            wrapper.writeComponent(instrument.getDescription());
        }
    }

    public static Instrument decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        Sound sound = Sound.decode(compound.getTagOrThrow("sound_event"), version);
        float useSeconds = compound.getNumberTagOrThrow("use_duration").getAsFloat();
        float range = compound.getNumberTagOrThrow("range").getAsFloat();
        Component description = AdventureSerializer.fromNbt(compound.getTagOrThrow("description"));
        return new StaticInstrument(data, sound, useSeconds, range, description);
    }

    public static NBT encode(Instrument instrument, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("sound_event", Sound.encode(instrument.getSound(), version));
        compound.setTag("use_duration", new NBTFloat(instrument.getUseSeconds()));
        compound.setTag("range", new NBTFloat(instrument.getRange()));
        compound.setTag("description", AdventureSerializer.toNbt(instrument.getDescription()));
        return compound;
    }
}

