/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.lib.packetevents.protocol.item.mapdecoration;

import java.util.Collection;
import me.mochibit.lib.packetevents.protocol.item.mapdecoration.MapDecorationType;
import me.mochibit.lib.packetevents.protocol.player.ClientVersion;
import me.mochibit.lib.packetevents.resources.ResourceLocation;
import me.mochibit.lib.packetevents.util.mappings.TypesBuilderData;
import me.mochibit.lib.packetevents.util.mappings.VersionedRegistry;
import org.jetbrains.annotations.Nullable;

public class MapDecorationTypes {
    private static final VersionedRegistry<MapDecorationType> REGISTRY = new VersionedRegistry("map_decoration_type", "item/item_map_decoration_type_mappings");
    private static final int LIGHT_GRAY_COLOR = 0x999999;
    private static final int COPPER_COLOR = 12741452;
    public static final MapDecorationType PLAYER = MapDecorationTypes.define("player", false, true);
    public static final MapDecorationType FRAME = MapDecorationTypes.define("frame", true, true);
    public static final MapDecorationType RED_MARKER = MapDecorationTypes.define("red_marker", false, true);
    public static final MapDecorationType BLUE_MARKER = MapDecorationTypes.define("blue_marker", false, true);
    public static final MapDecorationType TARGET_X = MapDecorationTypes.define("target_x", true, false);
    public static final MapDecorationType TARGET_POINT = MapDecorationTypes.define("target_point", true, false);
    public static final MapDecorationType PLAYER_OFF_MAP = MapDecorationTypes.define("player_off_map", false, true);
    public static final MapDecorationType PLAYER_OFF_LIMITS = MapDecorationTypes.define("player_off_limits", false, true);
    public static final MapDecorationType MANSION = MapDecorationTypes.define("mansion", true, 5393476, true, false);
    public static final MapDecorationType MONUMENT = MapDecorationTypes.define("monument", true, 3830373, true, false);
    public static final MapDecorationType BANNER_WHITE = MapDecorationTypes.define("banner_white", ResourceLocation.minecraft("white_banner"), true, true);
    public static final MapDecorationType BANNER_ORANGE = MapDecorationTypes.define("banner_orange", ResourceLocation.minecraft("orange_banner"), true, true);
    public static final MapDecorationType BANNER_MAGENTA = MapDecorationTypes.define("banner_magenta", ResourceLocation.minecraft("magenta_banner"), true, true);
    public static final MapDecorationType BANNER_LIGHT_BLUE = MapDecorationTypes.define("banner_light_blue", ResourceLocation.minecraft("light_blue_banner"), true, true);
    public static final MapDecorationType BANNER_YELLOW = MapDecorationTypes.define("banner_yellow", ResourceLocation.minecraft("yellow_banner"), true, true);
    public static final MapDecorationType BANNER_LIME = MapDecorationTypes.define("banner_lime", ResourceLocation.minecraft("lime_banner"), true, true);
    public static final MapDecorationType BANNER_PINK = MapDecorationTypes.define("banner_pink", ResourceLocation.minecraft("pink_banner"), true, true);
    public static final MapDecorationType BANNER_GRAY = MapDecorationTypes.define("banner_gray", ResourceLocation.minecraft("gray_banner"), true, true);
    public static final MapDecorationType BANNER_LIGHT_GRAY = MapDecorationTypes.define("banner_light_gray", ResourceLocation.minecraft("light_gray_banner"), true, true);
    public static final MapDecorationType BANNER_CYAN = MapDecorationTypes.define("banner_cyan", ResourceLocation.minecraft("cyan_banner"), true, true);
    public static final MapDecorationType BANNER_PURPLE = MapDecorationTypes.define("banner_purple", ResourceLocation.minecraft("purple_banner"), true, true);
    public static final MapDecorationType BANNER_BLUE = MapDecorationTypes.define("banner_blue", ResourceLocation.minecraft("blue_banner"), true, true);
    public static final MapDecorationType BANNER_BROWN = MapDecorationTypes.define("banner_brown", ResourceLocation.minecraft("brown_banner"), true, true);
    public static final MapDecorationType BANNER_GREEN = MapDecorationTypes.define("banner_green", ResourceLocation.minecraft("green_banner"), true, true);
    public static final MapDecorationType BANNER_RED = MapDecorationTypes.define("banner_red", ResourceLocation.minecraft("red_banner"), true, true);
    public static final MapDecorationType BANNER_BLACK = MapDecorationTypes.define("banner_black", ResourceLocation.minecraft("black_banner"), true, true);
    public static final MapDecorationType RED_X = MapDecorationTypes.define("red_x", true, false);
    public static final MapDecorationType VILLAGE_DESERT = MapDecorationTypes.define("village_desert", ResourceLocation.minecraft("desert_village"), true, 0x999999, true, false);
    public static final MapDecorationType VILLAGE_PLAINS = MapDecorationTypes.define("village_plains", ResourceLocation.minecraft("plains_village"), true, 0x999999, true, false);
    public static final MapDecorationType VILLAGE_SAVANNA = MapDecorationTypes.define("village_savanna", ResourceLocation.minecraft("savanna_village"), true, 0x999999, true, false);
    public static final MapDecorationType VILLAGE_SNOWY = MapDecorationTypes.define("village_snowy", ResourceLocation.minecraft("snowy_village"), true, 0x999999, true, false);
    public static final MapDecorationType VILLAGE_TAIGA = MapDecorationTypes.define("village_taiga", ResourceLocation.minecraft("taiga_village"), true, 0x999999, true, false);
    public static final MapDecorationType JUNGLE_TEMPLE = MapDecorationTypes.define("jungle_temple", true, 0x999999, true, false);
    public static final MapDecorationType SWAMP_HUT = MapDecorationTypes.define("swamp_hut", true, 0x999999, true, false);
    public static final MapDecorationType TRIAL_CHAMBERS = MapDecorationTypes.define("trial_chambers", true, 12741452, true, false);

    public static MapDecorationType define(String key2, boolean showOnItemFrame, boolean trackCount) {
        return MapDecorationTypes.define(key2, ResourceLocation.minecraft(key2), showOnItemFrame, trackCount);
    }

    public static MapDecorationType define(String key2, ResourceLocation assetId, boolean showOnItemFrame, boolean trackCount) {
        return MapDecorationTypes.define(key2, assetId, showOnItemFrame, -1, false, trackCount);
    }

    public static MapDecorationType define(String key2, boolean showOnItemFrame, int mapColor, boolean explorationMapElement, boolean trackCount) {
        return MapDecorationTypes.define(key2, ResourceLocation.minecraft(key2), showOnItemFrame, mapColor, explorationMapElement, trackCount);
    }

    public static MapDecorationType define(String key2, final ResourceLocation assetId, final boolean showOnItemFrame, final int mapColor, final boolean explorationMapElement, final boolean trackCount) {
        return REGISTRY.define(key2, data -> new MapDecorationType(){
            final /* synthetic */ TypesBuilderData val$data;
            {
                this.val$data = typesBuilderData;
            }

            @Override
            public ResourceLocation getAssetId() {
                return assetId;
            }

            @Override
            public boolean isShowOnItemFrame() {
                return showOnItemFrame;
            }

            @Override
            public int getMapColor() {
                return mapColor;
            }

            @Override
            public boolean isExplorationMapElement() {
                return explorationMapElement;
            }

            @Override
            public boolean isTrackCount() {
                return trackCount;
            }

            @Override
            public ResourceLocation getName() {
                return this.val$data.getName();
            }

            @Override
            public int getId(ClientVersion version) {
                return this.val$data.getId(version);
            }

            public boolean equals(Object obj) {
                if (obj instanceof MapDecorationType) {
                    return this.getName().equals(((MapDecorationType)obj).getName());
                }
                return false;
            }
        });
    }

    @Nullable
    public static MapDecorationType getByName(String name) {
        return REGISTRY.getByName(name);
    }

    @Nullable
    public static MapDecorationType getById(int id, ClientVersion version) {
        return REGISTRY.getById(version, id);
    }

    @Nullable
    public static MapDecorationType getById(ClientVersion version, int id) {
        return REGISTRY.getById(version, id);
    }

    public static Collection<MapDecorationType> values() {
        return REGISTRY.getEntries();
    }

    static {
        REGISTRY.unloadMappings();
    }
}

