/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.lib.packetevents.protocol.item.trimmaterial;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import me.mochibit.lib.packetevents.manager.server.ServerVersion;
import me.mochibit.lib.packetevents.protocol.item.armormaterial.ArmorMaterial;
import me.mochibit.lib.packetevents.protocol.item.armormaterial.ArmorMaterials;
import me.mochibit.lib.packetevents.protocol.item.trimmaterial.StaticTrimMaterial;
import me.mochibit.lib.packetevents.protocol.item.trimmaterial.TrimMaterials;
import me.mochibit.lib.packetevents.protocol.item.type.ItemType;
import me.mochibit.lib.packetevents.protocol.item.type.ItemTypes;
import me.mochibit.lib.packetevents.protocol.mapper.CopyableEntity;
import me.mochibit.lib.packetevents.protocol.mapper.DeepComparableEntity;
import me.mochibit.lib.packetevents.protocol.mapper.MappedEntity;
import me.mochibit.lib.packetevents.protocol.nbt.NBT;
import me.mochibit.lib.packetevents.protocol.nbt.NBTCompound;
import me.mochibit.lib.packetevents.protocol.nbt.NBTFloat;
import me.mochibit.lib.packetevents.protocol.nbt.NBTString;
import me.mochibit.lib.packetevents.protocol.player.ClientVersion;
import me.mochibit.lib.packetevents.util.adventure.AdventureSerializer;
import me.mochibit.lib.packetevents.util.mappings.TypesBuilderData;
import me.mochibit.lib.packetevents.wrapper.PacketWrapper;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface TrimMaterial
extends MappedEntity,
CopyableEntity<TrimMaterial>,
DeepComparableEntity {
    public static final float FALLBACK_ITEM_MODEL_INDEX = 0.0f;

    public String getAssetName();

    public ItemType getIngredient();

    @ApiStatus.Obsolete
    public float getItemModelIndex();

    @Nullable
    default public String getArmorMaterialOverride(ArmorMaterial armorMaterial) {
        return this.getOverrideArmorMaterials().get(armorMaterial);
    }

    public Map<ArmorMaterial, String> getOverrideArmorMaterials();

    public Component getDescription();

    public static TrimMaterial read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntityOrDirect(TrimMaterials.getRegistry(), TrimMaterial::readDirect);
    }

    public static TrimMaterial readDirect(PacketWrapper<?> wrapper) {
        String assetName = wrapper.readString();
        ItemType ingredient = wrapper.readMappedEntity(ItemTypes::getById);
        float itemModelIndex = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_4) ? 0.0f : wrapper.readFloat();
        Map<ArmorMaterial, String> overrideArmorMaterials = wrapper.readMap(ew -> ew.readMappedEntity(ArmorMaterials::getById), PacketWrapper::readString);
        Component description = wrapper.readComponent();
        return new StaticTrimMaterial(assetName, ingredient, itemModelIndex, overrideArmorMaterials, description);
    }

    public static void write(PacketWrapper<?> wrapper, TrimMaterial material) {
        wrapper.writeMappedEntityOrDirect(material, TrimMaterial::writeDirect);
    }

    public static void writeDirect(PacketWrapper<?> wrapper, TrimMaterial material) {
        wrapper.writeString(material.getAssetName());
        wrapper.writeMappedEntity(material.getIngredient());
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_4)) {
            wrapper.writeFloat(material.getItemModelIndex());
        }
        wrapper.writeMap(material.getOverrideArmorMaterials(), PacketWrapper::writeMappedEntity, PacketWrapper::writeString);
        wrapper.writeComponent(material.getDescription());
    }

    public static TrimMaterial decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        Map<ArmorMaterial, String> overrideArmorMaterials;
        NBTCompound compound = (NBTCompound)nbt;
        String assetName = compound.getStringTagValueOrThrow("asset_name");
        ItemType ingredient = ItemTypes.getByName(compound.getStringTagValueOrThrow("ingredient"));
        float itemModelIndex = version.isNewerThanOrEquals(ClientVersion.V_1_21_4) ? 0.0f : compound.getNumberTagOrThrow("item_model_index").getAsFloat();
        NBTCompound overrideArmorMaterialsTag = compound.getCompoundTagOrNull("override_armor_materials");
        if (overrideArmorMaterialsTag != null) {
            overrideArmorMaterials = new HashMap();
            for (Map.Entry<String, NBT> entry : overrideArmorMaterialsTag.getTags().entrySet()) {
                ArmorMaterial material = ArmorMaterials.getByName(entry.getKey());
                String override = ((NBTString)entry.getValue()).getValue();
                overrideArmorMaterials.put(material, override);
            }
        } else {
            overrideArmorMaterials = Collections.emptyMap();
        }
        Component description = AdventureSerializer.fromNbt(((NBTCompound)nbt).getTagOrThrow("description"));
        return new StaticTrimMaterial(data, assetName, ingredient, itemModelIndex, overrideArmorMaterials, description);
    }

    public static NBT encode(TrimMaterial material, ClientVersion version) {
        NBTCompound overrideArmorMaterialsTag;
        if (!material.getOverrideArmorMaterials().isEmpty()) {
            overrideArmorMaterialsTag = new NBTCompound();
            for (Map.Entry<ArmorMaterial, String> entry : material.getOverrideArmorMaterials().entrySet()) {
                String materialName = entry.getKey().getName().toString();
                NBTString overrideTag = new NBTString(entry.getValue());
                overrideArmorMaterialsTag.setTag(materialName, overrideTag);
            }
        } else {
            overrideArmorMaterialsTag = null;
        }
        NBTCompound compound = new NBTCompound();
        compound.setTag("asset_name", new NBTString(material.getAssetName()));
        compound.setTag("ingredient", new NBTString(material.getIngredient().getName().toString()));
        if (version.isNewerThanOrEquals(ClientVersion.V_1_21_4)) {
            compound.setTag("item_model_index", new NBTFloat(material.getItemModelIndex()));
        }
        if (overrideArmorMaterialsTag != null) {
            compound.setTag("override_armor_materials", overrideArmorMaterialsTag);
        }
        compound.setTag("description", AdventureSerializer.toNbt(material.getDescription()));
        return compound;
    }
}

