/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.lib.packetevents.protocol.nbt;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import me.mochibit.lib.packetevents.protocol.nbt.NBT;
import me.mochibit.lib.packetevents.protocol.nbt.NBTList;
import me.mochibit.lib.packetevents.protocol.nbt.NBTNumber;
import me.mochibit.lib.packetevents.protocol.nbt.NBTString;
import me.mochibit.lib.packetevents.protocol.nbt.NBTType;
import org.jetbrains.annotations.Nullable;

public class NBTCompound
extends NBT {
    protected final Map<String, NBT> tags = new LinkedHashMap<String, NBT>();

    public NBTType<NBTCompound> getType() {
        return NBTType.COMPOUND;
    }

    public boolean isEmpty() {
        return this.tags.isEmpty();
    }

    public Set<String> getTagNames() {
        return Collections.unmodifiableSet(this.tags.keySet());
    }

    public Map<String, NBT> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    public int size() {
        return this.tags.size();
    }

    public NBT getTagOrThrow(String key2) {
        NBT tag = this.getTagOrNull(key2);
        if (tag == null) {
            throw new IllegalStateException(MessageFormat.format("NBT {0} does not exist", key2));
        }
        return tag;
    }

    @Nullable
    public NBT getTagOrNull(String key2) {
        return this.tags.get(key2);
    }

    public <T extends NBT> T getTagOfTypeOrThrow(String key2, Class<T> type) {
        NBT tag = this.getTagOrThrow(key2);
        if (type.isInstance(tag)) {
            return (T)tag;
        }
        throw new IllegalStateException(MessageFormat.format("NBT {0} has unexpected type, expected {1}, but got {2}", key2, type, tag.getClass()));
    }

    @Nullable
    public <T extends NBT> T getTagOfTypeOrNull(String key2, Class<T> type) {
        NBT tag = this.getTagOrNull(key2);
        if (type.isInstance(tag)) {
            return (T)tag;
        }
        return null;
    }

    public <T extends NBT> NBTList<T> getTagListOfTypeOrThrow(String key2, Class<T> type) {
        NBTList list = this.getTagOfTypeOrThrow(key2, NBTList.class);
        if (!type.isAssignableFrom(list.getTagsType().getNBTClass())) {
            throw new IllegalStateException(MessageFormat.format("NBTList {0} tags type has unexpected type, expected {1}, but got {2}", key2, type, list.getTagsType().getNBTClass()));
        }
        return list;
    }

    @Nullable
    public <T extends NBT> NBTList<T> getTagListOfTypeOrNull(String key2, Class<T> type) {
        NBTList list = this.getTagOfTypeOrNull(key2, NBTList.class);
        if (list != null && type.isAssignableFrom(list.getTagsType().getNBTClass())) {
            return list;
        }
        return null;
    }

    public NBTCompound getCompoundTagOrThrow(String key2) {
        return this.getTagOfTypeOrThrow(key2, NBTCompound.class);
    }

    @Nullable
    public NBTCompound getCompoundTagOrNull(String key2) {
        return this.getTagOfTypeOrNull(key2, NBTCompound.class);
    }

    public NBTNumber getNumberTagOrThrow(String key2) {
        return this.getTagOfTypeOrThrow(key2, NBTNumber.class);
    }

    @Nullable
    public NBTNumber getNumberTagOrNull(String key2) {
        return this.getTagOfTypeOrNull(key2, NBTNumber.class);
    }

    public NBTString getStringTagOrThrow(String key2) {
        return this.getTagOfTypeOrThrow(key2, NBTString.class);
    }

    @Nullable
    public NBTString getStringTagOrNull(String key2) {
        return this.getTagOfTypeOrNull(key2, NBTString.class);
    }

    public NBTList<NBTCompound> getCompoundListTagOrThrow(String key2) {
        return this.getTagListOfTypeOrThrow(key2, NBTCompound.class);
    }

    @Nullable
    public NBTList<NBTCompound> getCompoundListTagOrNull(String key2) {
        return this.getTagListOfTypeOrNull(key2, NBTCompound.class);
    }

    public NBTList<NBTNumber> getNumberTagListTagOrThrow(String key2) {
        return this.getTagListOfTypeOrThrow(key2, NBTNumber.class);
    }

    @Nullable
    public NBTList<NBTNumber> getNumberListTagOrNull(String key2) {
        return this.getTagListOfTypeOrNull(key2, NBTNumber.class);
    }

    public NBTList<NBTString> getStringListTagOrThrow(String key2) {
        return this.getTagListOfTypeOrThrow(key2, NBTString.class);
    }

    @Nullable
    public NBTList<NBTString> getStringListTagOrNull(String key2) {
        return this.getTagListOfTypeOrNull(key2, NBTString.class);
    }

    public String getStringTagValueOrThrow(String key2) {
        return this.getStringTagOrThrow(key2).getValue();
    }

    @Nullable
    public String getStringTagValueOrNull(String key2) {
        NBT tag = this.getTagOrNull(key2);
        if (tag instanceof NBTString) {
            return ((NBTString)tag).getValue();
        }
        return null;
    }

    public String getStringTagValueOrDefault(String key2, String defaultValue) {
        NBT tag = this.getTagOrNull(key2);
        if (tag instanceof NBTString) {
            return ((NBTString)tag).getValue();
        }
        return defaultValue;
    }

    public NBT removeTag(String key2) {
        return this.tags.remove(key2);
    }

    public <T extends NBT> T removeTagAndReturnIfType(String key2, Class<T> type) {
        NBT tag = this.removeTag(key2);
        if (type.isInstance(tag)) {
            return (T)tag;
        }
        return null;
    }

    public <T extends NBT> NBTList<T> removeTagAndReturnIfListType(String key2, Class<T> type) {
        NBTList list = this.removeTagAndReturnIfType(key2, NBTList.class);
        if (list != null && type.isAssignableFrom(list.getTagsType().getNBTClass())) {
            return list;
        }
        return null;
    }

    public void setTag(String key2, NBT tag) {
        if (tag != null) {
            this.tags.put(key2, tag);
        } else {
            this.tags.remove(key2);
        }
    }

    @Override
    public NBTCompound copy() {
        NBTCompound clone = new NBTCompound();
        for (Map.Entry<String, NBT> entry : this.tags.entrySet()) {
            clone.setTag(entry.getKey(), entry.getValue().copy());
        }
        return clone;
    }

    public boolean getBoolean(String string) {
        NBTNumber nbtByte = this.getTagOfTypeOrNull(string, NBTNumber.class);
        return nbtByte != null && nbtByte.getAsByte() != 0;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof NBTCompound) {
            if (this.isEmpty() && ((NBTCompound)other).isEmpty()) {
                return true;
            }
            return this.tags.equals(((NBTCompound)other).tags);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.tags.hashCode();
    }

    @Override
    public String toString() {
        return "Compound{" + this.tags + "}";
    }
}

