/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.lib.packetevents.protocol.particle.data;

import me.mochibit.lib.packetevents.manager.server.ServerVersion;
import me.mochibit.lib.packetevents.protocol.nbt.NBTCompound;
import me.mochibit.lib.packetevents.protocol.particle.data.LegacyConvertible;
import me.mochibit.lib.packetevents.protocol.particle.data.LegacyParticleData;
import me.mochibit.lib.packetevents.protocol.particle.data.ParticleData;
import me.mochibit.lib.packetevents.protocol.player.ClientVersion;
import me.mochibit.lib.packetevents.protocol.world.states.WrappedBlockState;
import me.mochibit.lib.packetevents.wrapper.PacketWrapper;

public class ParticleBlockStateData
extends ParticleData
implements LegacyConvertible {
    private WrappedBlockState blockState;

    public ParticleBlockStateData(WrappedBlockState blockState) {
        this.blockState = blockState;
    }

    public WrappedBlockState getBlockState() {
        return this.blockState;
    }

    public void setBlockState(WrappedBlockState blockState) {
        this.blockState = blockState;
    }

    public static ParticleBlockStateData read(PacketWrapper<?> wrapper) {
        int blockID = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_9) ? wrapper.readVarInt() : (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_13) ? wrapper.readInt() : wrapper.readVarInt());
        return new ParticleBlockStateData(WrappedBlockState.getByGlobalId(wrapper.getServerVersion().toClientVersion(), blockID));
    }

    public static void write(PacketWrapper<?> wrapper, ParticleBlockStateData data) {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_9)) {
            wrapper.writeVarInt(data.getBlockState().getGlobalId());
        } else {
            wrapper.writeInt(data.getBlockState().getGlobalId());
        }
    }

    public static ParticleBlockStateData decode(NBTCompound compound, ClientVersion version) {
        String key2 = version.isNewerThanOrEquals(ClientVersion.V_1_20_5) ? "block_state" : "value";
        WrappedBlockState state = WrappedBlockState.decode(compound.getTagOrThrow(key2), version);
        return new ParticleBlockStateData(state);
    }

    public static void encode(ParticleBlockStateData data, ClientVersion version, NBTCompound compound) {
        String key2 = version.isNewerThanOrEquals(ClientVersion.V_1_20_5) ? "block_state" : "value";
        compound.setTag(key2, WrappedBlockState.encode(data.blockState, version));
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public LegacyParticleData toLegacy(ClientVersion version) {
        return LegacyParticleData.ofOne(this.blockState.getGlobalId());
    }
}

