/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.lib.packetevents.protocol.particle.data;

import me.mochibit.lib.packetevents.manager.server.ServerVersion;
import me.mochibit.lib.packetevents.protocol.item.ItemStack;
import me.mochibit.lib.packetevents.protocol.item.type.ItemTypes;
import me.mochibit.lib.packetevents.protocol.nbt.NBTCompound;
import me.mochibit.lib.packetevents.protocol.particle.data.LegacyConvertible;
import me.mochibit.lib.packetevents.protocol.particle.data.LegacyParticleData;
import me.mochibit.lib.packetevents.protocol.particle.data.ParticleData;
import me.mochibit.lib.packetevents.protocol.player.ClientVersion;
import me.mochibit.lib.packetevents.wrapper.PacketWrapper;

public class ParticleItemStackData
extends ParticleData
implements LegacyConvertible {
    private ItemStack itemStack;

    public ParticleItemStackData(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public static ParticleItemStackData read(PacketWrapper<?> wrapper) {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_13)) {
            return new ParticleItemStackData(wrapper.readItemStack());
        }
        return new ParticleItemStackData(ItemStack.builder().type(ItemTypes.getById(wrapper.getClientVersion(), wrapper.readVarInt())).build());
    }

    public static void write(PacketWrapper<?> wrapper, ParticleItemStackData data) {
        wrapper.writeItemStack(data.getItemStack());
    }

    public static ParticleItemStackData decode(NBTCompound compound, ClientVersion version) {
        String key2 = version.isNewerThanOrEquals(ClientVersion.V_1_20_5) ? "item" : "value";
        ItemStack stack = ItemStack.decode(compound.getTagOrThrow(key2), version);
        return new ParticleItemStackData(stack);
    }

    public static void encode(ParticleItemStackData data, ClientVersion version, NBTCompound compound) {
        String key2 = version.isNewerThanOrEquals(ClientVersion.V_1_20_5) ? "item" : "value";
        compound.setTag(key2, ItemStack.encodeForParticle(data.itemStack, version));
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public LegacyParticleData toLegacy(ClientVersion version) {
        return LegacyParticleData.ofTwo(this.itemStack.getType().getId(version), this.itemStack.getLegacyData());
    }
}

