/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.lib.packetevents.protocol.recipe.data;

import me.mochibit.lib.packetevents.manager.server.ServerVersion;
import me.mochibit.lib.packetevents.protocol.component.ComponentPredicate;
import me.mochibit.lib.packetevents.protocol.item.ItemStack;
import me.mochibit.lib.packetevents.protocol.item.type.ItemType;
import me.mochibit.lib.packetevents.protocol.item.type.ItemTypes;
import me.mochibit.lib.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class MerchantItemCost {
    private ItemType item;
    private int count;
    private ComponentPredicate predicate;

    public MerchantItemCost(ItemType item) {
        this(item, 1);
    }

    public MerchantItemCost(ItemType item, int count2) {
        this(item, count2, ComponentPredicate.emptyPredicate());
    }

    public MerchantItemCost(ItemType item, int count2, ComponentPredicate predicate) {
        this.item = item;
        this.count = count2;
        this.predicate = predicate;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static MerchantItemCost ofItem(@Nullable ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.isEmpty()) {
            return MerchantItemCost.emptyCost();
        }
        ComponentPredicate predicate = ComponentPredicate.fromPatches(stack.getComponents());
        return new MerchantItemCost(stack.getType(), stack.getAmount(), predicate);
    }

    public static ItemStack readItem(PacketWrapper<?> wrapper) {
        return wrapper.getServerVersion().isOlderThan(ServerVersion.V_1_20_5) ? wrapper.readItemStack() : MerchantItemCost.read(wrapper).asItem();
    }

    public static MerchantItemCost read(PacketWrapper<?> wrapper) {
        ItemType item = wrapper.readMappedEntity(ItemTypes::getById);
        int count2 = wrapper.readVarInt();
        ComponentPredicate predicate = ComponentPredicate.read(wrapper);
        return new MerchantItemCost(item, count2, predicate);
    }

    public static void writeItem(PacketWrapper<?> wrapper, ItemStack costItem) {
        if (wrapper.getServerVersion().isOlderThan(ServerVersion.V_1_20_5)) {
            wrapper.writeItemStack(costItem);
        } else {
            MerchantItemCost.write(wrapper, MerchantItemCost.ofItem(costItem));
        }
    }

    public static void write(PacketWrapper<?> wrapper, MerchantItemCost cost) {
        wrapper.writeMappedEntity(cost.item);
        wrapper.writeVarInt(cost.count);
        ComponentPredicate.write(wrapper, cost.predicate);
    }

    public static MerchantItemCost emptyCost() {
        return new MerchantItemCost(ItemTypes.AIR, 0);
    }

    public ItemStack asItem() {
        return ItemStack.builder().type(this.item).amount(this.count).components(this.predicate.asPatches(this.item.getComponents())).build();
    }

    public ItemType getItem() {
        return this.item;
    }

    public void setItem(ItemType item) {
        this.item = item;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count2) {
        this.count = count2;
    }

    public ComponentPredicate getPredicate() {
        return this.predicate;
    }

    public void setPredicate(ComponentPredicate predicate) {
        this.predicate = predicate;
    }
}

