/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.lib.packetevents.protocol.sound;

import java.util.Optional;
import me.mochibit.lib.packetevents.protocol.mapper.MappedEntity;
import me.mochibit.lib.packetevents.protocol.nbt.NBT;
import me.mochibit.lib.packetevents.protocol.nbt.NBTCompound;
import me.mochibit.lib.packetevents.protocol.nbt.NBTFloat;
import me.mochibit.lib.packetevents.protocol.nbt.NBTNumber;
import me.mochibit.lib.packetevents.protocol.nbt.NBTString;
import me.mochibit.lib.packetevents.protocol.player.ClientVersion;
import me.mochibit.lib.packetevents.protocol.sound.Sounds;
import me.mochibit.lib.packetevents.protocol.sound.StaticSound;
import me.mochibit.lib.packetevents.resources.ResourceLocation;
import me.mochibit.lib.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public interface Sound
extends MappedEntity {
    public ResourceLocation getSoundId();

    @Nullable
    public Float getRange();

    public static Sound read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntityOrDirect(Sounds::getById, Sound::readDirect);
    }

    public static Sound readDirect(PacketWrapper<?> wrapper) {
        ResourceLocation soundId = wrapper.readIdentifier();
        Float range = (Float)wrapper.readOptional(PacketWrapper::readFloat);
        return new StaticSound(soundId, range);
    }

    public static void write(PacketWrapper<?> wrapper, Sound sound) {
        wrapper.writeMappedEntityOrDirect(sound, Sound::writeDirect);
    }

    public static void writeDirect(PacketWrapper<?> wrapper, Sound sound) {
        wrapper.writeIdentifier(sound.getSoundId());
        wrapper.writeOptional(sound.getRange(), PacketWrapper::writeFloat);
    }

    public static Sound decode(NBT nbt, ClientVersion version) {
        if (nbt instanceof NBTString) {
            return Sounds.getByNameOrCreate(((NBTString)nbt).getValue());
        }
        NBTCompound compound = (NBTCompound)nbt;
        ResourceLocation soundId = new ResourceLocation(((NBTCompound)nbt).getStringTagValueOrThrow("sound_id"));
        Float range = Optional.ofNullable(compound.getNumberTagOrNull("range")).map(NBTNumber::getAsFloat).orElse(null);
        return new StaticSound(soundId, range);
    }

    public static NBT encode(Sound sound, ClientVersion version) {
        if (sound.isRegistered()) {
            return new NBTString(sound.getName().toString());
        }
        NBTCompound compound = new NBTCompound();
        compound.setTag("sound_id", new NBTString(sound.getSoundId().toString()));
        if (sound.getRange() != null) {
            compound.setTag("range", new NBTFloat(sound.getRange().floatValue()));
        }
        return compound;
    }
}

