/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.lib.packetevents.protocol.stats;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import me.mochibit.lib.packetevents.PacketEvents;
import me.mochibit.lib.packetevents.manager.server.ServerVersion;
import me.mochibit.lib.packetevents.protocol.nbt.NBT;
import me.mochibit.lib.packetevents.protocol.nbt.NBTString;
import me.mochibit.lib.packetevents.protocol.nbt.serializer.SequentialNBTReader;
import me.mochibit.lib.packetevents.protocol.stats.Statistic;
import me.mochibit.lib.packetevents.util.adventure.AdventureSerializer;
import me.mochibit.lib.packetevents.util.mappings.MappingHelper;
import net.kyori.adventure.text.Component;

public class Statistics {
    private static final Map<String, Statistic> STATISTIC_MAP = new HashMap<String, Statistic>();

    public static Statistic getById(String id) {
        return STATISTIC_MAP.get(id);
    }

    static {
        ServerVersion version = PacketEvents.getAPI().getServerManager().getVersion();
        if (version.isOlderThan(ServerVersion.V_1_12_2)) {
            try (SequentialNBTReader.Compound mapping = MappingHelper.decompress("mappings/stats/statistics");){
                mapping.skipOne();
                if (version.isOlderThanOrEquals(ServerVersion.V_1_8_3)) {
                    mapping.skipOne();
                }
                SequentialNBTReader.Compound toLoad = (SequentialNBTReader.Compound)mapping.next();
                for (final Map.Entry<String, NBT> entry : toLoad) {
                    final String value = ((NBTString)entry.getValue()).getValue();
                    Statistic statistic = new Statistic(){
                        private Component cachedDisplay;

                        @Override
                        public String getId() {
                            return (String)entry.getKey();
                        }

                        @Override
                        public Component display() {
                            if (this.cachedDisplay == null) {
                                this.cachedDisplay = AdventureSerializer.parseComponent(value);
                            }
                            return this.cachedDisplay;
                        }

                        public boolean equals(Object obj) {
                            if (obj instanceof Statistic) {
                                return ((Statistic)obj).getId().equals(this.getId());
                            }
                            return false;
                        }
                    };
                    STATISTIC_MAP.put(entry.getKey(), statistic);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot load statistics mappings", e);
            }
        }
    }
}

