/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.lib.packetevents.resources;

import java.util.Objects;

public class ResourceLocation {
    public static final String VANILLA_NAMESPACE = "minecraft";
    protected final String namespace;
    protected final String key;

    public ResourceLocation(String namespace, String key2) {
        this.namespace = namespace;
        this.key = key2;
    }

    public ResourceLocation(String location) {
        String[] array = new String[]{VANILLA_NAMESPACE, location};
        int index = location.indexOf(":");
        if (index != -1) {
            array[1] = location.substring(index + 1);
            if (index >= 1) {
                array[0] = location.substring(0, index);
            }
        }
        this.namespace = array[0];
        this.key = array[1];
    }

    public static String normString(String location) {
        int index = location.indexOf(58);
        if (index > 0) {
            return location;
        }
        if (index == -1) {
            return "minecraft:" + location;
        }
        return VANILLA_NAMESPACE + location;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getKey() {
        return this.key;
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.key);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResourceLocation) {
            ResourceLocation other = (ResourceLocation)obj;
            return other.namespace.equals(this.namespace) && other.key.equals(this.key);
        }
        return false;
    }

    public String toString() {
        return this.namespace + ":" + this.key;
    }

    public static ResourceLocation minecraft(String key2) {
        return new ResourceLocation(VANILLA_NAMESPACE, key2);
    }
}

