/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.lib.packetevents.util;

import me.mochibit.lib.packetevents.event.PacketReceiveEvent;
import me.mochibit.lib.packetevents.event.PacketSendEvent;
import me.mochibit.lib.packetevents.event.simple.PacketConfigReceiveEvent;
import me.mochibit.lib.packetevents.event.simple.PacketConfigSendEvent;
import me.mochibit.lib.packetevents.event.simple.PacketHandshakeReceiveEvent;
import me.mochibit.lib.packetevents.event.simple.PacketHandshakeSendEvent;
import me.mochibit.lib.packetevents.event.simple.PacketLoginReceiveEvent;
import me.mochibit.lib.packetevents.event.simple.PacketLoginSendEvent;
import me.mochibit.lib.packetevents.event.simple.PacketPlayReceiveEvent;
import me.mochibit.lib.packetevents.event.simple.PacketPlaySendEvent;
import me.mochibit.lib.packetevents.event.simple.PacketStatusReceiveEvent;
import me.mochibit.lib.packetevents.event.simple.PacketStatusSendEvent;
import me.mochibit.lib.packetevents.exception.PacketProcessException;
import me.mochibit.lib.packetevents.protocol.player.User;

public class EventCreationUtil {
    public static PacketReceiveEvent createReceiveEvent(Object channel, User user, Object player, Object buffer, boolean autoProtocolTranslation) throws PacketProcessException {
        switch (user.getDecoderState()) {
            case HANDSHAKING: {
                return new PacketHandshakeReceiveEvent(channel, user, player, buffer, autoProtocolTranslation);
            }
            case STATUS: {
                return new PacketStatusReceiveEvent(channel, user, player, buffer, autoProtocolTranslation);
            }
            case LOGIN: {
                return new PacketLoginReceiveEvent(channel, user, player, buffer, autoProtocolTranslation);
            }
            case PLAY: {
                return new PacketPlayReceiveEvent(channel, user, player, buffer, autoProtocolTranslation);
            }
            case CONFIGURATION: {
                return new PacketConfigReceiveEvent(channel, user, player, buffer, autoProtocolTranslation);
            }
        }
        throw new RuntimeException("Unknown connection state " + (Object)((Object)user.getDecoderState()) + "!");
    }

    public static PacketSendEvent createSendEvent(Object channel, User user, Object player, Object buffer, boolean autoProtocolTranslation) throws PacketProcessException {
        switch (user.getEncoderState()) {
            case HANDSHAKING: {
                return new PacketHandshakeSendEvent(channel, user, player, buffer, autoProtocolTranslation);
            }
            case STATUS: {
                return new PacketStatusSendEvent(channel, user, player, buffer, autoProtocolTranslation);
            }
            case LOGIN: {
                return new PacketLoginSendEvent(channel, user, player, buffer, autoProtocolTranslation);
            }
            case PLAY: {
                return new PacketPlaySendEvent(channel, user, player, buffer, autoProtocolTranslation);
            }
            case CONFIGURATION: {
                return new PacketConfigSendEvent(channel, user, player, buffer, autoProtocolTranslation);
            }
        }
        throw new RuntimeException("Unknown connection state " + (Object)((Object)user.getEncoderState()) + "!");
    }
}

