/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.lib.packetevents.util;

import java.util.UUID;
import me.mochibit.lib.packetevents.PacketEvents;
import me.mochibit.lib.packetevents.event.PacketReceiveEvent;
import me.mochibit.lib.packetevents.event.PacketSendEvent;
import me.mochibit.lib.packetevents.event.ProtocolPacketEvent;
import me.mochibit.lib.packetevents.event.UserDisconnectEvent;
import me.mochibit.lib.packetevents.manager.protocol.ProtocolManager;
import me.mochibit.lib.packetevents.netty.buffer.ByteBufHelper;
import me.mochibit.lib.packetevents.protocol.PacketSide;
import me.mochibit.lib.packetevents.protocol.player.User;
import me.mochibit.lib.packetevents.util.EventCreationUtil;
import org.jetbrains.annotations.Nullable;

public final class PacketEventsImplHelper {
    private PacketEventsImplHelper() {
    }

    @Nullable
    public static ProtocolPacketEvent handlePacket(Object channel, User user, Object player, Object buffer, boolean autoProtocolTranslation, PacketSide side) throws Exception {
        if (side == PacketSide.SERVER) {
            return PacketEventsImplHelper.handleClientBoundPacket(channel, user, player, buffer, autoProtocolTranslation);
        }
        return PacketEventsImplHelper.handleServerBoundPacket(channel, user, player, buffer, autoProtocolTranslation);
    }

    @Nullable
    public static PacketSendEvent handleClientBoundPacket(Object channel, User user, Object player, Object buffer, boolean autoProtocolTranslation) throws Exception {
        if (!ByteBufHelper.isReadable(buffer)) {
            return null;
        }
        int preProcessIndex = ByteBufHelper.readerIndex(buffer);
        PacketSendEvent packetSendEvent = EventCreationUtil.createSendEvent(channel, user, player, buffer, autoProtocolTranslation);
        int processIndex = ByteBufHelper.readerIndex(buffer);
        PacketEvents.getAPI().getEventManager().callEvent(packetSendEvent, () -> ByteBufHelper.readerIndex(buffer, processIndex));
        if (!packetSendEvent.isCancelled()) {
            if (packetSendEvent.getLastUsedWrapper() != null) {
                ByteBufHelper.clear(buffer);
                packetSendEvent.getLastUsedWrapper().writeVarInt(packetSendEvent.getPacketId());
                packetSendEvent.getLastUsedWrapper().write();
            } else {
                ByteBufHelper.readerIndex(buffer, preProcessIndex);
            }
        } else {
            ByteBufHelper.clear(buffer);
        }
        if (packetSendEvent.hasPostTasks()) {
            for (Runnable task : packetSendEvent.getPostTasks()) {
                task.run();
            }
        }
        return packetSendEvent;
    }

    @Nullable
    public static PacketReceiveEvent handleServerBoundPacket(Object channel, User user, Object player, Object buffer, boolean autoProtocolTranslation) throws Exception {
        if (!ByteBufHelper.isReadable(buffer)) {
            return null;
        }
        int preProcessIndex = ByteBufHelper.readerIndex(buffer);
        PacketReceiveEvent packetReceiveEvent = EventCreationUtil.createReceiveEvent(channel, user, player, buffer, autoProtocolTranslation);
        int processIndex = ByteBufHelper.readerIndex(buffer);
        PacketEvents.getAPI().getEventManager().callEvent(packetReceiveEvent, () -> ByteBufHelper.readerIndex(buffer, processIndex));
        if (!packetReceiveEvent.isCancelled()) {
            if (packetReceiveEvent.getLastUsedWrapper() != null) {
                ByteBufHelper.clear(buffer);
                packetReceiveEvent.getLastUsedWrapper().writeVarInt(packetReceiveEvent.getPacketId());
                packetReceiveEvent.getLastUsedWrapper().write();
            } else {
                ByteBufHelper.readerIndex(buffer, preProcessIndex);
            }
        } else {
            ByteBufHelper.clear(buffer);
        }
        if (packetReceiveEvent.hasPostTasks()) {
            for (Runnable task : packetReceiveEvent.getPostTasks()) {
                task.run();
            }
        }
        return packetReceiveEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleDisconnection(Object channel, @Nullable UUID uuid) {
        Object object = channel;
        synchronized (object) {
            User user = PacketEvents.getAPI().getProtocolManager().getUser(channel);
            if (user != null) {
                UserDisconnectEvent disconnectEvent = new UserDisconnectEvent(user);
                PacketEvents.getAPI().getEventManager().callEvent(disconnectEvent);
                PacketEvents.getAPI().getProtocolManager().removeUser(user.getChannel());
            }
            if (uuid == null) {
                ProtocolManager.CHANNELS.entrySet().removeIf(pair -> pair.getValue() == channel);
            } else {
                ProtocolManager.CHANNELS.remove(uuid);
            }
        }
    }
}

