/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.lib.packetevents.util.mappings;

import java.util.Map;
import me.mochibit.lib.packetevents.util.mappings.Diff;

public abstract class MapDiff<K, V>
implements Diff<Map<K, V>> {
    private final K key;

    public MapDiff(K key2) {
        this.key = key2;
    }

    public K getKey() {
        return this.key;
    }

    @Override
    public abstract void applyTo(Map<K, V> var1);

    public static class Removal<K, V>
    extends MapDiff<K, V> {
        public Removal(K key2) {
            super(key2);
        }

        @Override
        public void applyTo(Map<K, V> map2) {
            map2.remove(this.getKey());
        }

        public String toString() {
            return "- " + this.getKey();
        }
    }

    public static class Addition<K, V>
    extends MapDiff<K, V> {
        private final V value;

        public Addition(K key2, V value) {
            super(key2);
            this.value = value;
        }

        public V getValue() {
            return this.value;
        }

        @Override
        public void applyTo(Map<K, V> map2) {
            map2.put(this.getKey(), this.getValue());
        }

        public String toString() {
            return "+ " + this.getKey() + " : " + this.getValue();
        }
    }
}

