/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.lib.packetevents.util.mappings;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import me.mochibit.lib.packetevents.protocol.nbt.NBT;
import me.mochibit.lib.packetevents.protocol.nbt.NBTNumber;
import me.mochibit.lib.packetevents.protocol.nbt.NBTString;
import me.mochibit.lib.packetevents.protocol.nbt.NBTType;
import me.mochibit.lib.packetevents.protocol.nbt.serializer.SequentialNBTReader;
import me.mochibit.lib.packetevents.protocol.player.ClientVersion;
import me.mochibit.lib.packetevents.resources.ResourceLocation;
import me.mochibit.lib.packetevents.util.VersionMapper;
import me.mochibit.lib.packetevents.util.mappings.ListDiff;
import me.mochibit.lib.packetevents.util.mappings.MapDiff;
import me.mochibit.lib.packetevents.util.mappings.MappingHelper;
import me.mochibit.lib.packetevents.util.mappings.TypesBuilderData;
import me.mochibit.lib.packetevents.util.mappings.VersionedRegistry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class TypesBuilder {
    private final String mapPath;
    private Map<ClientVersion, Map<String, Integer>> entries = new HashMap<ClientVersion, Map<String, Integer>>();
    private VersionMapper versionMapper;
    @Nullable
    VersionedRegistry<?> registry;

    public TypesBuilder(String mapPath, boolean lazy) {
        this.mapPath = mapPath;
        if (!lazy) {
            this.load();
        }
    }

    public TypesBuilder(String mapPath) {
        this(mapPath, false);
    }

    public void load() {
        try (SequentialNBTReader.Compound compound = MappingHelper.decompress("mappings/" + this.mapPath);){
            compound.skipOne();
            int length = ((NBTNumber)compound.next().getValue()).getAsInt();
            SequentialNBTReader.Compound entries2 = (SequentialNBTReader.Compound)compound.next().getValue();
            ClientVersion[] versions = new ClientVersion[length];
            Object first2 = entries2.next();
            if (((NBT)first2.getValue()).getType() == NBTType.LIST) {
                this.loadAsArray((Map.Entry<String, NBT>)first2, entries2, versions);
            } else {
                this.loadAsMap((Map.Entry<String, NBT>)first2, entries2, versions);
            }
            this.versionMapper = new VersionMapper(versions);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load mapping files.", e);
        }
    }

    private void loadAsArray(Map.Entry<String, NBT> first2, SequentialNBTReader.Compound entries2, ClientVersion[] versions) {
        ClientVersion start2;
        versions[0] = start2 = ClientVersion.valueOf(first2.getKey());
        ArrayList<String> lastEntries = new ArrayList<String>();
        for (NBT entry : (SequentialNBTReader.List)first2.getValue()) {
            lastEntries.add(((NBTString)entry).getValue());
        }
        Consumer<ClientVersion> mapLoader = version -> {
            HashMap<String, Integer> map2 = new HashMap<String, Integer>();
            for (int i = 0; i < lastEntries.size(); ++i) {
                map2.put((String)lastEntries.get(i), i);
            }
            this.entries.put((ClientVersion)((Object)version), (Map<String, Integer>)map2);
        };
        mapLoader.accept(start2);
        int i = 1;
        for (Map.Entry<String, NBT> entry : entries2) {
            ClientVersion version2 = ClientVersion.valueOf(entry.getKey());
            versions[i++] = version2;
            List<ListDiff<String>> diff = MappingHelper.createListDiff((SequentialNBTReader.Compound)entry.getValue());
            for (int j = diff.size() - 1; j >= 0; --j) {
                diff.get(j).applyTo(lastEntries);
            }
            mapLoader.accept(version2);
        }
    }

    private void loadAsMap(Map.Entry<String, NBT> first2, SequentialNBTReader.Compound entries2, ClientVersion[] versions) {
        ClientVersion start2;
        versions[0] = start2 = ClientVersion.valueOf(first2.getKey());
        Map<String, Integer> lastEntries = StreamSupport.stream(((SequentialNBTReader.Compound)first2.getValue()).spliterator(), false).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((NBTNumber)entry.getValue()).getAsInt()));
        Consumer<ClientVersion> mapLoader = version -> {
            HashMap map2 = new HashMap(lastEntries);
            this.entries.put((ClientVersion)((Object)version), map2);
        };
        mapLoader.accept(start2);
        int i = 1;
        for (Map.Entry<String, NBT> entry2 : entries2) {
            ClientVersion version2 = ClientVersion.valueOf(entry2.getKey());
            versions[i++] = version2;
            List<MapDiff<String, Integer>> diff = MappingHelper.createDiff((SequentialNBTReader.Compound)entry2.getValue());
            for (MapDiff<String, Integer> d : diff) {
                d.applyTo(lastEntries);
            }
            mapLoader.accept(version2);
        }
    }

    @ApiStatus.Internal
    @Nullable
    public VersionedRegistry<?> getRegistry() {
        return this.registry;
    }

    public ClientVersion[] getVersions() {
        return this.versionMapper.getVersions();
    }

    public ClientVersion[] getReversedVersions() {
        return this.versionMapper.getReversedVersions();
    }

    public int getDataIndex(ClientVersion rawVersion) {
        return this.versionMapper.getIndex(rawVersion);
    }

    public void unloadFileMappings() {
        this.entries.clear();
        this.entries = null;
    }

    public TypesBuilderData define(String key2) {
        ResourceLocation name = new ResourceLocation(key2);
        int[] ids = new int[this.getVersions().length];
        int index = 0;
        for (ClientVersion v : this.getVersions()) {
            int id;
            Map<String, Integer> map2 = this.entries.get((Object)v);
            ids[index] = map2.containsKey(key2) ? (id = map2.get(key2).intValue()) : -1;
            ++index;
        }
        return new TypesBuilderData(this, name, ids);
    }
}

