/*
 * Decompiled with CFR 0.152.
 */
package me.mochibit.lib.packetevents.util.mappings;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import me.mochibit.lib.packetevents.protocol.mapper.MappedEntity;
import me.mochibit.lib.packetevents.protocol.player.ClientVersion;
import me.mochibit.lib.packetevents.resources.ResourceLocation;
import me.mochibit.lib.packetevents.util.mappings.IRegistry;
import me.mochibit.lib.packetevents.util.mappings.MappingHelper;
import me.mochibit.lib.packetevents.util.mappings.TypesBuilder;
import me.mochibit.lib.packetevents.util.mappings.TypesBuilderData;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class VersionedRegistry<T extends MappedEntity>
implements IRegistry<T> {
    private final ResourceLocation registryKey;
    private final TypesBuilder typesBuilder;
    private final Map<String, T> typeMap = new HashMap<String, T>();
    private final Map<Byte, Map<Integer, T>> typeIdMap = new HashMap<Byte, Map<Integer, T>>();

    public VersionedRegistry(String registry, String mappingsPath) {
        this(new ResourceLocation(registry), mappingsPath);
    }

    public VersionedRegistry(ResourceLocation registryKey, String mappingsPath) {
        this.registryKey = registryKey;
        this.typesBuilder = new TypesBuilder(mappingsPath);
        this.typesBuilder.registry = this;
    }

    @ApiStatus.Internal
    public <Z extends T> Z define(String name, Function<TypesBuilderData, Z> builder) {
        MappedEntity instance = (MappedEntity)builder.apply(this.typesBuilder.define(name));
        MappingHelper.registerMapping(this.typesBuilder, this.typeMap, this.typeIdMap, instance);
        return (Z)instance;
    }

    @ApiStatus.Internal
    public void unloadMappings() {
        this.typesBuilder.unloadFileMappings();
    }

    @Override
    @Nullable
    public T getByName(ResourceLocation name) {
        return (T)((MappedEntity)this.typeMap.get(name.toString()));
    }

    @Override
    @Nullable
    public T getByName(String name) {
        return (T)((MappedEntity)this.typeMap.get(ResourceLocation.normString(name)));
    }

    @Override
    @Nullable
    public T getById(ClientVersion version, int id) {
        int index = this.typesBuilder.getDataIndex(version);
        Map<Integer, T> idMap = this.typeIdMap.get((byte)index);
        return (T)((MappedEntity)idMap.get(id));
    }

    @Override
    public int getId(MappedEntity entity, ClientVersion version) {
        return entity.getId(version);
    }

    @Override
    public Collection<T> getEntries() {
        return Collections.unmodifiableCollection(this.typeMap.values());
    }

    @Override
    public ResourceLocation getRegistryKey() {
        return this.registryKey;
    }

    public String toString() {
        return "VersionedRegistry[" + this.registryKey + ']';
    }
}

