/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.nbt;

import java.util.Map;
import java.util.function.Consumer;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.ByteArrayBinaryTag;
import net.kyori.adventure.nbt.ByteBinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.DoubleBinaryTag;
import net.kyori.adventure.nbt.FloatBinaryTag;
import net.kyori.adventure.nbt.IntArrayBinaryTag;
import net.kyori.adventure.nbt.IntBinaryTag;
import net.kyori.adventure.nbt.LongArrayBinaryTag;
import net.kyori.adventure.nbt.LongBinaryTag;
import net.kyori.adventure.nbt.ShortBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CompoundTagSetter<R> {
    @NotNull
    public R put(@NotNull String var1, @NotNull BinaryTag var2);

    @NotNull
    public R put(@NotNull CompoundBinaryTag var1);

    @NotNull
    public R put(@NotNull Map<String, ? extends BinaryTag> var1);

    @NotNull
    default public R remove(@NotNull String key2) {
        return this.remove(key2, null);
    }

    @NotNull
    public R remove(@NotNull String var1, @Nullable Consumer<? super BinaryTag> var2);

    @NotNull
    default public R putBoolean(@NotNull String key2, boolean value) {
        return this.put(key2, value ? ByteBinaryTag.ONE : ByteBinaryTag.ZERO);
    }

    @NotNull
    default public R putByte(@NotNull String key2, byte value) {
        return this.put(key2, ByteBinaryTag.byteBinaryTag(value));
    }

    @NotNull
    default public R putShort(@NotNull String key2, short value) {
        return this.put(key2, ShortBinaryTag.shortBinaryTag(value));
    }

    @NotNull
    default public R putInt(@NotNull String key2, int value) {
        return this.put(key2, IntBinaryTag.intBinaryTag(value));
    }

    @NotNull
    default public R putLong(@NotNull String key2, long value) {
        return this.put(key2, LongBinaryTag.longBinaryTag(value));
    }

    @NotNull
    default public R putFloat(@NotNull String key2, float value) {
        return this.put(key2, FloatBinaryTag.floatBinaryTag(value));
    }

    @NotNull
    default public R putDouble(@NotNull String key2, double value) {
        return this.put(key2, DoubleBinaryTag.doubleBinaryTag(value));
    }

    @NotNull
    default public R putByteArray(@NotNull String key2, byte @NotNull [] value) {
        return this.put(key2, ByteArrayBinaryTag.byteArrayBinaryTag(value));
    }

    @NotNull
    default public R putString(@NotNull String key2, @NotNull String value) {
        return this.put(key2, StringBinaryTag.stringBinaryTag(value));
    }

    @NotNull
    default public R putIntArray(@NotNull String key2, int @NotNull [] value) {
        return this.put(key2, IntArrayBinaryTag.intArrayBinaryTag(value));
    }

    @NotNull
    default public R putLongArray(@NotNull String key2, long @NotNull [] value) {
        return this.put(key2, LongArrayBinaryTag.longArrayBinaryTag(value));
    }
}

