/*
 * Decompiled with CFR 0.152.
 */
package net.countered.pushaway;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.TickEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.countered.pushaway.PushEventPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public final class ExampleMod {
    public static final String MOD_ID = "push_away";
    private static final Map<Player, Long> pushCooldowns = new HashMap<Player, Long>();
    private static final int COOLDOWN_TICKS = 5;
    private static final int PUSH_DURATION_TICKS = 40;
    public static final Map<UUID, Integer> PUSHED_PLAYERS = new HashMap<UUID, Integer>();

    public static void init() {
        InteractionEvent.INTERACT_ENTITY.register((player, entity, hand) -> {
            MinecraftServer server = player.m_20194_();
            if (server == null || !(entity instanceof ServerPlayer)) {
                return EventResult.pass();
            }
            ServerPlayer targetPlayer = (ServerPlayer)entity;
            if (ExampleMod.canPush(player, server)) {
                ExampleMod.pushEntity(player, (Entity)targetPlayer);
                ExampleMod.setPushCooldown(player, server);
                ExampleMod.playPushSound(player);
                return EventResult.interruptTrue();
            }
            return EventResult.pass();
        });
        TickEvent.SERVER_PRE.register(server -> {
            Iterator<Map.Entry<UUID, Integer>> iterator = PUSHED_PLAYERS.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<UUID, Integer> entry = iterator.next();
                UUID playerUuid = entry.getKey();
                int ticksLeft = entry.getValue();
                ServerPlayer player = server.m_6846_().m_11259_(playerUuid);
                if (player != null) {
                    if (ticksLeft > 0) {
                        player.m_20124_(Pose.SWIMMING);
                        player.m_20282_(true);
                        PushEventPacket.sendCrawl((Player)player);
                        entry.setValue(ticksLeft - 1);
                        continue;
                    }
                    player.m_20124_(Pose.STANDING);
                    player.m_20282_(false);
                    iterator.remove();
                    continue;
                }
                iterator.remove();
            }
        });
    }

    private static void playPushSound(Player player) {
        player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12315_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private static void pushEntity(Player pusher, Entity target) {
        PushEventPacket.sendSwing(pusher);
        Vec3 direction = target.m_20182_().m_82546_(pusher.m_20182_()).m_82541_().m_82559_(new Vec3(1.2, 1.2, 1.2));
        target.m_5997_(direction.f_82479_, 0.1, direction.f_82481_);
        target.f_19864_ = true;
        PUSHED_PLAYERS.put(target.m_20148_(), 40);
    }

    private static boolean canPush(Player player, MinecraftServer server) {
        long currentTick = server.m_129921_();
        return !pushCooldowns.containsKey(player) || currentTick - pushCooldowns.get(player) >= 5L;
    }

    private static void setPushCooldown(Player player, MinecraftServer server) {
        long currentTick = server.m_129921_();
        pushCooldowns.put(player, currentTick);
    }
}

