/*
 * Decompiled with CFR 0.152.
 */
package com.test;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.test.ConfigManager;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class AIChatClient {
    private static final String API_URL = "https://api.groq.com/openai/v1/chat/completions";

    public static void askAIStream(String prompt, List<String> messages, Consumer<String> onUpdate) {
        new Thread(() -> {
            try {
                String apiKey = ConfigManager.getApiKey();
                String model = ConfigManager.getModel();
                String prompt_msg = ConfigManager.getPrompt();
                JsonObject payload = new JsonObject();
                payload.addProperty("model", model);
                payload.addProperty("temperature", (Number)0.7);
                payload.addProperty("max_tokens", (Number)2048);
                payload.addProperty("stream", Boolean.valueOf(true));
                JsonArray chatMessages = new JsonArray();
                JsonObject systemMsg = new JsonObject();
                systemMsg.addProperty("role", "system");
                systemMsg.addProperty("content", prompt_msg);
                chatMessages.add((JsonElement)systemMsg);
                for (String msg : messages) {
                    JsonObject messageObj = new JsonObject();
                    if (msg.startsWith("You:")) {
                        messageObj.addProperty("role", "user");
                        messageObj.addProperty("content", msg.substring(4).trim());
                    } else if (msg.startsWith("AI:")) {
                        messageObj.addProperty("role", "assistant");
                        messageObj.addProperty("content", msg.substring(3).trim());
                    } else {
                        messageObj.addProperty("role", "user");
                        messageObj.addProperty("content", msg);
                    }
                    chatMessages.add((JsonElement)messageObj);
                }
                JsonObject userMsg = new JsonObject();
                userMsg.addProperty("role", "user");
                userMsg.addProperty("content", prompt);
                chatMessages.add((JsonElement)userMsg);
                payload.add("messages", (JsonElement)chatMessages);
                HttpURLConnection conn = (HttpURLConnection)new URL(API_URL).openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "application/json");
                conn.setRequestProperty("Authorization", "Bearer " + apiKey);
                conn.setDoOutput(true);
                try (OutputStream os = conn.getOutputStream();){
                    os.write(payload.toString().getBytes(StandardCharsets.UTF_8));
                }
                int status = conn.getResponseCode();
                if (status >= 400) {
                    InputStream err = conn.getErrorStream();
                    String errorText = new String(err.readAllBytes(), StandardCharsets.UTF_8);
                    onUpdate.accept("\u274c API error " + status + ": " + errorText);
                    return;
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                    String line;
                    StringBuilder fullText = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        if (!line.startsWith("data: ")) continue;
                        String data = line.substring(6).trim();
                        if (data.equals("[DONE]")) {
                            break;
                        }
                        JsonObject obj = JsonParser.parseString((String)data).getAsJsonObject();
                        JsonObject delta = obj.getAsJsonArray("choices").get(0).getAsJsonObject().getAsJsonObject("delta");
                        if (!delta.has("content")) continue;
                        String chunk = delta.get("content").getAsString();
                        fullText.append(chunk);
                        class_310.method_1551().execute(() -> onUpdate.accept(fullText.toString()));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                onUpdate.accept("Error: " + e.getMessage());
            }
        }).start();
    }
}

