/*
 * Decompiled with CFR 0.152.
 */
package com.test;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.test.ConfigManager;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class AIChatClient {
    private static final String API_URL = "https://api.groq.com/openai/v1/chat/completions";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String askAI(String prompt, List<String> messages) {
        try {
            String apiKey = ConfigManager.getApiKey();
            String model = ConfigManager.getModel();
            String prompt_msg = ConfigManager.getPrompt();
            JsonObject payload = new JsonObject();
            payload.addProperty("model", model);
            payload.addProperty("temperature", (Number)0.7);
            payload.addProperty("max_tokens", (Number)2048);
            payload.addProperty("stream", Boolean.valueOf(false));
            JsonArray chatMessages = new JsonArray();
            JsonObject systemMsg = new JsonObject();
            systemMsg.addProperty("role", "system");
            systemMsg.addProperty("content", prompt_msg);
            chatMessages.add((JsonElement)systemMsg);
            for (String msg : messages) {
                JsonObject messageObj = new JsonObject();
                if (msg.startsWith("You:")) {
                    messageObj.addProperty("role", "user");
                    messageObj.addProperty("content", msg.substring(4).trim());
                } else if (msg.startsWith("AI:")) {
                    messageObj.addProperty("role", "assistant");
                    messageObj.addProperty("content", msg.substring(3).trim());
                } else {
                    messageObj.addProperty("role", "user");
                    messageObj.addProperty("content", msg);
                }
                chatMessages.add((JsonElement)messageObj);
            }
            JsonObject userMsg = new JsonObject();
            userMsg.addProperty("role", "user");
            userMsg.addProperty("content", prompt);
            chatMessages.add((JsonElement)userMsg);
            payload.add("messages", (JsonElement)chatMessages);
            HttpURLConnection conn = (HttpURLConnection)new URL(API_URL).openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Authorization", "Bearer " + apiKey);
            conn.setDoOutput(true);
            try (OutputStream os = conn.getOutputStream();){
                os.write(payload.toString().getBytes(StandardCharsets.UTF_8));
            }
            int status = conn.getResponseCode();
            InputStream stream = status >= 400 ? conn.getErrorStream() : conn.getInputStream();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    response.append(line);
                }
                if (status >= 400) {
                    String string = "\u274c API error " + status + ": " + String.valueOf(response);
                    return string;
                }
                JsonObject json = JsonParser.parseString((String)response.toString()).getAsJsonObject();
                JsonArray choices = json.getAsJsonArray("choices");
                if (choices == null || choices.size() == 0) {
                    String string = "No reply.";
                    return string;
                }
                JsonObject message = choices.get(0).getAsJsonObject().getAsJsonObject("message");
                String string = message.get("content").getAsString().trim();
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Error: " + e.getMessage();
        }
    }
}

