/*
 * Decompiled with CFR 0.152.
 */
package com.test;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.test.AIChatClient;
import com.test.AISettingsScreen;
import com.test.TextUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

@Environment(value=EnvType.CLIENT)
public class AIChatScreen
extends class_437 {
    private class_342 inputField;
    private class_4185 sendButton;
    private class_4185 newChatButton;
    private class_4185 settingsButton;
    private class_4185 copyButton;
    private final List<String> messages = new ArrayList<String>();
    private int aiIndex = this.messages.size() - 1;
    private float scrollOffset = 0.0f;
    private float totalChatHeight = 0.0f;
    private static final Path SAVE_PATH = Paths.get(System.getProperty("user.home"), ".minecraft", "aichat_conversation.json");

    public AIChatScreen() {
        super((class_2561)class_2561.method_43470((String)"AI Chat"));
        this.loadConversation();
    }

    protected void method_25426() {
        int textFieldHeight = 20;
        this.inputField = new class_342(this.field_22793, 20, this.field_22790 - textFieldHeight - 20, this.field_22789 - 200, textFieldHeight, (class_2561)class_2561.method_43470((String)"Type a message..."));
        this.inputField.method_1880(2048);
        this.sendButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Send"), button -> this.sendMessage()).method_46434(this.field_22789 - 170, this.field_22790 - textFieldHeight - 20, 70, textFieldHeight).method_46431();
        this.newChatButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"New Chat"), button -> this.clearConversation()).method_46434(this.field_22789 - 90, this.field_22790 - textFieldHeight - 20, 70, textFieldHeight).method_46431();
        this.settingsButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2699 Settings"), b -> this.field_22787.method_1507((class_437)new AISettingsScreen(this))).method_46434(this.field_22789 - 90, 10, 80, 20).method_46431();
        this.copyButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udccb"), b -> class_310.method_1551().field_1774.method_1455(this.messages.get(this.aiIndex))).method_46434(this.field_22789 - 70, this.field_22790 - textFieldHeight - 20, 10, 10).method_46431();
        this.method_37063((class_364)this.copyButton);
        this.method_37063((class_364)this.inputField);
        this.method_37063((class_364)this.sendButton);
        this.method_37063((class_364)this.newChatButton);
        this.method_37063((class_364)this.settingsButton);
        this.scrollOffset = Math.max(0.0f, this.calculateChatHeight() - (float)(this.field_22790 - 80));
    }

    private void sendMessage() {
        String userInput = this.inputField.method_1882().trim();
        if (!userInput.isEmpty()) {
            this.messages.add("You: " + userInput);
            this.inputField.method_1852("");
            this.saveConversation();
            boolean wasAtBottom = this.isAtBottom();
            this.messages.add("AI: ");
            this.aiIndex = this.messages.size() - 1;
            AIChatClient.askAIStream(userInput, this.messages, partial -> {
                List<String> list = this.messages;
                synchronized (list) {
                    this.messages.set(this.aiIndex, "AI: " + partial);
                    if (wasAtBottom) {
                        this.scrollOffset = Math.max(0.0f, this.calculateChatHeight() - (float)(this.field_22790 - 80));
                    }
                }
            });
            new Thread(() -> {
                try {
                    Thread.sleep(500L);
                    this.saveConversation();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }).start();
        }
    }

    private void clearConversation() {
        this.messages.clear();
        this.scrollOffset = 0.0f;
        this.deleteSavedConversation();
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        this.totalChatHeight = this.calculateChatHeight();
        this.scrollOffset = (float)((double)this.scrollOffset - verticalAmount * 15.0);
        this.scrollOffset = Math.max(0.0f, Math.min(this.scrollOffset, Math.max(0.0f, this.totalChatHeight - (float)(this.field_22790 - 80))));
        return true;
    }

    private boolean isAtBottom() {
        int visibleHeight;
        double totalHeight = this.calculateChatHeight();
        return (double)this.scrollOffset >= totalHeight - (double)(visibleHeight = this.field_22790 - 80) - 12.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float calculateChatHeight() {
        int chatWidth = this.field_22789 - 40;
        float heightSum = 0.0f;
        List<String> list = this.messages;
        synchronized (list) {
            for (String msg : this.messages) {
                class_5250 text = TextUtils.parseFormatted(msg);
                List wrapped = this.field_22793.method_1728((class_5348)text, chatWidth);
                heightSum += (float)(wrapped.size() * 12 + 6);
            }
        }
        return heightSum;
    }

    public boolean method_25404(class_11908 keyInput) {
        if (keyInput.method_74230()) {
            this.sendMessage();
            return true;
        }
        return super.method_25404(keyInput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_25294(0, 0, this.field_22789, this.field_22790, 0x66000000);
        int chatX = 20;
        int chatWidth = this.field_22789 - 40;
        int y = 40 - (int)this.scrollOffset;
        List<String> list = this.messages;
        synchronized (list) {
            for (String msg : this.messages) {
                int color = msg.startsWith("You:") ? -11141291 : -11141121;
                class_5250 text = TextUtils.parseFormatted(msg);
                List wrappedLines = this.field_22793.method_1728((class_5348)text, chatWidth);
                for (class_5481 line : wrappedLines) {
                    if (y > -12 && y < this.field_22790 - 40) {
                        context.method_35720(this.field_22793, line, chatX, y, color);
                    }
                    y += 12;
                }
                y += 6;
            }
        }
        this.inputField.method_25394(context, mouseX, mouseY, delta);
    }

    public boolean method_25421() {
        return false;
    }

    private void saveConversation() {
        try {
            Files.createDirectories(SAVE_PATH.getParent(), new FileAttribute[0]);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson(this.messages);
            Files.writeString(SAVE_PATH, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadConversation() {
        try {
            String json;
            Gson gson;
            List saved;
            if (Files.exists(SAVE_PATH, new LinkOption[0]) && (saved = (List)(gson = new Gson()).fromJson(json = Files.readString(SAVE_PATH), List.class)) != null) {
                this.messages.addAll(saved);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void deleteSavedConversation() {
        try {
            Files.deleteIfExists(SAVE_PATH);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

