/*
 * Decompiled with CFR 0.152.
 */
package com.test;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.test.ApiKeyLoader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class ConfigManager {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("aichat-config.json");
    private static final String EMBEDDED_API_KEY;
    private static final String EMBEDDED_MODEL = "openai/gpt-oss-120b";
    private static String apiKey;
    private static String model;
    private static String prompt;

    public static void load() {
        try {
            String cfgPrompt;
            if (Files.notExists(CONFIG_PATH.getParent(), new LinkOption[0])) {
                Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            }
            if (Files.notExists(CONFIG_PATH, new LinkOption[0])) {
                JsonObject defaultConfig = new JsonObject();
                defaultConfig.addProperty("apiKey", "");
                defaultConfig.addProperty("model", "");
                defaultConfig.addProperty("prompt", prompt);
                ConfigManager.saveJson(defaultConfig);
                return;
            }
            String json = Files.readString(CONFIG_PATH, StandardCharsets.UTF_8);
            JsonObject obj = JsonParser.parseString((String)json).getAsJsonObject();
            String key = obj.has("apiKey") ? obj.get("apiKey").getAsString().trim() : "";
            String cfgModel = obj.has("model") ? obj.get("model").getAsString().trim() : "";
            String string = cfgPrompt = obj.has("prompt") ? obj.get("prompt").getAsString().trim() : "";
            if (!key.isEmpty()) {
                apiKey = key;
            }
            if (!cfgModel.isEmpty()) {
                model = cfgModel;
            }
            if (!cfgPrompt.isEmpty()) {
                prompt = cfgPrompt;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        try {
            JsonObject obj = new JsonObject();
            obj.addProperty("apiKey", apiKey.equals(EMBEDDED_API_KEY) ? "" : apiKey);
            obj.addProperty("model", model.equals(EMBEDDED_MODEL) ? "" : model);
            obj.addProperty("prompt", prompt);
            ConfigManager.saveJson(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void saveJson(JsonObject json) throws IOException {
        Files.writeString(CONFIG_PATH, (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public static String getApiKey() {
        return apiKey;
    }

    public static String getModel() {
        return model;
    }

    public static String getPrompt() {
        return prompt;
    }

    public static void setApiKey(String newKey) {
        apiKey = newKey == null || newKey.isBlank() ? EMBEDDED_API_KEY : newKey.trim();
        ConfigManager.save();
    }

    public static void setModel(String newModel) {
        model = newModel == null || newModel.isBlank() ? EMBEDDED_MODEL : newModel.trim();
        ConfigManager.save();
    }

    public static void resetToDefault() {
        apiKey = EMBEDDED_API_KEY;
        model = EMBEDDED_MODEL;
        ConfigManager.save();
    }

    static {
        apiKey = EMBEDDED_API_KEY = ApiKeyLoader.loadApiKey();
        model = EMBEDDED_MODEL;
        prompt = "You are a helpful assistant.";
    }
}

