/*
 * Decompiled with CFR 0.152.
 */
package com.juanmuscaria.autumn.messages;

import com.juanmuscaria.autumn.messages.AbstractMessageSource;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractResourceBasedMessageSource
extends AbstractMessageSource {
    private final Set<String> basenameSet = new LinkedHashSet<String>(4);
    @Nullable
    private String defaultEncoding;
    private boolean fallbackToSystemLocale = true;
    @Nullable
    private Locale defaultLocale;
    private long cacheMillis = -1L;

    public void setBasename(String basename) {
        this.setBasenames(basename);
    }

    public void setBasenames(String ... basenames) {
        this.basenameSet.clear();
        this.addBasenames(basenames);
    }

    public void addBasenames(String ... basenames) {
        if (!this.isEmpty(basenames)) {
            for (String basename : basenames) {
                if (basename == null || basename.isEmpty()) {
                    throw new IllegalArgumentException("Basename must not be empty");
                }
                this.basenameSet.add(basename.trim());
            }
        }
    }

    public Set<String> getBasenameSet() {
        return this.basenameSet;
    }

    public void setDefaultEncoding(@Nullable String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    @Nullable
    protected String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setFallbackToSystemLocale(boolean fallbackToSystemLocale) {
        this.fallbackToSystemLocale = fallbackToSystemLocale;
    }

    @Deprecated
    protected boolean isFallbackToSystemLocale() {
        return this.fallbackToSystemLocale;
    }

    public void setDefaultLocale(@Nullable Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    @Nullable
    protected Locale getDefaultLocale() {
        if (this.defaultLocale != null) {
            return this.defaultLocale;
        }
        if (this.fallbackToSystemLocale) {
            return Locale.getDefault();
        }
        return null;
    }

    public void setCacheSeconds(int cacheSeconds) {
        this.cacheMillis = (long)cacheSeconds * 1000L;
    }

    public void setCacheMillis(long cacheMillis) {
        this.cacheMillis = cacheMillis;
    }

    protected long getCacheMillis() {
        return this.cacheMillis;
    }
}

